/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.geocoder.service.models;

import android.location.Address;
import com.google.gson.annotations.SerializedName;
import com.mapbox.geocoder.service.models.FeatureContext;
import com.mapbox.geocoder.service.models.FeatureGeometry;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class GeocoderFeature {
    private String id;
    private String type;
    private String text;
    @SerializedName(value="place_name")
    private String placeName;
    private double relevance;
    private List<Double> bbox = new ArrayList<Double>();
    private List<Double> center = new ArrayList<Double>();
    private FeatureGeometry geometry;
    private List<FeatureContext> context = new ArrayList<FeatureContext>();
    public Object properties;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getPlaceName() {
        return this.placeName;
    }

    public void setPlaceName(String placeName) {
        this.placeName = placeName;
    }

    public double getRelevance() {
        return this.relevance;
    }

    public void setRelevance(double relevance) {
        this.relevance = relevance;
    }

    public List<Double> getBbox() {
        return this.bbox;
    }

    public void setBbox(List<Double> bbox) {
        this.bbox = bbox;
    }

    public List<Double> getCenter() {
        return this.center;
    }

    public void setCenter(List<Double> center) {
        this.center = center;
    }

    public FeatureGeometry getGeometry() {
        return this.geometry;
    }

    public void setGeometry(FeatureGeometry geometry) {
        this.geometry = geometry;
    }

    public List<FeatureContext> getContext() {
        return this.context;
    }

    public void setContext(List<FeatureContext> context) {
        this.context = context;
    }

    public Object getProperties() {
        return this.properties;
    }

    public void setProperties(Object properties) {
        this.properties = properties;
    }

    public double getLatitude() {
        return this.getCenter().get(1);
    }

    public double getLongitude() {
        return this.getCenter().get(0);
    }

    public Address toAddress(Locale locale) {
        Address address = new Address(locale);
        address.setAddressLine(0, this.getPlaceName());
        address.setFeatureName(this.getText());
        address.setLongitude(this.getLongitude());
        address.setLatitude(this.getLatitude());
        return address;
    }

    public String toString() {
        return this.getPlaceName();
    }
}

