/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.geocoder.android;

import android.content.Context;
import android.location.Address;
import com.mapbox.geocoder.MapboxGeocoder;
import com.mapbox.geocoder.service.models.GeocoderFeature;
import com.mapbox.geocoder.service.models.GeocoderResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import retrofit.Response;

public class AndroidGeocoder {
    private static final String LOG_TAG = "AndroidGeocoder";
    private Context _context;
    private Locale _locale;
    private String _accessToken;

    public AndroidGeocoder(Context context, Locale locale) {
        this._context = context;
        this._locale = locale;
    }

    public AndroidGeocoder(Context context) {
        this._context = context;
    }

    public static boolean isPresent() {
        return true;
    }

    public List<Address> getFromLocation(double latitude, double longitude, int maxResults) throws IOException {
        ArrayList<Address> addresses = new ArrayList<Address>();
        MapboxGeocoder client = new MapboxGeocoder.Builder().setAccessToken(this._accessToken).setCoordinates(longitude, latitude).build();
        Response<GeocoderResponse> response = client.execute();
        if (!response.isSuccess()) {
            return addresses;
        }
        List<GeocoderFeature> features = ((GeocoderResponse)response.body()).getFeatures();
        if (features.size() > maxResults) {
            features = features.subList(0, maxResults);
        }
        for (GeocoderFeature feature : features) {
            addresses.add(feature.toAddress(this._locale));
        }
        return addresses;
    }

    public List<Address> getFromLocationName(String locationName, int maxResults) throws IOException {
        ArrayList<Address> addresses = new ArrayList<Address>();
        MapboxGeocoder client = new MapboxGeocoder.Builder().setAccessToken(this._accessToken).setLocation(locationName).build();
        Response<GeocoderResponse> response = client.execute();
        if (!response.isSuccess()) {
            return addresses;
        }
        List<GeocoderFeature> features = ((GeocoderResponse)response.body()).getFeatures();
        if (features.size() > maxResults) {
            features = features.subList(0, maxResults);
        }
        for (GeocoderFeature feature : features) {
            addresses.add(feature.toAddress(this._locale));
        }
        return addresses;
    }

    public List<Address> getFromLocationName(String locationName, int maxResults, double lowerLeftLatitude, double lowerLeftLongitude, double upperRightLatitude, double upperRightLongitude) throws IOException {
        ArrayList<Address> addresses = new ArrayList<Address>();
        double proximityLatitude = (lowerLeftLatitude + upperRightLatitude) / 2.0;
        double proximityLongitude = (lowerLeftLongitude + upperRightLongitude) / 2.0;
        MapboxGeocoder client = new MapboxGeocoder.Builder().setAccessToken(this._accessToken).setLocation(locationName).setProximity(proximityLongitude, proximityLatitude).build();
        Response<GeocoderResponse> response = client.execute();
        if (!response.isSuccess()) {
            return addresses;
        }
        List<GeocoderFeature> features = ((GeocoderResponse)response.body()).getFeatures();
        ArrayList<GeocoderFeature> featuresToRemove = new ArrayList<GeocoderFeature>();
        for (GeocoderFeature feature : features) {
            if (feature.getLatitude() < lowerLeftLatitude) {
                featuresToRemove.add(feature);
                continue;
            }
            if (feature.getLatitude() > upperRightLatitude) {
                featuresToRemove.add(feature);
                continue;
            }
            if (feature.getLongitude() < lowerLeftLongitude) {
                featuresToRemove.add(feature);
                continue;
            }
            if (!(feature.getLongitude() > upperRightLongitude)) continue;
            featuresToRemove.add(feature);
        }
        if (featuresToRemove.size() > 0) {
            features.removeAll(featuresToRemove);
        }
        if (features.size() > maxResults) {
            features = features.subList(0, maxResults);
        }
        for (GeocoderFeature feature : features) {
            addresses.add(feature.toAddress(this._locale));
        }
        return addresses;
    }

    public void setAccessToken(String accessToken) {
        this._accessToken = accessToken;
    }
}

