/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.core.metrics;

import android.os.SystemClock;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mapbox.android.core.metrics.Metrics;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AbstractCompositeMetrics {
    private final Map<String, Deque<Metrics>> metricsMap = new ConcurrentHashMap<String, Deque<Metrics>>();
    private final long maxLength;

    public AbstractCompositeMetrics(long maxLength) {
        this.maxLength = maxLength;
    }

    protected abstract Metrics nextMetrics(long var1, long var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String name, long delta) {
        Metrics last;
        long now = SystemClock.uptimeMillis();
        AbstractCompositeMetrics abstractCompositeMetrics = this;
        synchronized (abstractCompositeMetrics) {
            Deque<Metrics> metrics = this.getOrCreateMetrics(name.trim());
            if (now >= metrics.getLast().getEnd()) {
                metrics.add(this.nextMetrics(now, now + this.maxLength));
            }
            last = metrics.getLast();
        }
        last.add(delta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Metrics getMetrics(@NonNull String name) {
        Deque<Metrics> metrics = this.metricsMap.get(name.trim());
        AbstractCompositeMetrics abstractCompositeMetrics = this;
        synchronized (abstractCompositeMetrics) {
            return metrics != null && !metrics.isEmpty() ? metrics.pop() : null;
        }
    }

    @NonNull
    private Deque<Metrics> getOrCreateMetrics(@NonNull String name) {
        Deque<Metrics> metrics = this.metricsMap.get(name);
        if (metrics == null) {
            metrics = new ArrayDeque<Metrics>();
            this.metricsMap.put(name, metrics);
        }
        if (metrics.isEmpty()) {
            long now = SystemClock.uptimeMillis();
            metrics.add(this.nextMetrics(now, now + this.maxLength));
        }
        return metrics;
    }
}

