/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.core.location;

public class LocationEngineRequest {
    public static final int PRIORITY_HIGH_ACCURACY = 0;
    public static final int PRIORITY_BALANCED_POWER_ACCURACY = 1;
    public static final int PRIORITY_LOW_POWER = 2;
    public static final int PRIORITY_NO_POWER = 3;
    private final long interval;
    private final int priority;
    private final float displacement;
    private final long maxWaitTime;
    private final long fastestInterval;

    private LocationEngineRequest(Builder builder) {
        this.interval = builder.interval;
        this.priority = builder.priority;
        this.displacement = builder.displacement;
        this.maxWaitTime = builder.maxWaitTime;
        this.fastestInterval = builder.fastestInterval;
    }

    public long getInterval() {
        return this.interval;
    }

    public int getPriority() {
        return this.priority;
    }

    public float getDisplacement() {
        return this.displacement;
    }

    public long getMaxWaitTime() {
        return this.maxWaitTime;
    }

    public long getFastestInterval() {
        return this.fastestInterval;
    }

    public static final class Builder {
        private final long interval;
        private int priority;
        private float displacement;
        private long maxWaitTime;
        private long fastestInterval;

        public Builder(long interval) {
            this.interval = interval;
            this.priority = 0;
            this.displacement = 0.0f;
            this.maxWaitTime = 0L;
            this.fastestInterval = 0L;
        }

        public Builder setPriority(int priority) {
            this.priority = priority;
            return this;
        }

        public Builder setDisplacement(float displacement) {
            this.displacement = displacement;
            return this;
        }

        public Builder setMaxWaitTime(long maxWaitTime) {
            this.maxWaitTime = maxWaitTime;
            return this;
        }

        public Builder setFastestInterval(long interval) {
            this.fastestInterval = interval;
            return this;
        }

        public LocationEngineRequest build() {
            return new LocationEngineRequest(this);
        }
    }
}

