/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.core.crashreporter;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

public class CrashReport {
    private static final String TAG = "MapboxCrashReport";
    private static final String CRASH_EVENT = "mobile.crash";
    private final JSONObject content;

    CrashReport(Calendar created) {
        this.content = new JSONObject();
        this.put("event", CRASH_EVENT);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ", Locale.US);
        this.put("created", dateFormat.format(created.getTimeInMillis()));
    }

    CrashReport(@NonNull String json) throws JSONException {
        this.content = new JSONObject(json);
    }

    public synchronized void put(@NonNull String key, @Nullable String value) {
        if (value == null) {
            this.putNull(key);
            return;
        }
        try {
            this.content.put(key, (Object)value);
        }
        catch (JSONException je) {
            Log.e((String)TAG, (String)("Failed json encode value: " + String.valueOf(value)));
        }
    }

    @NonNull
    public String getDateString() {
        return this.getString("created");
    }

    @NonNull
    public String toJson() {
        return this.content.toString();
    }

    @VisibleForTesting
    @NonNull
    String getString(@NonNull String key) {
        return this.content.optString(key);
    }

    private void putNull(@NonNull String key) {
        try {
            this.content.put(key, (Object)"null");
        }
        catch (JSONException je) {
            Log.e((String)TAG, (String)"Failed json encode null value");
        }
    }
}

