/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.core;

import android.content.res.AssetManager;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import com.mapbox.android.core.FileUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Locale;

public class MapboxSdkInfoForUserAgentGenerator {
    private static MapboxSdkInfoForUserAgentGenerator userAgentGenerator;
    private String sdkInfoForUserAgent;
    private static final Object lock;
    private static final Locale DEFAULT_LOCALE;
    private static final String USER_AGENT_SDK_VERSION_FORMAT = " %s (%s%s)";
    private static final String MAPBOX_IDENTIFIER = "mapbox";
    private static final String EMPTY_STRING = "";
    private static final String SDK_VERSIONS_FOLDER = "sdk_versions";
    private static final String LOG_TAG = "MapboxUAGenerator";

    private MapboxSdkInfoForUserAgentGenerator(AssetManager assetManager) {
        this.sdkInfoForUserAgent = this.getMapboxSdkIdentifiersForUserAgent(assetManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MapboxSdkInfoForUserAgentGenerator getInstance(@NonNull AssetManager assetManager) {
        if (userAgentGenerator == null) {
            Object object = lock;
            synchronized (object) {
                userAgentGenerator = new MapboxSdkInfoForUserAgentGenerator(assetManager);
            }
        }
        return userAgentGenerator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    String getMapboxSdkIdentifiersForUserAgent(@NonNull AssetManager assetManager) {
        StringBuilder stringBuilder = new StringBuilder(EMPTY_STRING);
        try {
            String[] files = assetManager.list(SDK_VERSIONS_FOLDER);
            if (files != null) {
                for (String fileName : files) {
                    if (!fileName.contains(MAPBOX_IDENTIFIER)) continue;
                    InputStream inputStream = null;
                    try {
                        String subInfo;
                        inputStream = assetManager.open(SDK_VERSIONS_FOLDER + File.separator + fileName);
                        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                        String nameAndVersion = reader.readLine();
                        nameAndVersion = nameAndVersion != null ? nameAndVersion : EMPTY_STRING;
                        StringBuilder sdkSubInfo = new StringBuilder(EMPTY_STRING);
                        while ((subInfo = reader.readLine()) != null) {
                            sdkSubInfo.append("; ");
                            sdkSubInfo.append(subInfo);
                        }
                        reader.close();
                        stringBuilder.append(String.format(DEFAULT_LOCALE, USER_AGENT_SDK_VERSION_FORMAT, nameAndVersion, fileName, sdkSubInfo.toString()));
                        FileUtils.closeQuietly(inputStream);
                    }
                    catch (IOException exception) {
                        Log.e((String)LOG_TAG, (String)exception.toString());
                    }
                    finally {
                        FileUtils.closeQuietly(inputStream);
                    }
                }
            }
        }
        catch (IOException exception) {
            Log.e((String)LOG_TAG, (String)exception.toString());
        }
        return stringBuilder.toString().trim();
    }

    public String getSdkInfoForUserAgent() {
        return this.sdkInfoForUserAgent;
    }

    static {
        lock = new Object();
        DEFAULT_LOCALE = Locale.US;
    }
}

