/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.core.metrics;

import com.mapbox.android.core.metrics.Metrics;
import java.util.concurrent.atomic.AtomicLong;

public class MetricsImpl
implements Metrics {
    private final long start;
    private final long end;
    private final AtomicLong value;

    MetricsImpl(long start, long end, long initialValue) {
        if (start > end) {
            this.start = end;
            this.end = start;
        } else {
            this.start = start;
            this.end = end;
        }
        this.value = new AtomicLong(initialValue);
    }

    public MetricsImpl(long start, long end) {
        this(start, end, 0L);
    }

    @Override
    public void add(long delta) {
        this.value.addAndGet(delta);
    }

    @Override
    public long getValue() {
        return this.value.get();
    }

    @Override
    public long getStart() {
        return this.start;
    }

    @Override
    public long getEnd() {
        return this.end;
    }
}

