/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.core.location;

import android.annotation.SuppressLint;
import android.app.PendingIntent;
import android.content.Context;
import android.location.Location;
import android.location.LocationListener;
import android.os.Bundle;
import android.os.Looper;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mapbox.android.core.location.AndroidLocationEngineImpl;
import com.mapbox.android.core.location.LocationEngineCallback;
import com.mapbox.android.core.location.LocationEngineRequest;
import com.mapbox.android.core.location.LocationEngineResult;
import com.mapbox.android.core.location.Utils;

class MapboxFusedLocationEngineImpl
extends AndroidLocationEngineImpl {
    private static final String TAG = "MapboxLocationEngine";

    MapboxFusedLocationEngineImpl(@NonNull Context context) {
        super(context);
    }

    @Override
    @NonNull
    public LocationListener createListener(LocationEngineCallback<LocationEngineResult> callback) {
        return new MapboxLocationEngineCallbackTransport(callback);
    }

    @Override
    public void getLastLocation(@NonNull LocationEngineCallback<LocationEngineResult> callback) throws SecurityException {
        Location bestLastLocation = this.getBestLastLocation();
        if (bestLastLocation != null) {
            callback.onSuccess(LocationEngineResult.create(bestLastLocation));
        } else {
            callback.onFailure(new Exception("Last location unavailable"));
        }
    }

    @Override
    @SuppressLint(value={"MissingPermission"})
    public void requestLocationUpdates(@NonNull LocationEngineRequest request, @NonNull LocationListener listener, @Nullable Looper looper) throws SecurityException {
        super.requestLocationUpdates(request, listener, looper);
        if (this.shouldStartNetworkProvider(request.getPriority())) {
            try {
                this.locationManager.requestLocationUpdates("network", request.getInterval(), request.getDisplacement(), listener, looper);
            }
            catch (IllegalArgumentException iae) {
                iae.printStackTrace();
            }
        }
    }

    @Override
    @SuppressLint(value={"MissingPermission"})
    public void requestLocationUpdates(@NonNull LocationEngineRequest request, @NonNull PendingIntent pendingIntent) throws SecurityException {
        super.requestLocationUpdates(request, pendingIntent);
        if (this.shouldStartNetworkProvider(request.getPriority())) {
            try {
                this.locationManager.requestLocationUpdates("network", request.getInterval(), request.getDisplacement(), pendingIntent);
            }
            catch (IllegalArgumentException iae) {
                iae.printStackTrace();
            }
        }
    }

    private Location getBestLastLocation() {
        Location bestLastLocation = null;
        for (String provider : this.locationManager.getAllProviders()) {
            Location location = this.getLastLocationFor(provider);
            if (location == null || !Utils.isBetterLocation(location, bestLastLocation)) continue;
            bestLastLocation = location;
        }
        return bestLastLocation;
    }

    private boolean shouldStartNetworkProvider(int priority) {
        return (priority == 0 || priority == 1) && this.currentProvider.equals("gps");
    }

    private static final class MapboxLocationEngineCallbackTransport
    implements LocationListener {
        private final LocationEngineCallback<LocationEngineResult> callback;
        private Location currentBestLocation;

        MapboxLocationEngineCallbackTransport(LocationEngineCallback<LocationEngineResult> callback) {
            this.callback = callback;
        }

        public void onLocationChanged(Location location) {
            if (Utils.isBetterLocation(location, this.currentBestLocation)) {
                this.currentBestLocation = location;
            }
            if (this.callback != null) {
                this.callback.onSuccess(LocationEngineResult.create(this.currentBestLocation));
            }
        }

        public void onStatusChanged(String provider, int status, Bundle extras) {
            Log.d((String)MapboxFusedLocationEngineImpl.TAG, (String)("onStatusChanged: " + provider));
        }

        public void onProviderEnabled(String provider) {
            Log.d((String)MapboxFusedLocationEngineImpl.TAG, (String)("onProviderEnabled: " + provider));
        }

        public void onProviderDisabled(String provider) {
            Log.d((String)MapboxFusedLocationEngineImpl.TAG, (String)("onProviderDisabled: " + provider));
        }
    }
}

