/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.core.crashreporter;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.mapbox.android.core.FileUtils;
import com.mapbox.android.core.crashreporter.CrashReport;
import com.mapbox.android.core.crashreporter.CrashReportBuilder;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class MapboxUncaughtExceptionHanlder
implements Thread.UncaughtExceptionHandler,
SharedPreferences.OnSharedPreferenceChangeListener {
    public static final String MAPBOX_PREF_ENABLE_CRASH_REPORTER = "mapbox.crash.enable";
    public static final String MAPBOX_CRASH_REPORTER_PREFERENCES = "MapboxCrashReporterPrefs";
    private static final String TAG = "MbUncaughtExcHandler";
    private static final String CRASH_FILENAME_FORMAT = "%s/%s.crash";
    private static final int DEFAULT_EXCEPTION_CHAIN_DEPTH = 2;
    private static final int DEFAULT_MAX_REPORTS = 10;
    private final Thread.UncaughtExceptionHandler defaultExceptionHandler;
    private final Context applicationContext;
    private final AtomicBoolean isEnabled = new AtomicBoolean(true);
    private final String mapboxPackage;
    private final String version;
    private int exceptionChainDepth;

    @VisibleForTesting
    MapboxUncaughtExceptionHanlder(@NonNull Context applicationContext, @NonNull SharedPreferences sharedPreferences, @NonNull String mapboxPackage, @NonNull String version, Thread.UncaughtExceptionHandler defaultExceptionHandler) {
        if (TextUtils.isEmpty((CharSequence)mapboxPackage) || TextUtils.isEmpty((CharSequence)version)) {
            throw new IllegalArgumentException("Invalid package name: " + mapboxPackage + " or version: " + version);
        }
        this.applicationContext = applicationContext;
        this.mapboxPackage = mapboxPackage;
        this.version = version;
        this.exceptionChainDepth = 2;
        this.defaultExceptionHandler = defaultExceptionHandler;
        this.initializeSharedPreferences(sharedPreferences);
    }

    public static void install(@NonNull Context context, @NonNull String mapboxPackage, @NonNull String version) {
        Context applicationContext = context.getApplicationContext() == null ? context : context.getApplicationContext();
        Thread.setDefaultUncaughtExceptionHandler(new MapboxUncaughtExceptionHanlder(applicationContext, applicationContext.getSharedPreferences(MAPBOX_CRASH_REPORTER_PREFERENCES, 0), mapboxPackage, version, Thread.getDefaultUncaughtExceptionHandler()));
    }

    @Override
    public void uncaughtException(Thread thread, Throwable throwable) {
        List<Throwable> causalChain;
        if (this.isEnabled.get() && this.isMapboxCrash(causalChain = this.getCausalChain(throwable))) {
            try {
                CrashReport report = CrashReportBuilder.setup(this.applicationContext, this.mapboxPackage, this.version).addExceptionThread(thread).addCausalChain(causalChain).build();
                MapboxUncaughtExceptionHanlder.ensureDirectoryWritable(this.applicationContext, this.mapboxPackage);
                File file = FileUtils.getFile(this.applicationContext, MapboxUncaughtExceptionHanlder.getReportFileName(this.mapboxPackage, report.getDateString()));
                FileUtils.writeToFile(file, report.toJson());
            }
            catch (Exception ex) {
                Log.e((String)TAG, (String)ex.toString());
            }
        }
        if (this.defaultExceptionHandler != null) {
            this.defaultExceptionHandler.uncaughtException(thread, throwable);
        } else {
            Log.i((String)TAG, (String)"Default exception handler is null");
        }
    }

    public void onSharedPreferenceChanged(SharedPreferences sharedPreferences, String key) {
        if (!MAPBOX_PREF_ENABLE_CRASH_REPORTER.equals(key)) {
            return;
        }
        try {
            this.isEnabled.set(sharedPreferences.getBoolean(MAPBOX_PREF_ENABLE_CRASH_REPORTER, false));
        }
        catch (Exception ex) {
            Log.e((String)TAG, (String)ex.toString());
        }
    }

    @VisibleForTesting
    boolean isEnabled() {
        return this.isEnabled.get();
    }

    @VisibleForTesting
    void setExceptionChainDepth(@IntRange(from=1L, to=256L) int depth) {
        this.exceptionChainDepth = depth;
    }

    @VisibleForTesting
    boolean isMapboxCrash(List<Throwable> throwables) {
        for (Throwable cause : throwables) {
            StackTraceElement[] stackTraceElements;
            for (StackTraceElement element : stackTraceElements = cause.getStackTrace()) {
                if (!this.isMapboxStackTraceElement(element)) continue;
                return true;
            }
        }
        return false;
    }

    @VisibleForTesting
    List<Throwable> getCausalChain(@Nullable Throwable throwable) {
        ArrayList<Throwable> causes = new ArrayList<Throwable>(4);
        int level = 0;
        while (throwable != null) {
            if (this.isMidOrLowLevelException(++level)) {
                causes.add(throwable);
            }
            throwable = throwable.getCause();
        }
        return Collections.unmodifiableList(causes);
    }

    private boolean isMapboxStackTraceElement(@NonNull StackTraceElement element) {
        return element.getClassName().startsWith(this.mapboxPackage);
    }

    private boolean isMidOrLowLevelException(int level) {
        return level >= this.exceptionChainDepth;
    }

    @VisibleForTesting
    static void ensureDirectoryWritable(@NonNull Context context, @NonNull String dirPath) {
        File[] allFiles;
        File directory = FileUtils.getFile(context, dirPath);
        if (!directory.exists()) {
            directory.mkdir();
        }
        if ((allFiles = FileUtils.listAllFiles(directory)).length >= 10) {
            FileUtils.deleteFirst(allFiles, new FileUtils.LastModifiedComparator(), 9);
        }
    }

    @VisibleForTesting
    @NonNull
    static String getReportFileName(@NonNull String mapboxPackage, @NonNull String timestamp) {
        return String.format(CRASH_FILENAME_FORMAT, mapboxPackage, timestamp);
    }

    private void initializeSharedPreferences(SharedPreferences sharedPreferences) {
        try {
            this.isEnabled.set(sharedPreferences.getBoolean(MAPBOX_PREF_ENABLE_CRASH_REPORTER, true));
        }
        catch (Exception ex) {
            Log.e((String)TAG, (String)ex.toString());
        }
        sharedPreferences.registerOnSharedPreferenceChangeListener((SharedPreferences.OnSharedPreferenceChangeListener)this);
    }
}

