/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.database.platforms;

import com.manydesigns.portofino.model.database.Column;
import com.manydesigns.portofino.model.database.ConnectionProvider;
import com.manydesigns.portofino.model.database.platforms.AbstractDatabasePlatform;
import com.manydesigns.portofino.model.database.platforms.DatabasePlatform;
import com.manydesigns.portofino.persistence.hibernate.ColumnParameterType;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.PostgreSQL82Dialect;

public class PostgreSQLDatabasePlatform
extends AbstractDatabasePlatform {
    public static final String copyright = "Copyright (C) 2005-2024 ManyDesigns srl";
    public static final String DESCRIPTION = "PostgreSQL";
    public static final String STANDARD_DRIVER_CLASS_NAME = "org.postgresql.Driver";

    public PostgreSQLDatabasePlatform() {
        super((Dialect)new PostgreSQL82Dialect(), "jdbc:postgresql://<host>[:<port, default 5432>]/<database>");
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public String getStandardDriverClassName() {
        return STANDARD_DRIVER_CLASS_NAME;
    }

    public boolean isApplicable(ConnectionProvider connectionProvider) {
        return DESCRIPTION.equals(connectionProvider.getDatabaseProductName());
    }

    public DatabasePlatform.TypeDescriptor getDatabaseSpecificType(Column column) {
        if ("JSONB".equalsIgnoreCase(column.getColumnType())) {
            Properties typeParams = new Properties();
            if (column.getActualJavaType() == Map.class) {
                typeParams.put("org.hibernate.type.ParameterType", new ColumnParameterType(column, Map.class));
                return new DatabasePlatform.TypeDescriptor("com.marvinformatics.hibernate.json.JsonUserType", typeParams);
            }
            if (column.getActualJavaType() == List.class) {
                typeParams.put("org.hibernate.type.ParameterType", new ColumnParameterType(column, Object.class));
                return new DatabasePlatform.TypeDescriptor("com.marvinformatics.hibernate.json.JsonListUserType", typeParams);
            }
            logger.warn("Unsupported column data type: " + column.getActualJavaType());
        }
        return super.getDatabaseSpecificType(column);
    }

    public List<String[]> getSchemaNames(DatabaseMetaData databaseMetaData) throws SQLException {
        List schemaNames = super.getSchemaNames(databaseMetaData);
        Iterator it = schemaNames.iterator();
        while (it.hasNext()) {
            String[] next = (String[])it.next();
            if (!"information_schema".equalsIgnoreCase(next[1]) && !next[1].startsWith("pg_")) continue;
            it.remove();
        }
        return schemaNames;
    }
}

