/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.database.platforms;

import com.manydesigns.portofino.database.platforms.AbstractDatabasePlatform;
import com.manydesigns.portofino.model.database.ConnectionProvider;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.PostgreSQLDialect;

public class PostgreSQLDatabasePlatform
extends AbstractDatabasePlatform {
    public static final String copyright = "Copyright (c) 2005-2014, ManyDesigns srl";
    public static final String DESCRIPTION = "PostgreSQL";
    public static final String STANDARD_DRIVER_CLASS_NAME = "org.postgresql.Driver";

    public PostgreSQLDatabasePlatform() {
        super((Dialect)new PostgreSQLDialect(), "jdbc:postgresql://<host>[:<port, default 5432>]/<database>");
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public String getStandardDriverClassName() {
        return STANDARD_DRIVER_CLASS_NAME;
    }

    public boolean isApplicable(ConnectionProvider connectionProvider) {
        return DESCRIPTION.equals(connectionProvider.getDatabaseProductName());
    }

    public List<String> getSchemaNames(DatabaseMetaData databaseMetaData) throws SQLException {
        List schemaNames = super.getSchemaNames(databaseMetaData);
        Iterator it = schemaNames.iterator();
        while (it.hasNext()) {
            String next = (String)it.next();
            if (!"information_schema".equalsIgnoreCase(next) && !next.startsWith("pg_")) continue;
            it.remove();
        }
        return schemaNames;
    }
}

