/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.modules;

import com.manydesigns.portofino.database.platforms.DatabasePlatform;
import com.manydesigns.portofino.database.platforms.DatabasePlatformsRegistry;
import com.manydesigns.portofino.database.platforms.GoogleCloudSQLDatabasePlatform;
import com.manydesigns.portofino.di.Inject;
import com.manydesigns.portofino.liquibase.databases.GoogleCloudSQLDatabase;
import com.manydesigns.portofino.liquibase.sqlgenerators.GoogleCloudSQLLockDatabaseChangeLogGenerator;
import com.manydesigns.portofino.modules.Module;
import com.manydesigns.portofino.modules.ModuleRegistry;
import com.manydesigns.portofino.modules.ModuleStatus;
import liquibase.database.Database;
import liquibase.database.DatabaseFactory;
import liquibase.sqlgenerator.SqlGenerator;
import liquibase.sqlgenerator.SqlGeneratorFactory;
import org.apache.commons.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GooglecloudsqlModule
implements Module {
    public static final String copyright = "Copyright (C) 2005-2016, ManyDesigns srl";
    @Inject(value="portofinoConfiguration")
    public Configuration configuration;
    @Inject(value="com.manydesigns.portofino.modules.DatabaseModule.databasePlatformsRegistry")
    DatabasePlatformsRegistry databasePlatformsRegistry;
    protected ModuleStatus status = ModuleStatus.CREATED;
    public static final Logger logger = LoggerFactory.getLogger(GooglecloudsqlModule.class);

    public String getModuleVersion() {
        return ModuleRegistry.getPortofinoVersion();
    }

    public int getMigrationVersion() {
        return 1;
    }

    public double getPriority() {
        return 20.0;
    }

    public String getId() {
        return "googlecloudsql";
    }

    public String getName() {
        return "Google Cloud SQL";
    }

    public int install() {
        return 1;
    }

    public void init() {
        if (this.configuration.getBoolean("liquibase.enabled", true)) {
            logger.debug("Registering Google Cloud SQL");
            DatabaseFactory.getInstance().register((Database)new GoogleCloudSQLDatabase());
            logger.debug("Registering GoogleCloudSQLLockDatabaseChangeLogGenerator");
            SqlGeneratorFactory.getInstance().register((SqlGenerator)new GoogleCloudSQLLockDatabaseChangeLogGenerator());
        }
        this.databasePlatformsRegistry.addDatabasePlatform((DatabasePlatform)new GoogleCloudSQLDatabasePlatform());
        this.status = ModuleStatus.ACTIVE;
    }

    public void start() {
        this.status = ModuleStatus.STARTED;
    }

    public void stop() {
        this.status = ModuleStatus.STOPPED;
    }

    public void destroy() {
        this.status = ModuleStatus.DESTROYED;
    }

    public ModuleStatus getStatus() {
        return this.status;
    }
}

