/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.liquibase;

import java.io.IOException;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import liquibase.resource.AbstractResourceAccessor;
import liquibase.resource.InputStreamList;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;

public class VFSResourceAccessor
extends AbstractResourceAccessor {
    protected final FileObject base;

    public VFSResourceAccessor(FileObject base) {
        this.base = base;
    }

    public InputStreamList openStreams(String relativeTo, String path) throws IOException {
        FileObject file = relativeTo == null ? this.base.resolveFile(path) : this.base.resolveFile(relativeTo).getParent().resolveFile(path);
        if (file.exists() && file.isFile()) {
            return new InputStreamList(file.getURI(), file.getContent().getInputStream());
        }
        return new InputStreamList();
    }

    public SortedSet<String> list(String relativeTo, String path, boolean recursive, boolean includeFiles, boolean includeDirectories) throws IOException {
        FileObject finalDir = relativeTo == null ? this.base.resolveFile(path) : this.base.resolveFile(relativeTo).getParent().resolveFile(path);
        if (finalDir.getType() == FileType.FOLDER) {
            TreeSet<String> returnSet = new TreeSet<String>();
            this.getContents(finalDir, recursive, includeFiles, includeDirectories, returnSet);
            return returnSet;
        }
        return null;
    }

    public SortedSet<String> describeLocations() {
        TreeSet<String> locations = new TreeSet<String>();
        locations.add(this.base.getPublicURIString());
        return locations;
    }

    protected void getContents(FileObject root, boolean recursive, boolean includeFiles, boolean includeDirectories, Set<String> returnSet) throws FileSystemException {
        FileObject[] files = root.getChildren();
        if (files == null) {
            return;
        }
        for (FileObject file : files) {
            if (file.getType() == FileType.FOLDER) {
                if (includeDirectories) {
                    returnSet.add(file.getName().getPath());
                }
                if (!recursive) continue;
                this.getContents(file, true, includeFiles, includeDirectories, returnSet);
                continue;
            }
            if (!includeFiles) continue;
            returnSet.add(file.getName().getPath());
        }
    }
}

