/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.persistence.hibernate;

import com.manydesigns.elements.annotations.Updatable;
import com.manydesigns.portofino.code.CodeBase;
import com.manydesigns.portofino.code.JavaCodeBase;
import com.manydesigns.portofino.model.database.ConnectionProvider;
import com.manydesigns.portofino.model.database.Database;
import com.manydesigns.portofino.model.database.ForeignKey;
import com.manydesigns.portofino.model.database.Generator;
import com.manydesigns.portofino.model.database.IncrementGenerator;
import com.manydesigns.portofino.model.database.JdbcConnectionProvider;
import com.manydesigns.portofino.model.database.JndiConnectionProvider;
import com.manydesigns.portofino.model.database.PrimaryKey;
import com.manydesigns.portofino.model.database.PrimaryKeyColumn;
import com.manydesigns.portofino.model.database.Reference;
import com.manydesigns.portofino.model.database.SequenceGenerator;
import com.manydesigns.portofino.model.database.Table;
import com.manydesigns.portofino.model.database.TableGenerator;
import com.manydesigns.portofino.model.database.platforms.DatabasePlatform;
import com.manydesigns.portofino.persistence.hibernate.SessionFactoryAndCodeBase;
import com.manydesigns.portofino.persistence.hibernate.StringBooleanType;
import com.manydesigns.portofino.persistence.hibernate.multitenancy.MultiTenancyImplementation;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ClassFile;
import javassist.bytecode.ConstPool;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.AnnotationMemberValue;
import javassist.bytecode.annotation.ArrayMemberValue;
import javassist.bytecode.annotation.BooleanMemberValue;
import javassist.bytecode.annotation.CharMemberValue;
import javassist.bytecode.annotation.ClassMemberValue;
import javassist.bytecode.annotation.DoubleMemberValue;
import javassist.bytecode.annotation.EnumMemberValue;
import javassist.bytecode.annotation.IntegerMemberValue;
import javassist.bytecode.annotation.LongMemberValue;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.StringMemberValue;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;
import javax.persistence.OneToMany;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.VFS;
import org.hibernate.EntityMode;
import org.hibernate.MultiTenancyStrategy;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Immutable;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;
import org.hibernate.annotations.TypeDef;
import org.hibernate.annotations.TypeDefs;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.MetadataBuilder;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.registry.BootstrapServiceRegistry;
import org.hibernate.boot.registry.BootstrapServiceRegistryBuilder;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.boot.registry.classloading.internal.ClassLoaderServiceImpl;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.mapping.Component;
import org.hibernate.service.Service;
import org.hibernate.service.ServiceRegistry;
import org.jadira.usertype.dateandtime.joda.PersistentDateTime;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionFactoryBuilder {
    private static final Logger logger = LoggerFactory.getLogger(SessionFactoryBuilder.class);
    protected String trueString = "T";
    protected String falseString = "F";
    protected final Database database;
    protected final ClassPool classPool = new ClassPool(ClassPool.getDefault());
    protected final Configuration configuration;
    protected final MultiTenancyImplementation multiTenancyImplementation;
    protected EntityMode entityMode = EntityMode.MAP;
    protected static final Set<String> JAVA_KEYWORDS = new HashSet<String>();

    public SessionFactoryBuilder(Database database, Configuration configuration, MultiTenancyImplementation multiTenancyImplementation) {
        String entityModeName;
        String falseString;
        this.database = database;
        this.configuration = configuration;
        this.multiTenancyImplementation = multiTenancyImplementation;
        String trueString = database.getTrueString();
        if (trueString != null) {
            String string = this.trueString = "null".equalsIgnoreCase(trueString) ? null : trueString;
        }
        if ((falseString = database.getFalseString()) != null) {
            String string = this.falseString = "null".equalsIgnoreCase(falseString) ? null : falseString;
        }
        if (!StringUtils.isEmpty((CharSequence)(entityModeName = database.getEntityMode()))) {
            this.entityMode = EntityMode.parse((String)entityModeName);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SessionFactoryAndCodeBase buildSessionFactory() {
        try (FileObject root = VFS.getManager().resolveFile("ram://portofino/model/");){
            SessionFactoryAndCodeBase sessionFactoryAndCodeBase = this.buildSessionFactory(root);
            return sessionFactoryAndCodeBase;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionFactoryAndCodeBase buildSessionFactory(FileObject root) throws Exception {
        List mappableTables = this.database.getAllTables();
        mappableTables.removeIf(this::checkInvalidPrimaryKey);
        List<Table> externallyMappedTables = mappableTables.stream().filter(t -> {
            boolean externallyMapped;
            boolean bl = externallyMapped = t.getActualJavaClass() != null;
            if (externallyMapped) {
                logger.debug("Skipping table explicitly mapped with {}", (Object)t.getActualJavaClass());
            }
            return externallyMapped;
        }).collect(Collectors.toList());
        mappableTables.removeAll(externallyMappedTables);
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        URLClassLoader scratchClassLoader = new URLClassLoader(new URL[0], contextClassLoader);
        Thread.currentThread().setContextClassLoader(scratchClassLoader);
        try {
            CtClass baseClass = this.generateBaseClass();
            FileObject databaseDir = root.resolveFile(this.database.getDatabaseName());
            databaseDir.deleteAll();
            databaseDir.createFolder();
            FileObject baseClassFile = databaseDir.resolveFile("BaseEntity.class");
            try (OutputStream outputStream = baseClassFile.getContent().getOutputStream();){
                outputStream.write(baseClass.toBytecode());
            }
            for (Table table : mappableTables) {
                this.generateClass(table);
            }
            for (Table table : mappableTables) {
                this.mapRelationships(table);
            }
            for (Table table : mappableTables) {
                byte[] classFile = this.getClassFile(table);
                FileObject location = this.getEntityLocation(root, table);
                OutputStream outputStream = location.getContent().getOutputStream();
                Throwable throwable = null;
                try {
                    outputStream.write(classFile);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (outputStream == null) continue;
                    if (throwable != null) {
                        try {
                            outputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    outputStream.close();
                }
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
        return this.buildSessionFactory((CodeBase)new JavaCodeBase(root), mappableTables, externallyMappedTables);
    }

    protected boolean checkInvalidPrimaryKey(Table table) {
        return this.checkInvalidPrimaryKey(table, true);
    }

    protected boolean checkInvalidPrimaryKey(Table table, boolean warn) {
        if ((table.getPrimaryKey() == null || table.getPrimaryKey().getPrimaryKeyColumns().isEmpty()) && !this.ensurePrimaryKey(table)) {
            if (warn) {
                logger.warn("Skipping table without primary key: {}", (Object)table.getQualifiedName());
            }
            return true;
        }
        List columnPKList = table.getPrimaryKey().getColumns();
        if (!table.getColumns().containsAll(columnPKList)) {
            if (warn) {
                logger.error("Skipping table with primary key that refers to invalid columns: {}", (Object)table.getQualifiedName());
            }
            return true;
        }
        return false;
    }

    protected boolean ensurePrimaryKey(Table table) {
        ArrayList idColumns = new ArrayList();
        for (com.manydesigns.portofino.model.database.Column column : table.getColumns()) {
            column.getAnnotations().forEach(ann -> {
                Class annotationClass = ann.getJavaAnnotationClass();
                if (Id.class.equals((Object)annotationClass)) {
                    idColumns.add(column);
                }
            });
        }
        if (idColumns.isEmpty()) {
            return false;
        }
        logger.info("Creating primary key on table {} according to @Id annotations", (Object)table.getQualifiedName());
        PrimaryKey pk = new PrimaryKey(table);
        pk.setPrimaryKeyName("synthetic_pk_" + table.getQualifiedName().replace('.', '_'));
        for (com.manydesigns.portofino.model.database.Column column : idColumns) {
            pk.add(column);
        }
        table.setPrimaryKey(pk);
        return true;
    }

    public SessionFactoryAndCodeBase buildSessionFactory(CodeBase codeBase, List<Table> tablesToMap, List<Table> externallyMappedTables) {
        BootstrapServiceRegistryBuilder bootstrapRegistryBuilder = new BootstrapServiceRegistryBuilder();
        DynamicClassLoaderService classLoaderService = new DynamicClassLoaderService();
        bootstrapRegistryBuilder.applyClassLoaderService((ClassLoaderService)classLoaderService);
        BootstrapServiceRegistry bootstrapServiceRegistry = bootstrapRegistryBuilder.build();
        Map<String, Object> settings = this.setupConnection();
        StandardServiceRegistry standardRegistry = new StandardServiceRegistryBuilder(bootstrapServiceRegistry).applySettings(settings).build();
        MetadataSources sources = new MetadataSources((ServiceRegistry)standardRegistry);
        ArrayList<String> externallyMappedClasses = new ArrayList<String>();
        try {
            for (Table table : tablesToMap) {
                Class<?> persistentClass = this.getPersistentClass(table, codeBase);
                sources.addAnnotatedClass(persistentClass);
                classLoaderService.classes.put(persistentClass.getName(), persistentClass);
                if (this.entityMode != EntityMode.POJO) continue;
                table.setActualJavaClass(persistentClass);
            }
            for (Table table : externallyMappedTables) {
                sources.addAnnotatedClass(table.getActualJavaClass());
                externallyMappedClasses.add(table.getActualJavaClass().getName());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        MetadataBuilder metadataBuilder = sources.getMetadataBuilder();
        Metadata metadata = metadataBuilder.build();
        if (this.entityMode == EntityMode.MAP) {
            metadata.getEntityBindings().forEach(c -> {
                if (!externallyMappedClasses.contains(c.getClassName())) {
                    c.setClassName(null);
                    if (c.getIdentifier() instanceof Component) {
                        Component component = (Component)c.getIdentifier();
                        component.setComponentClassName(null);
                        component.setDynamic(true);
                    }
                }
            });
        }
        org.hibernate.boot.SessionFactoryBuilder sessionFactoryBuilder = metadata.getSessionFactoryBuilder();
        return new SessionFactoryAndCodeBase(sessionFactoryBuilder.build(), codeBase);
    }

    protected Map<String, Object> setupConnection() {
        HashMap<String, Object> settings = new HashMap<String, Object>();
        ConnectionProvider connectionProvider = this.database.getConnectionProvider();
        if (!connectionProvider.isHibernateDialectAutodetected()) {
            settings.put("hibernate.dialect", connectionProvider.getActualHibernateDialectName());
        }
        settings.put("hibernate.ejb.metamodel.population", "enabled");
        if (this.multiTenancyImplementation != null) {
            MultiTenancyStrategy strategy = this.multiTenancyImplementation.getStrategy();
            if (strategy.requiresMultiTenantConnectionProvider()) {
                this.setupMultiTenantConnection(connectionProvider, settings);
            } else {
                this.setupSingleTenantConnection(connectionProvider, settings);
            }
        } else {
            this.setupSingleTenantConnection(connectionProvider, settings);
        }
        if (this.database.getSettings() != null) {
            settings.putAll(this.database.getSettings());
        }
        return settings;
    }

    protected void setupMultiTenantConnection(ConnectionProvider connectionProvider, Map<String, Object> settings) {
        Class<?> connectionProviderClass;
        if (connectionProvider instanceof JndiConnectionProvider) {
            logger.debug("JNDI connection provider configured. Using default Hibernate strategy based on JNDI (org.hibernate.engine.jdbc.connections.spi.DataSourceBasedMultiTenantConnectionProviderImpl).");
            return;
        }
        this.setupSingleTenantConnection(connectionProvider, settings);
        BootstrapServiceRegistryBuilder bootstrapRegistryBuilder = new BootstrapServiceRegistryBuilder();
        BootstrapServiceRegistry bootstrapServiceRegistry = bootstrapRegistryBuilder.build();
        try (StandardServiceRegistry standardRegistry = new StandardServiceRegistryBuilder(bootstrapServiceRegistry).applySettings(settings).build();){
            Service service = standardRegistry.getService(org.hibernate.engine.jdbc.connections.spi.ConnectionProvider.class);
            connectionProviderClass = service.getClass();
        }
        settings.put("portofino.persistence.hibernate.multitenancy.connectionProviderClass", connectionProviderClass);
        settings.put("hibernate.multi_tenant_connection_provider", ((Object)((Object)this.multiTenancyImplementation)).getClass());
        settings.put("hibernate.multiTenancy", this.multiTenancyImplementation.getStrategy());
    }

    protected void setupSingleTenantConnection(ConnectionProvider connectionProvider, Map<String, Object> settings) {
        if (connectionProvider instanceof JdbcConnectionProvider) {
            JdbcConnectionProvider jdbcConnectionProvider = (JdbcConnectionProvider)connectionProvider;
            settings.put("hibernate.connection.url", jdbcConnectionProvider.getActualUrl());
            String driver = jdbcConnectionProvider.getDriver();
            if (driver != null) {
                settings.put("hibernate.connection.driver_class", driver);
            }
            if (jdbcConnectionProvider.getActualUsername() != null) {
                settings.put("hibernate.connection.username", jdbcConnectionProvider.getActualUsername());
            }
            if (jdbcConnectionProvider.getActualPassword() != null) {
                settings.put("hibernate.connection.password", jdbcConnectionProvider.getActualPassword());
            }
        } else if (connectionProvider instanceof JndiConnectionProvider) {
            JndiConnectionProvider jndiConnectionProvider = (JndiConnectionProvider)connectionProvider;
            settings.put("hibernate.connection.datasource", jndiConnectionProvider.getJndiResource());
        } else {
            throw new Error("Unsupported connection provider: " + connectionProvider);
        }
    }

    protected FileObject getEntityLocation(FileObject root, Table table) throws FileSystemException {
        return root.resolveFile(this.entityNameToFileName(table));
    }

    @NotNull
    protected String entityNameToFileName(Table table) {
        return this.getMappedClassName(table).replace('.', '/') + ".class";
    }

    @NotNull
    public String getMappedClassName(Table table) {
        return SessionFactoryBuilder.getMappedClassName(table, this.entityMode);
    }

    @NotNull
    public static String getMappedClassName(Table table, EntityMode entityMode) {
        return table.getActualJavaClass() == null ? SessionFactoryBuilder.deriveMappedClassName(table, entityMode) : table.getActualJavaClass().getName();
    }

    @NotNull
    public static String deriveMappedClassName(Table table, EntityMode entityMode) {
        String packageName = table.getSchema().getQualifiedName().toLowerCase();
        String className = table.getActualEntityName();
        className = entityMode == EntityMode.POJO ? SessionFactoryBuilder.toJavaLikeName(className) : className.replaceAll("-|\\h", "");
        if (Character.isDigit(className.charAt(0))) {
            className = "_" + className;
        }
        String fullName = packageName + "." + className;
        if (entityMode == EntityMode.POJO) {
            fullName = SessionFactoryBuilder.ensureValidJavaName(fullName);
        }
        for (Table other : table.getSchema().getDatabase().getAllTables()) {
            if (other == table || other.getActualJavaClass() == null || !other.getActualJavaClass().getName().equals(fullName)) continue;
            fullName = fullName + "_1";
        }
        return fullName;
    }

    public static String ensureValidJavaName(String fullName) {
        Object[] tokens = fullName.split("\\.");
        for (int i = 0; i < tokens.length; ++i) {
            if (!JAVA_KEYWORDS.contains(tokens[i])) continue;
            tokens[i] = (String)tokens[i] + "_";
        }
        return StringUtils.join((Object[])tokens, (String)".");
    }

    @NotNull
    protected static String toJavaLikeName(String name) {
        return Arrays.stream(StringUtils.split((String)name.toLowerCase(), (String)"_- ")).map(StringUtils::capitalize).collect(Collectors.joining());
    }

    public Class<?> getPersistentClass(Table table, CodeBase codeBase) throws IOException, ClassNotFoundException {
        Class javaClass = table.getActualJavaClass();
        if (javaClass != null) {
            return javaClass;
        }
        return codeBase.loadClass(this.getMappedClassName(table));
    }

    public byte[] getClassFile(Table table) throws NotFoundException, IOException, CannotCompileException {
        return this.getMappedClass(table).toBytecode();
    }

    public CtClass generateBaseClass() throws NotFoundException {
        CtClass cc = this.classPool.makeClass(this.getBaseEntityName());
        cc.addInterface(this.classPool.get(Serializable.class.getName()));
        ClassFile ccFile = cc.getClassFile();
        ConstPool constPool = ccFile.getConstPool();
        AnnotationsAttribute classAnnotations = new AnnotationsAttribute(constPool, "RuntimeVisibleAnnotations");
        ccFile.addAttribute((AttributeInfo)classAnnotations);
        Annotation annotation = new Annotation(MappedSuperclass.class.getName(), constPool);
        classAnnotations.addAnnotation(annotation);
        Annotation stringBooleanType = new Annotation(TypeDef.class.getName(), constPool);
        stringBooleanType.addMemberValue("name", (MemberValue)new StringMemberValue(StringBooleanType.class.getName(), constPool));
        stringBooleanType.addMemberValue("typeClass", (MemberValue)new ClassMemberValue(StringBooleanType.class.getName(), constPool));
        ArrayMemberValue parameters = new ArrayMemberValue((MemberValue)new AnnotationMemberValue(constPool), constPool);
        parameters.setValue((MemberValue[])new AnnotationMemberValue[]{new AnnotationMemberValue(this.makeParameterAnnotation("trueString", this.trueString, constPool), constPool), new AnnotationMemberValue(this.makeParameterAnnotation("falseString", this.falseString, constPool), constPool)});
        stringBooleanType.addMemberValue("parameters", (MemberValue)parameters);
        annotation = new Annotation(TypeDefs.class.getName(), constPool);
        ArrayMemberValue typeDefs = new ArrayMemberValue((MemberValue)new AnnotationMemberValue(constPool), constPool);
        typeDefs.setValue((MemberValue[])new AnnotationMemberValue[]{new AnnotationMemberValue(stringBooleanType, constPool)});
        annotation.addMemberValue("value", (MemberValue)typeDefs);
        classAnnotations.addAnnotation(annotation);
        return cc;
    }

    protected Annotation makeParameterAnnotation(String name, String value, ConstPool constPool) {
        Annotation annotation = new Annotation(Parameter.class.getName(), constPool);
        annotation.addMemberValue("name", (MemberValue)new StringMemberValue(name, constPool));
        annotation.addMemberValue("value", (MemberValue)new StringMemberValue(value, constPool));
        return annotation;
    }

    @NotNull
    public String getBaseEntityName() {
        return this.database.getDatabaseName() + ".BaseEntity";
    }

    public CtClass generateClass(Table table) throws CannotCompileException, NotFoundException {
        CtClass cc = this.classPool.makeClass(this.getMappedClassName(table));
        cc.setSuperclass(this.classPool.get(this.getBaseEntityName()));
        ClassFile ccFile = cc.getClassFile();
        ConstPool constPool = ccFile.getConstPool();
        AnnotationsAttribute classAnnotations = new AnnotationsAttribute(constPool, "RuntimeVisibleAnnotations");
        this.configureAnnotations(table, constPool, classAnnotations);
        ccFile.addAttribute((AttributeInfo)classAnnotations);
        this.setupColumns(table, cc, constPool);
        if (this.entityMode == EntityMode.POJO) {
            this.defineEqualsAndHashCode(table, cc);
        }
        return cc;
    }

    protected void defineEqualsAndHashCode(Table table, CtClass cc) throws CannotCompileException {
        List columnPKList = table.getPrimaryKey().getColumns();
        String equalsMethod = "public boolean equals(Object other) {    if(!(other instanceof " + cc.getName() + ")) {        return false;    }" + cc.getName() + " castOther = (" + cc.getName() + ") other;";
        String hashCodeMethod = "public int hashCode() {    return java.util.Objects.hash(new java.lang.Object[] {";
        boolean first = true;
        for (com.manydesigns.portofino.model.database.Column c : columnPKList) {
            equalsMethod = equalsMethod + "    if(!java.util.Objects.equals(this." + c.getActualPropertyName() + ", castOther." + c.getActualPropertyName() + ")) {        return false;    }";
            if (first) {
                first = false;
            } else {
                hashCodeMethod = hashCodeMethod + ", ";
            }
            hashCodeMethod = hashCodeMethod + c.getActualPropertyName();
        }
        equalsMethod = equalsMethod + "return true; }";
        hashCodeMethod = hashCodeMethod + "});}";
        cc.addMethod(CtNewMethod.make((String)equalsMethod, (CtClass)cc));
        cc.addMethod(CtNewMethod.make((String)hashCodeMethod, (CtClass)cc));
    }

    protected void configureAnnotations(Table table, ConstPool constPool, AnnotationsAttribute classAnnotations) {
        Annotation annotation = new Annotation(javax.persistence.Table.class.getName(), constPool);
        annotation.addMemberValue("name", (MemberValue)new StringMemberValue(this.jpaEscape(table.getTableName()), constPool));
        if (this.multiTenancyImplementation == null || this.multiTenancyImplementation.getStrategy() != MultiTenancyStrategy.SCHEMA) {
            String schemaName = table.getSchema().getActualSchemaName();
            annotation.addMemberValue("schema", (MemberValue)new StringMemberValue(this.jpaEscape(schemaName), constPool));
        }
        classAnnotations.addAnnotation(annotation);
        annotation = new Annotation(Entity.class.getName(), constPool);
        annotation.addMemberValue("name", (MemberValue)new StringMemberValue(table.getActualEntityName(), constPool));
        classAnnotations.addAnnotation(annotation);
        table.getAnnotations().forEach(ann -> {
            Class annotationClass = ann.getJavaAnnotationClass();
            if (javax.persistence.Table.class.equals((Object)annotationClass) || Entity.class.equals((Object)annotationClass)) {
                logger.warn("@Table or @Entity specified on table {}, skipping annotation {}", (Object)table.getQualifiedName(), (Object)annotationClass);
                return;
            }
            Annotation classAnn = this.convertAnnotation(constPool, (com.manydesigns.portofino.model.Annotation)ann);
            if (classAnn != null) {
                classAnnotations.addAnnotation(classAnn);
            }
            if (annotationClass == Updatable.class && !((Updatable)ann.getJavaAnnotation()).value()) {
                classAnnotations.addAnnotation(new Annotation(Immutable.class.getName(), constPool));
            }
        });
    }

    @Nullable
    protected Annotation convertAnnotation(ConstPool constPool, com.manydesigns.portofino.model.Annotation portofinoAnnotation) {
        java.lang.annotation.Annotation javaAnnotation = portofinoAnnotation.getJavaAnnotation();
        if (javaAnnotation == null) {
            return null;
        }
        Class<? extends java.lang.annotation.Annotation> annotationType = javaAnnotation.annotationType();
        Annotation annotation = new Annotation(annotationType.getName(), constPool);
        for (Method method : annotationType.getMethods()) {
            if (Modifier.isStatic(method.getModifiers()) || method.getDeclaringClass() == Object.class || method.getDeclaringClass() == java.lang.annotation.Annotation.class || method.getParameterCount() > 0) {
                logger.debug("Skipping " + method);
                continue;
            }
            try {
                Object result = method.invoke((Object)javaAnnotation, new Object[0]);
                if (result == null) continue;
                Class<?> returnType = method.getReturnType();
                if (returnType == String.class) {
                    annotation.addMemberValue(method.getName(), (MemberValue)new StringMemberValue((String)result, constPool));
                    continue;
                }
                if (returnType == Integer.class || returnType == Integer.TYPE) {
                    annotation.addMemberValue(method.getName(), (MemberValue)new IntegerMemberValue(constPool, ((Integer)result).intValue()));
                    continue;
                }
                if (returnType == Long.class || returnType == Long.TYPE) {
                    annotation.addMemberValue(method.getName(), (MemberValue)new LongMemberValue(((Long)result).longValue(), constPool));
                    continue;
                }
                if (returnType == Float.class || returnType == Float.TYPE) {
                    annotation.addMemberValue(method.getName(), (MemberValue)new DoubleMemberValue(((Double)result).doubleValue(), constPool));
                    continue;
                }
                if (returnType == Double.class || returnType == Double.TYPE) {
                    annotation.addMemberValue(method.getName(), (MemberValue)new DoubleMemberValue(((Double)result).doubleValue(), constPool));
                    continue;
                }
                if (returnType == Character.class || returnType == Character.TYPE) {
                    annotation.addMemberValue(method.getName(), (MemberValue)new CharMemberValue(((Character)result).charValue(), constPool));
                    continue;
                }
                if (returnType == Boolean.class || returnType == Boolean.TYPE) {
                    annotation.addMemberValue(method.getName(), (MemberValue)new BooleanMemberValue(((Boolean)result).booleanValue(), constPool));
                    continue;
                }
                if (returnType == Class.class) {
                    annotation.addMemberValue(method.getName(), (MemberValue)new ClassMemberValue(((Class)result).getName(), constPool));
                    continue;
                }
                if (!returnType.isEnum()) continue;
                EnumMemberValue value = new EnumMemberValue(constPool);
                value.setType(returnType.getName());
                value.setValue(((Enum)result).name());
                annotation.addMemberValue(method.getName(), (MemberValue)value);
            }
            catch (Exception e) {
                logger.warn("Skipping " + method + " as it errored", (Throwable)e);
            }
        }
        return annotation;
    }

    protected void setupColumns(Table table, CtClass cc, ConstPool constPool) throws CannotCompileException, NotFoundException {
        List columnPKList = table.getPrimaryKey().getColumns();
        for (com.manydesigns.portofino.model.database.Column column : table.getColumns()) {
            String propertyName = column.getActualPropertyName();
            CtField field = new CtField(this.classPool.get(column.getActualJavaType().getName()), propertyName, cc);
            AnnotationsAttribute fieldAnnotations = new AnnotationsAttribute(constPool, "RuntimeVisibleAnnotations");
            Annotation annotation = new Annotation(Column.class.getName(), constPool);
            annotation.addMemberValue("name", (MemberValue)new StringMemberValue(this.jpaEscape(column.getColumnName()), constPool));
            annotation.addMemberValue("nullable", (MemberValue)new BooleanMemberValue(column.isNullable(), constPool));
            if (column.getLength() != null) {
                annotation.addMemberValue("precision", (MemberValue)new IntegerMemberValue(constPool, column.getLength().intValue()));
                annotation.addMemberValue("length", (MemberValue)new IntegerMemberValue(constPool, column.getLength().intValue()));
            }
            if (column.getScale() != null) {
                annotation.addMemberValue("scale", (MemberValue)new IntegerMemberValue(constPool, column.getScale().intValue()));
            }
            fieldAnnotations.addAnnotation(annotation);
            if (columnPKList.contains(column)) {
                annotation.addMemberValue("updatable", (MemberValue)new BooleanMemberValue(false, constPool));
                annotation = new Annotation(Id.class.getName(), constPool);
                fieldAnnotations.addAnnotation(annotation);
                if (column.isAutoincrement()) {
                    this.setupIdentityGenerator(fieldAnnotations, constPool);
                } else {
                    PrimaryKeyColumn pkColumn = table.getPrimaryKey().findPrimaryKeyColumnByName(column.getColumnName());
                    Generator generator = pkColumn.getGenerator();
                    if (generator != null) {
                        this.setupNonIdentityGenerator(table, fieldAnnotations, generator, constPool);
                    }
                }
            }
            this.setupColumnType(column, fieldAnnotations, constPool);
            column.getAnnotations().forEach(ann -> {
                Class annotationClass = ann.getJavaAnnotationClass();
                if (Column.class.equals((Object)annotationClass) || Id.class.equals((Object)annotationClass) || Type.class.equals((Object)annotationClass)) {
                    logger.debug("@Column or @Id or @Type specified on column {}, ignoring annotation {}", (Object)column.getQualifiedName(), (Object)annotationClass);
                    return;
                }
                Annotation fieldAnn = this.convertAnnotation(constPool, (com.manydesigns.portofino.model.Annotation)ann);
                if (fieldAnn != null) {
                    fieldAnnotations.addAnnotation(fieldAnn);
                }
            });
            field.getFieldInfo().addAttribute((AttributeInfo)fieldAnnotations);
            field.setModifiers(4);
            cc.addField(field);
            String accessorName = propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
            cc.addMethod(CtNewMethod.getter((String)("get" + accessorName), (CtField)field));
            cc.addMethod(CtNewMethod.setter((String)("set" + accessorName), (CtField)field));
        }
    }

    public String jpaEscape(String columnName) {
        return "\"" + columnName + "\"";
    }

    protected void setupIdentityGenerator(AnnotationsAttribute fieldAnnotations, ConstPool constPool) {
        Annotation annotation = this.makeGeneratedValueAnnotation(GenerationType.IDENTITY, constPool);
        fieldAnnotations.addAnnotation(annotation);
    }

    protected void setupNonIdentityGenerator(Table table, AnnotationsAttribute fieldAnnotations, Generator generator, ConstPool constPool) {
        String generatorName = table.getQualifiedName() + "_generator";
        if (generator instanceof IncrementGenerator) {
            this.addGeneratedValueAnnotation(GenerationType.AUTO, generatorName, fieldAnnotations, constPool);
            Annotation annotation = new Annotation(GenericGenerator.class.getName(), constPool);
            annotation.addMemberValue("name", (MemberValue)new StringMemberValue(generatorName, constPool));
            annotation.addMemberValue("strategy", (MemberValue)new StringMemberValue("increment", constPool));
            fieldAnnotations.addAnnotation(annotation);
        } else if (generator instanceof SequenceGenerator) {
            this.addGeneratedValueAnnotation(GenerationType.SEQUENCE, generatorName, fieldAnnotations, constPool);
            Annotation annotation = new Annotation(javax.persistence.SequenceGenerator.class.getName(), constPool);
            annotation.addMemberValue("name", (MemberValue)new StringMemberValue(generatorName, constPool));
            annotation.addMemberValue("sequenceName", (MemberValue)new StringMemberValue(((SequenceGenerator)generator).getName(), constPool));
            fieldAnnotations.addAnnotation(annotation);
        } else if (generator instanceof TableGenerator) {
            TableGenerator tableGenerator = (TableGenerator)generator;
            this.addGeneratedValueAnnotation(GenerationType.TABLE, generatorName, fieldAnnotations, constPool);
            Annotation annotation = new Annotation(javax.persistence.TableGenerator.class.getName(), constPool);
            annotation.addMemberValue("name", (MemberValue)new StringMemberValue(generatorName, constPool));
            annotation.addMemberValue("schema", (MemberValue)new StringMemberValue(table.getSchema().getActualSchemaName(), constPool));
            annotation.addMemberValue("table", (MemberValue)new StringMemberValue(tableGenerator.getTable(), constPool));
            annotation.addMemberValue("pkColumnName", (MemberValue)new StringMemberValue(tableGenerator.getKeyColumn(), constPool));
            annotation.addMemberValue("pkColumnValue", (MemberValue)new StringMemberValue(tableGenerator.getKeyValue(), constPool));
            annotation.addMemberValue("valueColumnName", (MemberValue)new StringMemberValue(tableGenerator.getValueColumn(), constPool));
            fieldAnnotations.addAnnotation(annotation);
        } else {
            throw new IllegalArgumentException("Unsupported generator: " + generator);
        }
    }

    protected void addGeneratedValueAnnotation(GenerationType generationType, String generatorName, AnnotationsAttribute fieldAnnotations, ConstPool constPool) {
        Annotation annotation = this.makeGeneratedValueAnnotation(generationType, constPool);
        annotation.addMemberValue("generator", (MemberValue)new StringMemberValue(generatorName, constPool));
        fieldAnnotations.addAnnotation(annotation);
    }

    @NotNull
    protected Annotation makeGeneratedValueAnnotation(GenerationType identity, ConstPool constPool) {
        Annotation annotation = new Annotation(GeneratedValue.class.getName(), constPool);
        EnumMemberValue value = new EnumMemberValue(constPool);
        value.setType(GenerationType.class.getName());
        value.setValue(identity.name());
        annotation.addMemberValue("strategy", (MemberValue)value);
        return annotation;
    }

    protected void setupColumnType(com.manydesigns.portofino.model.database.Column column, AnnotationsAttribute fieldAnnotations, ConstPool constPool) {
        if (Boolean.class.equals((Object)column.getActualJavaType())) {
            if (column.getJdbcType() == 1 || column.getJdbcType() == 12) {
                Annotation annotation = new Annotation(Type.class.getName(), constPool);
                annotation.addMemberValue("type", (MemberValue)new StringMemberValue(StringBooleanType.class.getName(), constPool));
                fieldAnnotations.addAnnotation(annotation);
            }
        } else if (DateTime.class.isAssignableFrom(column.getActualJavaType())) {
            Annotation annotation = new Annotation(Type.class.getName(), constPool);
            annotation.addMemberValue("type", (MemberValue)new StringMemberValue(PersistentDateTime.class.getName(), constPool));
            ArrayMemberValue parameters = new ArrayMemberValue((MemberValue)new AnnotationMemberValue(constPool), constPool);
            parameters.setValue((MemberValue[])new AnnotationMemberValue[]{new AnnotationMemberValue(this.makeParameterAnnotation("databaseZone", "jvm", constPool), constPool)});
            annotation.addMemberValue("parameters", (MemberValue)parameters);
            fieldAnnotations.addAnnotation(annotation);
        } else {
            DatabasePlatform.TypeDescriptor databaseSpecificType = this.database.getConnectionProvider().getDatabasePlatform().getDatabaseSpecificType(column);
            if (databaseSpecificType != null) {
                Annotation annotation = new Annotation(Type.class.getName(), constPool);
                annotation.addMemberValue("type", (MemberValue)new StringMemberValue(databaseSpecificType.name, constPool));
                ArrayMemberValue parameters = new ArrayMemberValue((MemberValue)new AnnotationMemberValue(constPool), constPool);
                ArrayList typeParams = new ArrayList();
                databaseSpecificType.parameters.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
                    Annotation typeParam = this.makeParameterAnnotation(key.toString(), String.valueOf(value), constPool);
                    typeParams.add(new AnnotationMemberValue(typeParam, constPool));
                }));
                parameters.setValue((MemberValue[])typeParams.toArray(new AnnotationMemberValue[0]));
                annotation.addMemberValue("parameters", (MemberValue)parameters);
                fieldAnnotations.addAnnotation(annotation);
            }
        }
    }

    public void mapRelationships(Table table) throws NotFoundException, CannotCompileException {
        for (ForeignKey foreignKey : table.getForeignKeys()) {
            if (!this.checkValidFk(foreignKey)) continue;
            this.mapManyToOne(foreignKey);
            this.mapOneToMany(foreignKey);
        }
    }

    protected void mapManyToOne(ForeignKey foreignKey) throws CannotCompileException, NotFoundException {
        CtClass cc = this.getMappedClass(foreignKey.getFromTable());
        ClassFile ccFile = cc.getClassFile();
        ConstPool constPool = ccFile.getConstPool();
        Table toTable = foreignKey.getToTable();
        CtField field = new CtField(this.getMappedClass(toTable), foreignKey.getActualOnePropertyName(), cc);
        cc.addField(field);
        AnnotationsAttribute fieldAnnotations = new AnnotationsAttribute(constPool, "RuntimeVisibleAnnotations");
        Annotation annotation = new Annotation(ManyToOne.class.getName(), constPool);
        fieldAnnotations.addAnnotation(annotation);
        ArrayList<AnnotationMemberValue> joinColumnsValue = new ArrayList<AnnotationMemberValue>();
        for (Reference reference : foreignKey.getReferences()) {
            annotation = new Annotation(JoinColumn.class.getName(), constPool);
            annotation.addMemberValue("insertable", (MemberValue)new BooleanMemberValue(false, constPool));
            annotation.addMemberValue("updatable", (MemberValue)new BooleanMemberValue(false, constPool));
            annotation.addMemberValue("name", (MemberValue)new StringMemberValue(this.jpaEscape(reference.getFromColumn()), constPool));
            annotation.addMemberValue("referencedColumnName", (MemberValue)new StringMemberValue(this.jpaEscape(reference.getToColumn()), constPool));
            joinColumnsValue.add(new AnnotationMemberValue(annotation, constPool));
        }
        annotation = new Annotation(JoinColumns.class.getName(), constPool);
        ArrayMemberValue joinColumns = new ArrayMemberValue((MemberValue)new AnnotationMemberValue(constPool), constPool);
        joinColumns.setValue(joinColumnsValue.toArray(new MemberValue[0]));
        annotation.addMemberValue("value", (MemberValue)joinColumns);
        this.finalizeRelationshipProperty(cc, field, annotation, fieldAnnotations);
    }

    protected boolean checkValidFk(ForeignKey foreignKey) {
        Table toTable = foreignKey.getToTable();
        if (toTable == null) {
            logger.error("The foreign key " + foreignKey.getQualifiedName() + " does not refer to any table.");
            return false;
        }
        if (this.checkInvalidPrimaryKey(toTable, false)) {
            logger.error("The foreign key " + foreignKey.getQualifiedName() + " refers to a table with absent or invalid primary key.");
            return false;
        }
        HashSet<com.manydesigns.portofino.model.database.Column> fkColumns = new HashSet<com.manydesigns.portofino.model.database.Column>();
        HashSet pkColumns = new HashSet(toTable.getPrimaryKey().getColumns());
        for (Reference reference : foreignKey.getReferences()) {
            fkColumns.add(reference.getActualToColumn());
        }
        if (!fkColumns.equals(pkColumns)) {
            logger.error("The foreign key " + foreignKey.getQualifiedName() + " does not refer to the exact primary key of table " + toTable.getQualifiedName() + ", this is not supported.");
            return false;
        }
        try {
            this.getMappedClass(toTable);
        }
        catch (NotFoundException e) {
            logger.error("The foreign key " + foreignKey.getQualifiedName() + " refers to unmapped table " + toTable.getQualifiedName() + ", skipping.");
            return false;
        }
        return true;
    }

    protected void mapOneToMany(ForeignKey foreignKey) throws NotFoundException, CannotCompileException {
        CtClass cc = this.getMappedClass(foreignKey.getToTable());
        ClassFile ccFile = cc.getClassFile();
        ConstPool constPool = ccFile.getConstPool();
        Table fromTable = foreignKey.getFromTable();
        CtField field = new CtField(this.classPool.get(List.class.getName()), foreignKey.getActualManyPropertyName(), cc);
        String referencedClassName = this.getMappedClassName(fromTable);
        field.setGenericSignature("Ljava/util/List<L" + referencedClassName.replace('.', '/') + ";>;");
        cc.addField(field);
        AnnotationsAttribute fieldAnnotations = new AnnotationsAttribute(constPool, "RuntimeVisibleAnnotations");
        Annotation annotation = new Annotation(OneToMany.class.getName(), constPool);
        annotation.addMemberValue("targetEntity", (MemberValue)new ClassMemberValue(referencedClassName, constPool));
        annotation.addMemberValue("mappedBy", (MemberValue)new StringMemberValue(foreignKey.getActualOnePropertyName(), constPool));
        this.finalizeRelationshipProperty(cc, field, annotation, fieldAnnotations);
    }

    protected void finalizeRelationshipProperty(CtClass cc, CtField field, Annotation annotation, AnnotationsAttribute fieldAnnotations) throws CannotCompileException {
        fieldAnnotations.addAnnotation(annotation);
        field.getFieldInfo().addAttribute((AttributeInfo)fieldAnnotations);
        String accessorName = SessionFactoryBuilder.toJavaLikeName(field.getName());
        cc.addMethod(CtNewMethod.getter((String)("get" + accessorName), (CtField)field));
        cc.addMethod(CtNewMethod.setter((String)("set" + accessorName), (CtField)field));
    }

    protected CtClass getMappedClass(Table table) throws NotFoundException {
        return this.classPool.get(this.getMappedClassName(table));
    }

    public EntityMode getEntityMode() {
        return this.entityMode;
    }

    static {
        JAVA_KEYWORDS.add("private");
        JAVA_KEYWORDS.add("protected");
        JAVA_KEYWORDS.add("public");
    }

    public static class DynamicClassLoaderService
    extends ClassLoaderServiceImpl {
        public final Map<String, Class> classes = new HashMap<String, Class>();

        public <T> Class<T> classForName(String className) {
            Class theClass = this.classes.get(className);
            if (theClass != null) {
                return theClass;
            }
            return super.classForName(className);
        }
    }
}

