/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.persistence.hibernate.multitenancy;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.hibernate.MultiTenancyStrategy;
import org.hibernate.engine.jdbc.connections.spi.AbstractMultiTenantConnectionProvider;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.service.spi.Configurable;
import org.hibernate.service.spi.ServiceRegistryAwareService;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.service.spi.Startable;
import org.hibernate.service.spi.Stoppable;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MultiTenancyImplementation
extends AbstractMultiTenantConnectionProvider
implements ServiceRegistryAwareService,
Configurable,
Stoppable {
    public static final String CONNECTION_PROVIDER_CLASS = "portofino.persistence.hibernate.multitenancy.connectionProviderClass";
    private static final Logger logger = LoggerFactory.getLogger(MultiTenancyImplementation.class);
    private Class<ConnectionProvider> connectionProviderClass;
    private ServiceRegistryImplementor serviceRegistry;
    private Map configurationValues;
    private final ConcurrentMap<Object, ConnectionProvider> connectionProviders = new ConcurrentHashMap<Object, ConnectionProvider>();

    public MultiTenancyStrategy getStrategy() {
        return MultiTenancyStrategy.DATABASE;
    }

    protected ConnectionProvider getAnyConnectionProvider() {
        return this.getConnectionProvider(this.getDefaultTenant(), this.configurationValues);
    }

    public String getDefaultTenant() {
        return "portofino";
    }

    public abstract String getTenant();

    protected ConnectionProvider selectConnectionProvider(String tenantIdentifier) {
        HashMap settings = new HashMap(this.configurationValues);
        return this.getConnectionProvider(tenantIdentifier, settings);
    }

    @NotNull
    protected ConnectionProvider getConnectionProvider(String tenant, Map configuration) {
        return this.connectionProviders.computeIfAbsent(tenant, o -> this.createConnectionProvider(tenant, configuration));
    }

    @NotNull
    protected ConnectionProvider createConnectionProvider(String tenant, Map configuration) {
        String password;
        String username;
        ConnectionProvider connectionProvider;
        try {
            connectionProvider = this.connectionProviderClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not instantiate connection provider " + this.connectionProviderClass, e);
        }
        String url = this.getConnectionURL(tenant);
        if (url != null) {
            configuration.put("hibernate.connection.url", url);
        }
        if ((username = this.getUsername(tenant)) != null) {
            configuration.put("hibernate.connection.username", username);
        }
        if ((password = this.getPassword(tenant)) != null) {
            configuration.put("hibernate.connection.password", username);
        }
        if (connectionProvider instanceof ServiceRegistryAwareService) {
            ((ServiceRegistryAwareService)connectionProvider).injectServices(this.serviceRegistry);
        }
        if (connectionProvider instanceof Configurable) {
            ((Configurable)connectionProvider).configure(configuration);
        }
        if (connectionProvider instanceof Startable) {
            ((Startable)connectionProvider).start();
        }
        return connectionProvider;
    }

    public String getConnectionURL(String tenant) {
        return null;
    }

    public String getUsername(String tenant) {
        return null;
    }

    public String getPassword(String tenant) {
        return null;
    }

    public void injectServices(ServiceRegistryImplementor serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public void configure(Map configurationValues) {
        this.configurationValues = configurationValues;
        this.connectionProviderClass = (Class)configurationValues.get(CONNECTION_PROVIDER_CLASS);
        if (!ConnectionProvider.class.isAssignableFrom(this.connectionProviderClass)) {
            throw new RuntimeException("Class " + this.connectionProviderClass.getName() + " does not implement ConnectionProvider");
        }
    }

    public void stop() {
        this.connectionProviders.values().forEach(cp -> {
            if (cp instanceof Stoppable) {
                try {
                    ((Stoppable)cp).stop();
                }
                catch (Exception e) {
                    logger.warn("Could not stop connection provider " + cp, (Throwable)e);
                }
            }
        });
        this.connectionProviders.clear();
    }
}

