/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.database.platforms;

import com.manydesigns.portofino.model.database.ConnectionProvider;
import com.manydesigns.portofino.model.database.platforms.AbstractDatabasePlatform;
import java.sql.Connection;
import java.sql.Statement;
import org.hibernate.dialect.H2Dialect;

public class H2DatabasePlatform
extends AbstractDatabasePlatform {
    public static final String copyright = "Copyright (C) 2005-2020 ManyDesigns srl";
    public static final String DESCRIPTION = "H2";
    public static final String STANDARD_DRIVER_CLASS_NAME = "org.h2.Driver";

    public H2DatabasePlatform() {
        super(H2Dialect.class.getName(), "jdbc:h2:<database or connection spec>");
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public String getStandardDriverClassName() {
        return STANDARD_DRIVER_CLASS_NAME;
    }

    public boolean isApplicable(ConnectionProvider connectionProvider) {
        return DESCRIPTION.equals(connectionProvider.getDatabaseProductName());
    }

    public void shutdown(ConnectionProvider connectionProvider) {
        super.shutdown(connectionProvider);
        try (Connection connection = connectionProvider.acquireConnection();
             Statement statement = connection.createStatement();){
            statement.execute("SHUTDOWN");
        }
        catch (Exception e) {
            logger.warn("Could not shutdown connection provider " + connectionProvider.getDatabase().getDatabaseName(), (Throwable)e);
        }
    }
}

