/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.shiro;

import com.manydesigns.elements.util.RandomUtil;
import com.manydesigns.portofino.model.database.Column;
import com.manydesigns.portofino.model.database.DatabaseLogic;
import com.manydesigns.portofino.model.database.Table;
import com.manydesigns.portofino.persistence.Persistence;
import com.manydesigns.portofino.persistence.QueryUtils;
import com.manydesigns.portofino.reflection.TableAccessor;
import com.manydesigns.portofino.shiro.AbstractPortofinoRealm;
import com.manydesigns.portofino.shiro.EmailAddress;
import com.manydesigns.portofino.shiro.EmailToken;
import com.manydesigns.portofino.shiro.ExistingUserException;
import com.manydesigns.portofino.shiro.GroupLink;
import com.manydesigns.portofino.shiro.GroupName;
import com.manydesigns.portofino.shiro.Password;
import com.manydesigns.portofino.shiro.PasswordResetToken;
import com.manydesigns.portofino.shiro.RegistrationException;
import com.manydesigns.portofino.shiro.SignUpToken;
import com.manydesigns.portofino.shiro.User;
import com.manydesigns.portofino.shiro.UserLink;
import com.manydesigns.portofino.shiro.Username;
import com.manydesigns.portofino.util.PkHelper;
import groovy.lang.Tuple3;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authc.UnknownAccountException;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.hibernate.Session;
import org.hibernate.exception.ConstraintViolationException;
import org.hibernate.query.Query;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class ModelBasedRealm
extends AbstractPortofinoRealm {
    protected Table usersTable;
    protected Table groupsTable;
    protected Table usersGroupsTable;
    protected String userIdProperty;
    protected String userNameProperty;
    protected String userEmailProperty;
    protected String userPasswordProperty;
    protected String userTokenProperty;
    protected String groupIdProperty;
    protected String groupNameProperty;
    protected String groupLinkProperty;
    protected String userLinkProperty;
    protected static final Logger logger = LoggerFactory.getLogger(ModelBasedRealm.class);
    @Autowired
    Persistence persistence;

    @PostConstruct
    public void configure() {
        if (this.persistence.status.getValue() != Persistence.Status.STARTED) {
            throw new IllegalStateException("Persistence is not yet started");
        }
        this.persistence.getModel().getDatabases().forEach(d -> d.getAllTables().forEach(t -> t.getColumns().forEach(c -> {
            if (c.getAnnotation(Username.class).isPresent()) {
                this.setupUserTable((Table)t);
                this.userNameProperty = c.getActualPropertyName();
            }
            if (c.getAnnotation(Password.class).isPresent()) {
                this.setupUserTable((Table)t);
                this.userPasswordProperty = c.getActualPropertyName();
            }
            if (c.getAnnotation(EmailAddress.class).isPresent()) {
                this.setupUserTable((Table)t);
                this.userEmailProperty = c.getActualPropertyName();
            }
            if (c.getAnnotation(EmailToken.class).isPresent()) {
                this.setupUserTable((Table)t);
                this.userTokenProperty = c.getActualPropertyName();
            }
            if (c.getAnnotation(GroupName.class).isPresent()) {
                if (this.groupsTable != null) {
                    throw new IllegalStateException("Multiple tables with an @GroupName annotation: " + this.groupsTable.getQualifiedName() + " and " + t.getQualifiedName());
                }
                this.groupsTable = t;
                this.groupNameProperty = c.getActualPropertyName();
                List pkcols = t.getPrimaryKey().getColumns();
                if (pkcols.size() > 1) {
                    throw new IllegalStateException("Group table has composite id, not supported: " + this.groupsTable.getQualifiedName());
                }
                this.groupIdProperty = ((Column)pkcols.get(0)).getActualPropertyName();
            }
            if (c.getAnnotation(GroupLink.class).isPresent()) {
                if (this.usersGroupsTable != null && this.usersGroupsTable != t) {
                    throw new IllegalStateException("Multiple user-group tables: " + this.usersGroupsTable.getQualifiedName() + " and " + t.getQualifiedName());
                }
                this.usersGroupsTable = t;
                this.groupLinkProperty = c.getActualPropertyName();
            }
            if (c.getAnnotation(UserLink.class).isPresent()) {
                if (this.usersGroupsTable != null && this.usersGroupsTable != t) {
                    throw new IllegalStateException("Multiple user-group tables: " + this.usersGroupsTable.getQualifiedName() + " and " + t.getQualifiedName());
                }
                this.usersGroupsTable = t;
                this.userLinkProperty = c.getActualPropertyName();
            }
        })));
        if (this.usersTable == null) {
            throw new IllegalStateException("No users table found");
        }
        if (this.userLinkProperty == null || this.groupLinkProperty == null) {
            this.usersGroupsTable = null;
        }
    }

    protected void setupUserTable(Table t) {
        if (this.usersTable != null && this.usersTable != t) {
            throw new IllegalStateException("Multiple users tables : " + this.usersTable.getQualifiedName() + " and " + t.getQualifiedName());
        }
        this.usersTable = t;
        List pkcols = t.getPrimaryKey().getColumns();
        if (pkcols.size() > 1) {
            throw new IllegalStateException("Users table has composite id, not supported: " + this.groupsTable.getQualifiedName());
        }
        this.userIdProperty = ((Column)pkcols.get(0)).getActualPropertyName();
    }

    protected Collection<String> loadAuthorizationInfo(Serializable principal) {
        ArrayList<String> groups = new ArrayList<String>();
        if (this.groupsTable == null) {
            return groups;
        }
        Session session = this.persistence.getSession(this.usersTable.getDatabaseName());
        String queryString = this.getUserGroupsQuery();
        Query query = session.createQuery(queryString);
        Object userId = this.getUserProperty(principal, this.userIdProperty);
        if (userId != null) {
            query.setParameter("userId", userId);
            groups.addAll(query.list());
        }
        return groups;
    }

    @NotNull
    protected String getUserGroupsQuery() {
        String queryString = "select distinct g." + this.groupNameProperty + "\nfrom " + this.groupsTable.getActualEntityName() + " g, " + this.usersGroupsTable.getActualEntityName() + " ug, " + this.usersTable.getActualEntityName() + " u\nwhere g." + this.groupIdProperty + " = ug." + this.groupLinkProperty + "\nand ug." + this.userLinkProperty + " = u." + this.userIdProperty + "\nand u." + this.userIdProperty + " = :userId";
        return queryString;
    }

    protected Object getUserProperty(Object principal, String property) {
        if (principal instanceof Map) {
            return ((Map)principal).get(property);
        }
        try {
            return BeanUtils.getProperty((Object)principal, (String)property);
        }
        catch (Exception e) {
            logger.debug("Not a valid POJO principal: " + principal, (Throwable)e);
            return null;
        }
    }

    protected void setUserProperty(Object principal, String property, Object value) {
        if (principal instanceof Map) {
            ((Map)principal).put(property, value);
        } else {
            try {
                BeanUtils.setProperty((Object)principal, (String)property, (Object)value);
            }
            catch (Exception e) {
                throw new IllegalStateException("Not a valid POJO principal: " + principal, e);
            }
        }
    }

    protected AuthenticationInfo loadAuthenticationInfo(UsernamePasswordToken usernamePasswordToken) {
        String userName = usernamePasswordToken.getUsername();
        Session session = this.persistence.getSession(this.usersTable.getDatabaseName());
        Tuple3<CriteriaQuery<Object>, CriteriaBuilder, Root> criteriaTuple = QueryUtils.createCriteria(session, this.usersTable.getActualEntityName());
        CriteriaQuery criteria = (CriteriaQuery)criteriaTuple.getV1();
        CriteriaBuilder cb = (CriteriaBuilder)criteriaTuple.getV2();
        Root from = (Root)criteriaTuple.getV3();
        criteria.where((Expression)cb.equal((Expression)from.get(this.userNameProperty), (Object)userName));
        List result = session.createQuery(criteria).list();
        if (result.size() == 1) {
            Object user = this.cleanUserPrincipal(result.get(0));
            return new SimpleAuthenticationInfo(user, this.getUserProperty(user, this.userPasswordProperty), this.getName());
        }
        throw new IncorrectCredentialsException("Login failed");
    }

    protected AuthenticationInfo loadAuthenticationInfo(PasswordResetToken token) {
        if (StringUtils.isEmpty((String)this.userTokenProperty)) {
            throw new AuthenticationException("User token property is not configured; password reset is not supported by this application.");
        }
        Session session = this.persistence.getSession(this.usersTable.getDatabaseName());
        Tuple3<CriteriaQuery<Object>, CriteriaBuilder, Root> criteriaTuple = QueryUtils.createCriteria(session, this.usersTable.getActualEntityName());
        CriteriaQuery criteria = (CriteriaQuery)criteriaTuple.getV1();
        CriteriaBuilder cb = (CriteriaBuilder)criteriaTuple.getV2();
        Root from = (Root)criteriaTuple.getV3();
        criteria.where((Expression)cb.equal((Expression)from.get(this.userTokenProperty), token.getPrincipal()));
        List result = session.createQuery(criteria).list();
        if (result.size() == 1) {
            String hashedPassword = this.encryptPassword(token.newPassword);
            Object user = result.get(0);
            this.setUserProperty(user, this.userTokenProperty, null);
            this.setUserProperty(user, this.userPasswordProperty, hashedPassword);
            session.update(this.usersTable.getActualEntityName(), user);
            session.getTransaction().commit();
            SimpleAuthenticationInfo info = new SimpleAuthenticationInfo(this.cleanUserPrincipal(user), (Object)hashedPassword, this.getName());
            return info;
        }
        throw new IncorrectCredentialsException("Invalid token");
    }

    protected AuthenticationInfo loadAuthenticationInfo(SignUpToken token) {
        if (StringUtils.isEmpty((String)this.userTokenProperty)) {
            throw new AuthenticationException("User token property is not configured; self registration is not supported by this application.");
        }
        Session session = this.persistence.getSession(this.usersTable.getDatabaseName());
        Tuple3<CriteriaQuery<Object>, CriteriaBuilder, Root> criteriaTuple = QueryUtils.createCriteria(session, this.usersTable.getActualEntityName());
        CriteriaQuery criteria = (CriteriaQuery)criteriaTuple.getV1();
        CriteriaBuilder cb = (CriteriaBuilder)criteriaTuple.getV2();
        Root from = (Root)criteriaTuple.getV3();
        criteria.where((Expression)cb.equal((Expression)from.get(this.userTokenProperty), token.getPrincipal()));
        List result = session.createQuery(criteria).list();
        if (result.size() == 1) {
            Object user = result.get(0);
            this.setUserProperty(user, this.userTokenProperty, null);
            session.update(this.usersTable.getActualEntityName(), user);
            session.getTransaction().commit();
            SimpleAuthenticationInfo info = new SimpleAuthenticationInfo(this.cleanUserPrincipal(user), (Object)this.encryptPassword(token.getCredentials()), this.getName());
            return info;
        }
        throw new IncorrectCredentialsException("Invalid token");
    }

    protected Object cleanUserPrincipal(Object principal) {
        PropertyDescriptor[] propertyDescriptors;
        if (principal instanceof Map) {
            return super.cleanUserPrincipal(principal);
        }
        Object clean = this.persistence.getTableAccessor(this.usersTable).newInstance();
        for (PropertyDescriptor pd : propertyDescriptors = PropertyUtils.getPropertyDescriptors((Object)principal)) {
            if (DatabaseLogic.findColumnByName((Table)this.usersTable, (String)pd.getName()) == null) continue;
            this.setUserProperty(clean, pd.getName(), this.getUserProperty(principal, pd.getName()));
        }
        return clean;
    }

    public boolean supports(AuthenticationToken token) {
        if (token instanceof PasswordResetToken || token instanceof SignUpToken) {
            return !StringUtils.isEmpty((String)this.userTokenProperty);
        }
        return super.supports(token);
    }

    public void changePassword(Serializable user, String oldPassword, String newPassword) {
        Session session = this.persistence.getSession(this.usersTable.getDatabaseName());
        Object savedUser = session.load(this.usersTable.getActualEntityName(), (Serializable)this.getUserProperty(user, this.userIdProperty));
        if (savedUser == null) {
            throw new UnknownAccountException("User has been deleted");
        }
        if (!this.passwordService.passwordsMatch((Object)oldPassword, (String)this.getUserProperty(savedUser, this.userPasswordProperty))) {
            throw new IncorrectCredentialsException("Wrong password");
        }
        this.setUserProperty(savedUser, this.userPasswordProperty, this.encryptPassword(newPassword));
        session.getTransaction().commit();
    }

    public String encryptPassword(String password) {
        return this.passwordService.encryptPassword((Object)password);
    }

    public Map<Serializable, String> getUsers() {
        LinkedHashMap<Serializable, String> users = new LinkedHashMap<Serializable, String>();
        Session session = this.persistence.getSession(this.usersTable.getDatabaseName());
        Query query = session.createQuery("select " + this.userIdProperty + ",  " + this.userNameProperty + " from " + this.usersTable.getActualEntityName() + " order by " + this.userNameProperty);
        for (Object[] user : query.list()) {
            users.put((Serializable)user[0], (String)user[1]);
        }
        return users;
    }

    public Serializable getUserById(String encodedId) {
        TableAccessor accessor = this.persistence.getTableAccessor(this.usersTable);
        PkHelper pkHelper = new PkHelper(accessor);
        Serializable id = pkHelper.getPrimaryKey(encodedId);
        Session session = this.persistence.getSession(this.usersTable.getActualEntityName());
        return (Serializable)QueryUtils.getObjectByPk(session, accessor, id);
    }

    public Serializable getUserByEmail(String email) {
        if (StringUtils.isEmpty((String)this.userEmailProperty)) {
            throw new UnsupportedOperationException("Email property not configured.");
        }
        Session session = this.persistence.getSession(this.usersTable.getDatabaseName());
        Tuple3<CriteriaQuery<Object>, CriteriaBuilder, Root> criteriaTuple = QueryUtils.createCriteria(session, this.usersTable.getActualEntityName());
        CriteriaQuery criteria = (CriteriaQuery)criteriaTuple.getV1();
        CriteriaBuilder cb = (CriteriaBuilder)criteriaTuple.getV2();
        Root from = (Root)criteriaTuple.getV3();
        criteria.where((Expression)cb.equal((Expression)from.get(this.userEmailProperty), (Object)email));
        return (Serializable)session.createQuery(criteria).uniqueResult();
    }

    public String getUserPrettyName(Serializable user) {
        if (StringUtils.isEmpty((String)this.userNameProperty)) {
            return user.toString();
        }
        return (String)this.getUserProperty(user, this.userNameProperty);
    }

    public Serializable getUserId(Serializable user) {
        if (StringUtils.isEmpty((String)this.userIdProperty)) {
            return user.toString();
        }
        return (Serializable)this.getUserProperty(user, this.userIdProperty);
    }

    public String getUsername(Serializable user) {
        if (StringUtils.isEmpty((String)this.userNameProperty)) {
            return user.toString();
        }
        return (String)this.getUserProperty(user, this.userNameProperty);
    }

    public String getEmail(Serializable user) {
        if (StringUtils.isEmpty((String)this.userEmailProperty)) {
            throw new UnsupportedOperationException("Email property not configured.");
        }
        return (String)this.getUserProperty(user, this.userEmailProperty);
    }

    public String generateOneTimeToken(Serializable user) {
        if (StringUtils.isEmpty((String)this.userTokenProperty)) {
            throw new UnsupportedOperationException("Token property not configured.");
        }
        Session session = this.persistence.getSession(this.usersTable.getDatabaseName());
        user = (Serializable)session.get(this.usersTable.getActualEntityName(), this.getUserId(user));
        String token = RandomUtil.createRandomId((int)20);
        this.setUserProperty(user, this.userTokenProperty, token);
        session.update(this.usersTable.getActualEntityName(), (Object)user);
        session.getTransaction().commit();
        return token;
    }

    public boolean supportsSelfRegistration() {
        return true;
    }

    public String[] saveSelfRegisteredUser(Object user) throws RegistrationException {
        if (StringUtils.isEmpty((String)this.userTokenProperty)) {
            throw new UnsupportedOperationException("Token property not configured.");
        }
        User theUser = (User)user;
        Session session = this.persistence.getSession(this.usersTable.getDatabaseName());
        TableAccessor accessor = this.persistence.getTableAccessor(this.usersTable);
        Object persistentUser = accessor.newInstance();
        this.setUserProperty(persistentUser, this.userNameProperty, theUser.username);
        this.setUserProperty(persistentUser, this.userPasswordProperty, this.encryptPassword(theUser.password));
        if (!StringUtils.isEmpty((String)this.userEmailProperty)) {
            this.setUserProperty(persistentUser, this.userEmailProperty, theUser.email);
        }
        String token = RandomUtil.createRandomId((int)20);
        this.setUserProperty(persistentUser, this.userTokenProperty, token);
        try {
            session.save(this.usersTable.getActualEntityName(), persistentUser);
            session.flush();
        }
        catch (ConstraintViolationException e) {
            throw new ExistingUserException((Throwable)e);
        }
        session.getTransaction().commit();
        return new String[]{token, theUser.email};
    }

    public Set<String> getGroups() {
        Set groups = super.getGroups();
        if (this.groupsTable != null) {
            Session session = this.persistence.getSession(this.groupsTable.getDatabaseName());
            Tuple3<CriteriaQuery<Object>, CriteriaBuilder, Root> criteriaTuple = QueryUtils.createCriteria(session, this.groupsTable.getActualEntityName());
            CriteriaQuery criteria = (CriteriaQuery)criteriaTuple.getV1();
            CriteriaBuilder cb = (CriteriaBuilder)criteriaTuple.getV2();
            Root from = (Root)criteriaTuple.getV3();
            Path groupNameExpression = from.get(this.groupNameProperty);
            criteria.select((Selection)groupNameExpression).orderBy(new Order[]{cb.asc((Expression)groupNameExpression)});
            groups.addAll(session.createQuery(criteria).list().stream().map(String::valueOf).collect(Collectors.toList()));
        }
        return groups;
    }

    public Table getUsersTable() {
        return this.usersTable;
    }

    public Table getGroupsTable() {
        return this.groupsTable;
    }

    public Table getUsersGroupsTable() {
        return this.usersGroupsTable;
    }
}

