/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.persistence.hibernate;

import com.manydesigns.portofino.code.CodeBase;
import com.manydesigns.portofino.model.database.Database;
import com.manydesigns.portofino.persistence.hibernate.SessionDelegator;
import com.manydesigns.portofino.persistence.hibernate.SessionFactoryBuilder;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.EntityMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HibernateDatabaseSetup {
    public static final String copyright = "Copyright (C) 2005-2020 ManyDesigns srl";
    protected final Database database;
    protected final SessionFactory sessionFactory;
    protected final CodeBase codeBase;
    protected final ThreadLocal<Session> threadSessions;
    protected final EntityMode entityMode;
    protected final Map<String, String> jpaEntityNameToClassNameMap = new HashMap<String, String>();
    public static final Logger logger = LoggerFactory.getLogger(HibernateDatabaseSetup.class);

    public HibernateDatabaseSetup(Database database, SessionFactory sessionFactory, CodeBase codeBase, EntityMode entityMode) {
        this.database = database;
        this.sessionFactory = sessionFactory;
        this.codeBase = codeBase;
        this.entityMode = entityMode;
        this.threadSessions = new ThreadLocal();
        database.getAllTables().forEach(t -> this.jpaEntityNameToClassNameMap.put(t.getActualEntityName(), SessionFactoryBuilder.getMappedClassName(t, entityMode)));
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public ThreadLocal<Session> getThreadSessions() {
        return this.threadSessions;
    }

    public Session getThreadSession() {
        return this.getThreadSession(true);
    }

    public Session getThreadSession(boolean create) {
        Session session = this.threadSessions.get();
        if (session == null && create) {
            if (logger.isDebugEnabled()) {
                logger.debug("Creating thread-local session for {}", (Object)Thread.currentThread());
            }
            session = this.createSession();
            session.beginTransaction();
            this.threadSessions.set(session);
        }
        return session;
    }

    public Session createSession() {
        Session session = this.sessionFactory.openSession();
        return new SessionDelegator(this, session);
    }

    public String translateEntityNameFromJpaToHibernate(String entityName) {
        String hibernateEntityName = this.jpaEntityNameToClassNameMap.get(entityName);
        return hibernateEntityName != null ? hibernateEntityName : entityName;
    }

    public void dispose() {
        this.getSessionFactory().close();
    }

    public void setThreadSession(Session session) {
        this.threadSessions.set(session);
    }

    public void removeThreadSession() {
        this.threadSessions.remove();
    }

    public Database getDatabase() {
        return this.database;
    }

    public CodeBase getCodeBase() {
        return this.codeBase;
    }

    public EntityMode getEntityMode() {
        return this.entityMode;
    }
}

