/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.liquibase;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import liquibase.resource.AbstractResourceAccessor;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;

public class VFSResourceAccessor
extends AbstractResourceAccessor {
    protected final FileObject base;

    public VFSResourceAccessor(FileObject base) {
        this.base = base;
    }

    public Set<InputStream> getResourcesAsStream(String path) throws IOException {
        return Collections.singleton(this.base.resolveFile(path).getContent().getInputStream());
    }

    public Set<String> list(String relativeTo, String path, boolean includeFiles, boolean includeDirectories, boolean recursive) throws IOException {
        FileObject finalDir = relativeTo == null ? this.base.resolveFile(path) : this.base.resolveFile(relativeTo).getParent().resolveFile(path);
        if (finalDir.getType() == FileType.FOLDER) {
            HashSet<String> returnSet = new HashSet<String>();
            this.getContents(finalDir, recursive, includeFiles, includeDirectories, path, returnSet);
            TreeSet<String> rootPaths = new TreeSet<String>((o1, o2) -> {
                int i = -1 * Integer.compare(o1.length(), o2.length());
                if (i == 0) {
                    i = o1.compareTo((String)o2);
                }
                return i;
            });
            for (String rootPath : this.getRootPaths()) {
                rootPath = rootPath.matches("file:/[A-Za-z]:/.*") ? rootPath.replaceFirst("file:/", "") : rootPath.replaceFirst("file:", "");
                rootPaths.add(rootPath.replace("\\", "/"));
            }
            LinkedHashSet<String> finalReturnSet = new LinkedHashSet<String>();
            for (String returnPath : returnSet) {
                returnPath = returnPath.replace("\\", "/");
                for (String rootPath : rootPaths) {
                    boolean matches = this.isCaseSensitive() ? returnPath.startsWith(rootPath) : returnPath.toLowerCase().startsWith(rootPath.toLowerCase());
                    if (!matches) continue;
                    returnPath = returnPath.substring(rootPath.length());
                    break;
                }
                finalReturnSet.add(returnPath);
            }
            return finalReturnSet;
        }
        return null;
    }

    protected void getContents(FileObject root, boolean recursive, boolean includeFiles, boolean includeDirectories, String basePath, Set<String> returnSet) throws FileSystemException {
        FileObject[] files = root.getChildren();
        if (files == null) {
            return;
        }
        for (FileObject file : files) {
            if (file.getType() == FileType.FOLDER) {
                if (includeDirectories) {
                    returnSet.add(this.convertToPath(file.getName().getPath()));
                }
                if (!recursive) continue;
                this.getContents(file, true, includeFiles, includeDirectories, basePath, returnSet);
                continue;
            }
            if (!includeFiles) continue;
            returnSet.add(this.convertToPath(file.getName().getPath()));
        }
    }

    public ClassLoader toClassLoader() {
        return new URLClassLoader(new URL[0]);
    }
}

