/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.persistence.hibernate;

import com.manydesigns.elements.annotations.Updatable;
import com.manydesigns.portofino.code.CodeBase;
import com.manydesigns.portofino.code.JavaCodeBase;
import com.manydesigns.portofino.model.database.ConnectionProvider;
import com.manydesigns.portofino.model.database.Database;
import com.manydesigns.portofino.model.database.ForeignKey;
import com.manydesigns.portofino.model.database.Generator;
import com.manydesigns.portofino.model.database.IncrementGenerator;
import com.manydesigns.portofino.model.database.JdbcConnectionProvider;
import com.manydesigns.portofino.model.database.JndiConnectionProvider;
import com.manydesigns.portofino.model.database.PrimaryKeyColumn;
import com.manydesigns.portofino.model.database.Reference;
import com.manydesigns.portofino.model.database.SequenceGenerator;
import com.manydesigns.portofino.model.database.Table;
import com.manydesigns.portofino.model.database.TableGenerator;
import com.manydesigns.portofino.model.database.platforms.DatabasePlatform;
import com.manydesigns.portofino.persistence.hibernate.SessionFactoryAndCodeBase;
import com.manydesigns.portofino.persistence.hibernate.StringBooleanType;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ClassFile;
import javassist.bytecode.ConstPool;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.AnnotationMemberValue;
import javassist.bytecode.annotation.ArrayMemberValue;
import javassist.bytecode.annotation.BooleanMemberValue;
import javassist.bytecode.annotation.CharMemberValue;
import javassist.bytecode.annotation.ClassMemberValue;
import javassist.bytecode.annotation.DoubleMemberValue;
import javassist.bytecode.annotation.EnumMemberValue;
import javassist.bytecode.annotation.IntegerMemberValue;
import javassist.bytecode.annotation.LongMemberValue;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.StringMemberValue;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;
import javax.persistence.OneToMany;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.VFS;
import org.hibernate.EntityMode;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Immutable;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;
import org.hibernate.annotations.TypeDef;
import org.hibernate.annotations.TypeDefs;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.MetadataBuilder;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.registry.BootstrapServiceRegistry;
import org.hibernate.boot.registry.BootstrapServiceRegistryBuilder;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.boot.registry.classloading.internal.ClassLoaderServiceImpl;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.mapping.Component;
import org.hibernate.service.ServiceRegistry;
import org.jadira.usertype.dateandtime.joda.PersistentDateTime;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionFactoryBuilder {
    private static final Logger logger = LoggerFactory.getLogger(SessionFactoryBuilder.class);
    protected String trueString = "T";
    protected String falseString = "F";
    protected final Database database;
    protected final ClassPool classPool = new ClassPool(ClassPool.getDefault());
    protected EntityMode entityMode = EntityMode.MAP;

    public SessionFactoryBuilder(Database database) {
        String entityModeName;
        String falseString;
        this.database = database;
        String trueString = database.getTrueString();
        if (trueString != null) {
            String string = this.trueString = "null".equalsIgnoreCase(trueString) ? null : trueString;
        }
        if ((falseString = database.getFalseString()) != null) {
            String string = this.falseString = "null".equalsIgnoreCase(falseString) ? null : falseString;
        }
        if (!StringUtils.isEmpty((CharSequence)(entityModeName = database.getEntityMode()))) {
            this.entityMode = EntityMode.parse((String)entityModeName);
        }
    }

    public SessionFactoryAndCodeBase buildSessionFactory() {
        SessionFactoryAndCodeBase sessionFactoryAndCodeBase;
        block8: {
            FileObject root = VFS.getManager().resolveFile("ram://portofino/model/");
            try {
                sessionFactoryAndCodeBase = this.buildSessionFactory(root);
                if (root == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (root != null) {
                        try {
                            root.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            root.close();
        }
        return sessionFactoryAndCodeBase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionFactoryAndCodeBase buildSessionFactory(FileObject root) throws Exception {
        JavaCodeBase codeBase = new JavaCodeBase(root);
        List mappableTables = this.database.getAllTables();
        mappableTables.removeIf(this::checkInvalidPrimaryKey);
        List<Table> externallyMappedTables = mappableTables.stream().filter(t -> {
            boolean externallyMapped;
            boolean bl = externallyMapped = t.getActualJavaClass() != null;
            if (externallyMapped) {
                logger.debug("Skipping table explicitly mapped with {}", (Object)t.getActualJavaClass());
            }
            return externallyMapped;
        }).collect(Collectors.toList());
        mappableTables.removeAll(externallyMappedTables);
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        URLClassLoader scratchClassLoader = new URLClassLoader(new URL[0], contextClassLoader);
        Thread.currentThread().setContextClassLoader(scratchClassLoader);
        try {
            CtClass baseClass = this.generateBaseClass();
            FileObject baseClassFile = root.resolveFile(this.database.getDatabaseName() + '/' + "BaseEntity.class");
            try (OutputStream outputStream = baseClassFile.getContent().getOutputStream();){
                outputStream.write(baseClass.toBytecode());
            }
            for (Table table : mappableTables) {
                this.generateClass(table);
            }
            for (Table table : mappableTables) {
                this.mapRelationships(table);
            }
            for (Table table : mappableTables) {
                byte[] classFile = this.getClassFile(table);
                FileObject location = this.getEntityLocation(root, table);
                OutputStream outputStream = location.getContent().getOutputStream();
                try {
                    outputStream.write(classFile);
                }
                finally {
                    if (outputStream == null) continue;
                    outputStream.close();
                }
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
        return this.buildSessionFactory((CodeBase)codeBase, mappableTables, externallyMappedTables);
    }

    protected boolean checkInvalidPrimaryKey(Table table) {
        return this.checkInvalidPrimaryKey(table, true);
    }

    protected boolean checkInvalidPrimaryKey(Table table, boolean warn) {
        if (table.getPrimaryKey() == null || table.getPrimaryKey().getPrimaryKeyColumns().isEmpty()) {
            if (warn) {
                logger.warn("Skipping table without primary key: {}", (Object)table.getQualifiedName());
            }
            return true;
        }
        List columnPKList = table.getPrimaryKey().getColumns();
        if (!table.getColumns().containsAll(columnPKList)) {
            if (warn) {
                logger.error("Skipping table with primary key that refers to invalid columns: {}", (Object)table.getQualifiedName());
            }
            return true;
        }
        return false;
    }

    public SessionFactoryAndCodeBase buildSessionFactory(CodeBase codeBase, List<Table> tablesToMap, List<Table> externallyMappedTables) {
        BootstrapServiceRegistryBuilder bootstrapRegistryBuilder = new BootstrapServiceRegistryBuilder();
        DynamicClassLoaderService classLoaderService = new DynamicClassLoaderService();
        bootstrapRegistryBuilder.applyClassLoaderService((ClassLoaderService)classLoaderService);
        BootstrapServiceRegistry bootstrapServiceRegistry = bootstrapRegistryBuilder.build();
        HashMap<String, Object> settings = new HashMap<String, Object>();
        this.setupConnection(settings);
        StandardServiceRegistry standardRegistry = new StandardServiceRegistryBuilder(bootstrapServiceRegistry).applySettings(settings).build();
        MetadataSources sources = new MetadataSources((ServiceRegistry)standardRegistry);
        ArrayList<String> externallyMappedClasses = new ArrayList<String>();
        try {
            for (Table table : tablesToMap) {
                Class<?> persistentClass = this.getPersistentClass(table, codeBase);
                sources.addAnnotatedClass(persistentClass);
                classLoaderService.classes.put(persistentClass.getName(), persistentClass);
                if (this.entityMode != EntityMode.POJO) continue;
                table.setActualJavaClass(persistentClass);
            }
            for (Table table : externallyMappedTables) {
                sources.addAnnotatedClass(table.getActualJavaClass());
                externallyMappedClasses.add(table.getActualJavaClass().getName());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        MetadataBuilder metadataBuilder = sources.getMetadataBuilder();
        Metadata metadata = metadataBuilder.build();
        if (this.entityMode == EntityMode.MAP) {
            metadata.getEntityBindings().forEach(c -> {
                if (!externallyMappedClasses.contains(c.getClassName())) {
                    c.setClassName(null);
                    if (c.getIdentifier() instanceof Component) {
                        Component component = (Component)c.getIdentifier();
                        component.setComponentClassName(null);
                        component.setDynamic(true);
                    }
                }
            });
        }
        org.hibernate.boot.SessionFactoryBuilder sessionFactoryBuilder = metadata.getSessionFactoryBuilder();
        return new SessionFactoryAndCodeBase(sessionFactoryBuilder.build(), codeBase);
    }

    protected void setupConnection(Map<String, Object> settings) {
        ConnectionProvider connectionProvider = this.database.getConnectionProvider();
        if (!connectionProvider.isHibernateDialectAutodetected()) {
            settings.put("hibernate.dialect", connectionProvider.getActualHibernateDialectName());
        }
        if (connectionProvider instanceof JdbcConnectionProvider) {
            JdbcConnectionProvider jdbcConnectionProvider = (JdbcConnectionProvider)connectionProvider;
            settings.put("hibernate.connection.url", jdbcConnectionProvider.getActualUrl());
            settings.put("hibernate.connection.driver_class", jdbcConnectionProvider.getDriver());
            if (jdbcConnectionProvider.getActualUsername() != null) {
                settings.put("hibernate.connection.username", jdbcConnectionProvider.getActualUsername());
            }
            if (jdbcConnectionProvider.getActualPassword() != null) {
                settings.put("hibernate.connection.password", jdbcConnectionProvider.getActualPassword());
            }
        } else if (connectionProvider instanceof JndiConnectionProvider) {
            JndiConnectionProvider jndiConnectionProvider = (JndiConnectionProvider)connectionProvider;
            settings.put("hibernate.connection.datasource", jndiConnectionProvider.getJndiResource());
        } else {
            throw new Error("Unsupported connection provider: " + connectionProvider);
        }
        settings.put("hibernate.ejb.metamodel.population", "enabled");
    }

    protected FileObject getEntityLocation(FileObject root, Table table) throws FileSystemException {
        return root.resolveFile(this.entityNameToFileName(table));
    }

    @NotNull
    protected String entityNameToFileName(Table table) {
        return this.getMappedClassName(table).replace('.', '/') + ".class";
    }

    @NotNull
    public String getMappedClassName(Table table) {
        return SessionFactoryBuilder.getMappedClassName(table, this.entityMode);
    }

    @NotNull
    public static String getMappedClassName(Table table, EntityMode entityMode) {
        return table.getActualJavaClass() == null ? SessionFactoryBuilder.deriveMappedClassName(table, entityMode) : table.getActualJavaClass().getName();
    }

    @NotNull
    public static String deriveMappedClassName(Table table, EntityMode entityMode) {
        String packageName = table.getSchema().getQualifiedName().toLowerCase();
        String className = table.getActualEntityName();
        className = entityMode == EntityMode.POJO ? Arrays.stream(StringUtils.split((String)className, (String)"_- ")).map(StringUtils::capitalize).collect(Collectors.joining()) : className.replaceAll("-|\\h", "");
        if (Character.isDigit(className.charAt(0))) {
            className = "_" + className;
        }
        String fullName = packageName + "." + className;
        for (Table other : table.getSchema().getDatabase().getAllTables()) {
            if (other == table || other.getActualJavaClass() == null || !other.getActualJavaClass().getName().equals(fullName)) continue;
            fullName = fullName + "_1";
        }
        return fullName;
    }

    public Class<?> getPersistentClass(Table table, CodeBase codeBase) throws IOException, ClassNotFoundException {
        Class javaClass = table.getActualJavaClass();
        if (javaClass != null) {
            return javaClass;
        }
        return codeBase.loadClass(this.getMappedClassName(table));
    }

    public byte[] getClassFile(Table table) throws NotFoundException, IOException, CannotCompileException {
        return this.getMappedClass(table).toBytecode();
    }

    public CtClass generateBaseClass() throws NotFoundException {
        CtClass cc = this.classPool.makeClass(this.getBaseEntityName());
        cc.addInterface(this.classPool.get(Serializable.class.getName()));
        ClassFile ccFile = cc.getClassFile();
        ConstPool constPool = ccFile.getConstPool();
        AnnotationsAttribute classAnnotations = new AnnotationsAttribute(constPool, "RuntimeVisibleAnnotations");
        ccFile.addAttribute((AttributeInfo)classAnnotations);
        Annotation annotation = new Annotation(MappedSuperclass.class.getName(), constPool);
        classAnnotations.addAnnotation(annotation);
        Annotation stringBooleanType = new Annotation(TypeDef.class.getName(), constPool);
        stringBooleanType.addMemberValue("name", (MemberValue)new StringMemberValue(StringBooleanType.class.getName(), constPool));
        stringBooleanType.addMemberValue("typeClass", (MemberValue)new ClassMemberValue(StringBooleanType.class.getName(), constPool));
        ArrayMemberValue parameters = new ArrayMemberValue((MemberValue)new AnnotationMemberValue(constPool), constPool);
        parameters.setValue((MemberValue[])new AnnotationMemberValue[]{new AnnotationMemberValue(this.makeParameterAnnotation("trueString", this.trueString, constPool), constPool), new AnnotationMemberValue(this.makeParameterAnnotation("falseString", this.falseString, constPool), constPool)});
        stringBooleanType.addMemberValue("parameters", (MemberValue)parameters);
        annotation = new Annotation(TypeDefs.class.getName(), constPool);
        ArrayMemberValue typeDefs = new ArrayMemberValue((MemberValue)new AnnotationMemberValue(constPool), constPool);
        typeDefs.setValue((MemberValue[])new AnnotationMemberValue[]{new AnnotationMemberValue(stringBooleanType, constPool)});
        annotation.addMemberValue("value", (MemberValue)typeDefs);
        classAnnotations.addAnnotation(annotation);
        return cc;
    }

    protected Annotation makeParameterAnnotation(String name, String value, ConstPool constPool) {
        Annotation annotation = new Annotation(Parameter.class.getName(), constPool);
        annotation.addMemberValue("name", (MemberValue)new StringMemberValue(name, constPool));
        annotation.addMemberValue("value", (MemberValue)new StringMemberValue(value, constPool));
        return annotation;
    }

    @NotNull
    public String getBaseEntityName() {
        return this.database.getDatabaseName() + ".BaseEntity";
    }

    public CtClass generateClass(Table table) throws CannotCompileException, NotFoundException {
        CtClass cc = this.classPool.makeClass(this.getMappedClassName(table));
        cc.setSuperclass(this.classPool.get(this.getBaseEntityName()));
        ClassFile ccFile = cc.getClassFile();
        ConstPool constPool = ccFile.getConstPool();
        AnnotationsAttribute classAnnotations = new AnnotationsAttribute(constPool, "RuntimeVisibleAnnotations");
        String schemaName = table.getSchema().getActualSchemaName();
        Annotation annotation = new Annotation(javax.persistence.Table.class.getName(), constPool);
        annotation.addMemberValue("name", (MemberValue)new StringMemberValue(this.jpaEscape(table.getTableName()), constPool));
        annotation.addMemberValue("schema", (MemberValue)new StringMemberValue(this.jpaEscape(schemaName), constPool));
        classAnnotations.addAnnotation(annotation);
        annotation = new Annotation(Entity.class.getName(), constPool);
        annotation.addMemberValue("name", (MemberValue)new StringMemberValue(table.getActualEntityName(), constPool));
        classAnnotations.addAnnotation(annotation);
        table.getAnnotations().forEach(ann -> {
            Class annotationClass = ann.getJavaAnnotationClass();
            if (javax.persistence.Table.class.equals((Object)annotationClass) || Entity.class.equals((Object)annotationClass)) {
                logger.warn("@Table or @Entity specified on table {}, skipping annotation {}", (Object)table.getQualifiedName(), (Object)annotationClass);
                return;
            }
            Annotation classAnn = this.convertAnnotation(constPool, (com.manydesigns.portofino.model.Annotation)ann);
            if (classAnn != null) {
                classAnnotations.addAnnotation(classAnn);
            }
            if (annotationClass == Updatable.class && !((Updatable)ann.getJavaAnnotation()).value()) {
                classAnnotations.addAnnotation(new Annotation(Immutable.class.getName(), constPool));
            }
        });
        ccFile.addAttribute((AttributeInfo)classAnnotations);
        this.setupColumns(table, cc, constPool);
        return cc;
    }

    @Nullable
    protected Annotation convertAnnotation(ConstPool constPool, com.manydesigns.portofino.model.Annotation portofinoAnnotation) {
        java.lang.annotation.Annotation javaAnnotation = portofinoAnnotation.getJavaAnnotation();
        if (javaAnnotation == null) {
            return null;
        }
        Class<? extends java.lang.annotation.Annotation> annotationType = javaAnnotation.annotationType();
        Annotation annotation = new Annotation(annotationType.getName(), constPool);
        for (Method method : annotationType.getMethods()) {
            if (Modifier.isStatic(method.getModifiers()) || method.getDeclaringClass() == Object.class || method.getDeclaringClass() == java.lang.annotation.Annotation.class || method.getParameterCount() > 0) {
                logger.debug("Skipping " + method);
                continue;
            }
            try {
                Object result = method.invoke((Object)javaAnnotation, new Object[0]);
                if (result == null) continue;
                Class<?> returnType = method.getReturnType();
                if (returnType == String.class) {
                    annotation.addMemberValue(method.getName(), (MemberValue)new StringMemberValue((String)result, constPool));
                    continue;
                }
                if (returnType == Integer.class || returnType == Integer.TYPE) {
                    annotation.addMemberValue(method.getName(), (MemberValue)new IntegerMemberValue(constPool, ((Integer)result).intValue()));
                    continue;
                }
                if (returnType == Long.class || returnType == Long.TYPE) {
                    annotation.addMemberValue(method.getName(), (MemberValue)new LongMemberValue(((Long)result).longValue(), constPool));
                    continue;
                }
                if (returnType == Float.class || returnType == Float.TYPE) {
                    annotation.addMemberValue(method.getName(), (MemberValue)new DoubleMemberValue(((Double)result).doubleValue(), constPool));
                    continue;
                }
                if (returnType == Double.class || returnType == Double.TYPE) {
                    annotation.addMemberValue(method.getName(), (MemberValue)new DoubleMemberValue(((Double)result).doubleValue(), constPool));
                    continue;
                }
                if (returnType == Character.class || returnType == Character.TYPE) {
                    annotation.addMemberValue(method.getName(), (MemberValue)new CharMemberValue(((Character)result).charValue(), constPool));
                    continue;
                }
                if (returnType == Boolean.class || returnType == Boolean.TYPE) {
                    annotation.addMemberValue(method.getName(), (MemberValue)new BooleanMemberValue(((Boolean)result).booleanValue(), constPool));
                    continue;
                }
                if (returnType == Class.class) {
                    annotation.addMemberValue(method.getName(), (MemberValue)new ClassMemberValue(((Class)result).getName(), constPool));
                    continue;
                }
                if (!returnType.isEnum()) continue;
                EnumMemberValue value = new EnumMemberValue(constPool);
                value.setType(returnType.getName());
                value.setValue(((Enum)result).name());
                annotation.addMemberValue(method.getName(), (MemberValue)value);
            }
            catch (Exception e) {
                logger.warn("Skipping " + method + " as it errored", (Throwable)e);
            }
        }
        return annotation;
    }

    protected void setupColumns(Table table, CtClass cc, ConstPool constPool) throws CannotCompileException, NotFoundException {
        List columnPKList = table.getPrimaryKey().getColumns();
        for (com.manydesigns.portofino.model.database.Column column : table.getColumns()) {
            String propertyName = column.getActualPropertyName();
            CtField field = new CtField(this.classPool.get(column.getActualJavaType().getName()), propertyName, cc);
            AnnotationsAttribute fieldAnnotations = new AnnotationsAttribute(constPool, "RuntimeVisibleAnnotations");
            Annotation annotation = new Annotation(Column.class.getName(), constPool);
            annotation.addMemberValue("name", (MemberValue)new StringMemberValue(this.jpaEscape(column.getColumnName()), constPool));
            annotation.addMemberValue("nullable", (MemberValue)new BooleanMemberValue(column.isNullable(), constPool));
            if (column.getLength() != null) {
                annotation.addMemberValue("precision", (MemberValue)new IntegerMemberValue(constPool, column.getLength().intValue()));
                annotation.addMemberValue("length", (MemberValue)new IntegerMemberValue(constPool, column.getLength().intValue()));
            }
            if (column.getScale() != null) {
                annotation.addMemberValue("scale", (MemberValue)new IntegerMemberValue(constPool, column.getScale().intValue()));
            }
            fieldAnnotations.addAnnotation(annotation);
            if (columnPKList.contains(column)) {
                annotation.addMemberValue("updatable", (MemberValue)new BooleanMemberValue(false, constPool));
                annotation = new Annotation(Id.class.getName(), constPool);
                fieldAnnotations.addAnnotation(annotation);
                if (column.isAutoincrement()) {
                    this.setupIdentityGenerator(fieldAnnotations, constPool);
                } else {
                    PrimaryKeyColumn pkColumn = table.getPrimaryKey().findPrimaryKeyColumnByName(column.getColumnName());
                    Generator generator = pkColumn.getGenerator();
                    if (generator != null) {
                        this.setupNonIdentityGenerator(table, fieldAnnotations, generator, constPool);
                    }
                }
            }
            this.setupColumnType(column, fieldAnnotations, constPool);
            column.getAnnotations().forEach(ann -> {
                Class annotationClass = ann.getJavaAnnotationClass();
                if (Column.class.equals((Object)annotationClass) || Id.class.equals((Object)annotationClass) || Type.class.equals((Object)annotationClass)) {
                    logger.warn("@Column or @Id or @Type specified on column {}, skipping annotation {}", (Object)column.getQualifiedName(), (Object)annotationClass);
                    return;
                }
                Annotation fieldAnn = this.convertAnnotation(constPool, (com.manydesigns.portofino.model.Annotation)ann);
                if (fieldAnn != null) {
                    fieldAnnotations.addAnnotation(fieldAnn);
                }
            });
            field.getFieldInfo().addAttribute((AttributeInfo)fieldAnnotations);
            cc.addField(field);
            String accessorName = propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
            cc.addMethod(CtNewMethod.getter((String)("get" + accessorName), (CtField)field));
            cc.addMethod(CtNewMethod.setter((String)("set" + accessorName), (CtField)field));
        }
    }

    public String jpaEscape(String columnName) {
        return "\"" + columnName + "\"";
    }

    protected void setupIdentityGenerator(AnnotationsAttribute fieldAnnotations, ConstPool constPool) {
        Annotation annotation = this.makeGeneratedValueAnnotation(GenerationType.IDENTITY, constPool);
        fieldAnnotations.addAnnotation(annotation);
    }

    protected void setupNonIdentityGenerator(Table table, AnnotationsAttribute fieldAnnotations, Generator generator, ConstPool constPool) {
        String generatorName = table.getQualifiedName() + "_generator";
        if (generator instanceof IncrementGenerator) {
            this.addGeneratedValueAnnotation(GenerationType.AUTO, generatorName, fieldAnnotations, constPool);
            Annotation annotation = new Annotation(GenericGenerator.class.getName(), constPool);
            annotation.addMemberValue("name", (MemberValue)new StringMemberValue(generatorName, constPool));
            annotation.addMemberValue("strategy", (MemberValue)new StringMemberValue("increment", constPool));
            fieldAnnotations.addAnnotation(annotation);
        } else if (generator instanceof SequenceGenerator) {
            this.addGeneratedValueAnnotation(GenerationType.SEQUENCE, generatorName, fieldAnnotations, constPool);
            Annotation annotation = new Annotation(javax.persistence.SequenceGenerator.class.getName(), constPool);
            annotation.addMemberValue("name", (MemberValue)new StringMemberValue(generatorName, constPool));
            annotation.addMemberValue("sequenceName", (MemberValue)new StringMemberValue(((SequenceGenerator)generator).getName(), constPool));
            fieldAnnotations.addAnnotation(annotation);
        } else if (generator instanceof TableGenerator) {
            TableGenerator tableGenerator = (TableGenerator)generator;
            this.addGeneratedValueAnnotation(GenerationType.TABLE, generatorName, fieldAnnotations, constPool);
            Annotation annotation = new Annotation(javax.persistence.TableGenerator.class.getName(), constPool);
            annotation.addMemberValue("name", (MemberValue)new StringMemberValue(generatorName, constPool));
            annotation.addMemberValue("schema", (MemberValue)new StringMemberValue(table.getSchema().getActualSchemaName(), constPool));
            annotation.addMemberValue("table", (MemberValue)new StringMemberValue(tableGenerator.getTable(), constPool));
            annotation.addMemberValue("pkColumnName", (MemberValue)new StringMemberValue(tableGenerator.getKeyColumn(), constPool));
            annotation.addMemberValue("pkColumnValue", (MemberValue)new StringMemberValue(tableGenerator.getKeyValue(), constPool));
            annotation.addMemberValue("valueColumnName", (MemberValue)new StringMemberValue(tableGenerator.getValueColumn(), constPool));
            fieldAnnotations.addAnnotation(annotation);
        } else {
            throw new IllegalArgumentException("Unsupported generator: " + generator);
        }
    }

    protected void addGeneratedValueAnnotation(GenerationType generationType, String generatorName, AnnotationsAttribute fieldAnnotations, ConstPool constPool) {
        Annotation annotation = this.makeGeneratedValueAnnotation(generationType, constPool);
        annotation.addMemberValue("generator", (MemberValue)new StringMemberValue(generatorName, constPool));
        fieldAnnotations.addAnnotation(annotation);
    }

    @NotNull
    protected Annotation makeGeneratedValueAnnotation(GenerationType identity, ConstPool constPool) {
        Annotation annotation = new Annotation(GeneratedValue.class.getName(), constPool);
        EnumMemberValue value = new EnumMemberValue(constPool);
        value.setType(GenerationType.class.getName());
        value.setValue(identity.name());
        annotation.addMemberValue("strategy", (MemberValue)value);
        return annotation;
    }

    protected void setupColumnType(com.manydesigns.portofino.model.database.Column column, AnnotationsAttribute fieldAnnotations, ConstPool constPool) {
        if (Boolean.class.equals((Object)column.getActualJavaType())) {
            if (column.getJdbcType() == 1 || column.getJdbcType() == 12) {
                Annotation annotation = new Annotation(Type.class.getName(), constPool);
                annotation.addMemberValue("type", (MemberValue)new StringMemberValue(StringBooleanType.class.getName(), constPool));
                fieldAnnotations.addAnnotation(annotation);
            }
        } else if (DateTime.class.isAssignableFrom(column.getActualJavaType())) {
            Annotation annotation = new Annotation(Type.class.getName(), constPool);
            annotation.addMemberValue("type", (MemberValue)new StringMemberValue(PersistentDateTime.class.getName(), constPool));
            ArrayMemberValue parameters = new ArrayMemberValue((MemberValue)new AnnotationMemberValue(constPool), constPool);
            parameters.setValue((MemberValue[])new AnnotationMemberValue[]{new AnnotationMemberValue(this.makeParameterAnnotation("databaseZone", "jvm", constPool), constPool)});
            annotation.addMemberValue("parameters", (MemberValue)parameters);
            fieldAnnotations.addAnnotation(annotation);
        } else {
            DatabasePlatform.TypeDescriptor databaseSpecificType = this.database.getConnectionProvider().getDatabasePlatform().getDatabaseSpecificType(column);
            if (databaseSpecificType != null) {
                Annotation annotation = new Annotation(Type.class.getName(), constPool);
                annotation.addMemberValue("type", (MemberValue)new StringMemberValue(databaseSpecificType.name, constPool));
                ArrayMemberValue parameters = new ArrayMemberValue((MemberValue)new AnnotationMemberValue(constPool), constPool);
                ArrayList typeParams = new ArrayList();
                databaseSpecificType.parameters.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
                    Annotation typeParam = this.makeParameterAnnotation(key.toString(), String.valueOf(value), constPool);
                    typeParams.add(new AnnotationMemberValue(typeParam, constPool));
                }));
                parameters.setValue((MemberValue[])typeParams.toArray(new AnnotationMemberValue[0]));
                annotation.addMemberValue("parameters", (MemberValue)parameters);
                fieldAnnotations.addAnnotation(annotation);
            }
        }
    }

    public void mapRelationships(Table table) throws NotFoundException, CannotCompileException {
        for (ForeignKey foreignKey : table.getForeignKeys()) {
            if (!this.checkValidFk(foreignKey)) continue;
            this.mapManyToOne(foreignKey);
            this.mapOneToMany(foreignKey);
        }
    }

    protected void mapManyToOne(ForeignKey foreignKey) throws CannotCompileException, NotFoundException {
        CtClass cc = this.getMappedClass(foreignKey.getFromTable());
        ClassFile ccFile = cc.getClassFile();
        ConstPool constPool = ccFile.getConstPool();
        Table toTable = foreignKey.getToTable();
        CtField field = new CtField(this.getMappedClass(toTable), foreignKey.getActualOnePropertyName(), cc);
        cc.addField(field);
        AnnotationsAttribute fieldAnnotations = new AnnotationsAttribute(constPool, "RuntimeVisibleAnnotations");
        Annotation annotation = new Annotation(ManyToOne.class.getName(), constPool);
        fieldAnnotations.addAnnotation(annotation);
        ArrayList<AnnotationMemberValue> joinColumnsValue = new ArrayList<AnnotationMemberValue>();
        for (Reference reference : foreignKey.getReferences()) {
            annotation = new Annotation(JoinColumn.class.getName(), constPool);
            annotation.addMemberValue("insertable", (MemberValue)new BooleanMemberValue(false, constPool));
            annotation.addMemberValue("updatable", (MemberValue)new BooleanMemberValue(false, constPool));
            annotation.addMemberValue("name", (MemberValue)new StringMemberValue(this.jpaEscape(reference.getFromColumn()), constPool));
            annotation.addMemberValue("referencedColumnName", (MemberValue)new StringMemberValue(this.jpaEscape(reference.getToColumn()), constPool));
            joinColumnsValue.add(new AnnotationMemberValue(annotation, constPool));
        }
        annotation = new Annotation(JoinColumns.class.getName(), constPool);
        ArrayMemberValue joinColumns = new ArrayMemberValue((MemberValue)new AnnotationMemberValue(constPool), constPool);
        joinColumns.setValue(joinColumnsValue.toArray(new MemberValue[0]));
        annotation.addMemberValue("value", (MemberValue)joinColumns);
        this.finalizeRelationshipProperty(cc, field, annotation, fieldAnnotations);
    }

    protected boolean checkValidFk(ForeignKey foreignKey) {
        Table toTable = foreignKey.getToTable();
        if (toTable == null) {
            logger.error("The foreign key " + foreignKey.getQualifiedName() + " does not refer to any table.");
            return false;
        }
        if (this.checkInvalidPrimaryKey(toTable, false)) {
            logger.error("The foreign key " + foreignKey.getQualifiedName() + " refers to a table with absent or invalid primary key.");
            return false;
        }
        HashSet<com.manydesigns.portofino.model.database.Column> fkColumns = new HashSet<com.manydesigns.portofino.model.database.Column>();
        HashSet pkColumns = new HashSet(toTable.getPrimaryKey().getColumns());
        for (Reference reference : foreignKey.getReferences()) {
            fkColumns.add(reference.getActualToColumn());
        }
        if (!fkColumns.equals(pkColumns)) {
            logger.error("The foreign key " + foreignKey.getQualifiedName() + " does not refer to the exact primary key of table " + toTable.getQualifiedName() + ", this is not supported.");
            return false;
        }
        try {
            this.getMappedClass(toTable);
        }
        catch (NotFoundException e) {
            logger.error("The foreign key " + foreignKey.getQualifiedName() + " refers to unmapped table " + toTable.getQualifiedName() + ", skipping.");
            return false;
        }
        return true;
    }

    protected void mapOneToMany(ForeignKey foreignKey) throws NotFoundException, CannotCompileException {
        CtClass cc = this.getMappedClass(foreignKey.getToTable());
        ClassFile ccFile = cc.getClassFile();
        ConstPool constPool = ccFile.getConstPool();
        Table fromTable = foreignKey.getFromTable();
        CtField field = new CtField(this.classPool.get(List.class.getName()), foreignKey.getActualManyPropertyName(), cc);
        String referencedClassName = this.getMappedClassName(fromTable);
        field.setGenericSignature("Ljava/util/List<L" + referencedClassName.replace('.', '/') + ";>;");
        cc.addField(field);
        AnnotationsAttribute fieldAnnotations = new AnnotationsAttribute(constPool, "RuntimeVisibleAnnotations");
        Annotation annotation = new Annotation(OneToMany.class.getName(), constPool);
        annotation.addMemberValue("targetEntity", (MemberValue)new ClassMemberValue(referencedClassName, constPool));
        annotation.addMemberValue("mappedBy", (MemberValue)new StringMemberValue(foreignKey.getActualOnePropertyName(), constPool));
        this.finalizeRelationshipProperty(cc, field, annotation, fieldAnnotations);
    }

    protected void finalizeRelationshipProperty(CtClass cc, CtField field, Annotation annotation, AnnotationsAttribute fieldAnnotations) throws CannotCompileException {
        fieldAnnotations.addAnnotation(annotation);
        field.getFieldInfo().addAttribute((AttributeInfo)fieldAnnotations);
        String accessorName = field.getName().toUpperCase() + field.getName().substring(1);
        cc.addMethod(CtNewMethod.getter((String)("get" + accessorName), (CtField)field));
        cc.addMethod(CtNewMethod.setter((String)("set" + accessorName), (CtField)field));
    }

    protected CtClass getMappedClass(Table table) throws NotFoundException {
        return this.classPool.get(this.getMappedClassName(table));
    }

    public EntityMode getEntityMode() {
        return this.entityMode;
    }

    public static class DynamicClassLoaderService
    extends ClassLoaderServiceImpl {
        public final Map<String, Class> classes = new HashMap<String, Class>();

        public <T> Class<T> classForName(String className) {
            Class theClass = this.classes.get(className);
            if (theClass != null) {
                return theClass;
            }
            return super.classForName(className);
        }
    }
}

