/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.persistence;

import com.manydesigns.portofino.cache.CacheResetEvent;
import com.manydesigns.portofino.cache.CacheResetListenerRegistry;
import com.manydesigns.portofino.liquibase.VFSResourceAccessor;
import com.manydesigns.portofino.model.Model;
import com.manydesigns.portofino.model.database.ConnectionProvider;
import com.manydesigns.portofino.model.database.DatabaseLogic;
import com.manydesigns.portofino.model.database.Schema;
import com.manydesigns.portofino.model.database.Table;
import com.manydesigns.portofino.model.database.View;
import com.manydesigns.portofino.model.database.platforms.DatabasePlatformsRegistry;
import com.manydesigns.portofino.persistence.hibernate.HibernateDatabaseSetup;
import com.manydesigns.portofino.persistence.hibernate.SessionFactoryAndCodeBase;
import com.manydesigns.portofino.persistence.hibernate.SessionFactoryBuilder;
import com.manydesigns.portofino.reflection.TableAccessor;
import com.manydesigns.portofino.reflection.ViewAccessor;
import com.manydesigns.portofino.sync.DatabaseSyncer;
import io.reactivex.subjects.BehaviorSubject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import liquibase.Contexts;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.resource.ResourceAccessor;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Persistence {
    public static final String copyright = "Copyright (C) 2005-2020 ManyDesigns srl";
    public static final String APP_MODEL_DIRECTORY = "portofino-model";
    @Deprecated
    public static final String APP_MODEL_FILE = "portofino-model.xml";
    public static final String LIQUIBASE_CONTEXT = "liquibase.context";
    public static final String changelogFileNameTemplate = "liquibase.changelog.xml";
    protected final DatabasePlatformsRegistry databasePlatformsRegistry;
    protected Model model;
    protected final Map<String, HibernateDatabaseSetup> setups;
    protected final FileObject appDir;
    protected final Configuration configuration;
    protected final FileBasedConfigurationBuilder<PropertiesConfiguration> configurationFile;
    public final BehaviorSubject<Status> status = BehaviorSubject.create();
    public CacheResetListenerRegistry cacheResetListenerRegistry;
    public static final Logger logger = LoggerFactory.getLogger(Persistence.class);

    public Persistence(FileObject appDir, Configuration configuration, FileBasedConfigurationBuilder<PropertiesConfiguration> configurationFile, DatabasePlatformsRegistry databasePlatformsRegistry) throws FileSystemException {
        this.appDir = appDir;
        this.configuration = configuration;
        this.configurationFile = configurationFile;
        this.databasePlatformsRegistry = databasePlatformsRegistry;
        if (this.getModelFile().exists()) {
            logger.info("Legacy application model file: {}", (Object)this.getModelFile().getName().getPath());
        } else {
            logger.info("Application model directory: {}", (Object)this.getModelDirectory().getName().getPath());
        }
        this.setups = new HashMap<String, HibernateDatabaseSetup>();
    }

    public synchronized void loadXmlModel() {
        try {
            JAXBContext jc = JAXBContext.newInstance((String)Model.class.getPackage().getName());
            Unmarshaller um = jc.createUnmarshaller();
            FileObject appModelFile = this.getModelFile();
            if (appModelFile.exists()) {
                logger.info("Loading legacy xml model from file: {}", (Object)appModelFile.getName().getPath());
                try (InputStream inputStream = appModelFile.getContent().getInputStream();){
                    this.model = (Model)um.unmarshal(inputStream);
                }
                catch (Exception e) {
                    String msg = "Cannot load/parse model: " + appModelFile;
                    logger.error(msg, (Throwable)e);
                }
            } else {
                logger.info("Loading model from directory: {}", (Object)this.getModelDirectory().getName().getPath());
                this.model = new Model();
            }
            FileObject modelDir = this.getModelDirectory();
            if (modelDir.exists()) {
                for (FileObject databaseDir : modelDir.getChildren()) {
                    this.loadXmlDatabase(um, this.model, databaseDir);
                }
            }
            this.initModel();
        }
        catch (Exception e) {
            logger.error("Cannot load/parse model", (Throwable)e);
        }
    }

    protected void loadXmlDatabase(Unmarshaller um, Model model, FileObject databaseDir) throws IOException, JAXBException {
        com.manydesigns.portofino.model.database.Database database;
        if (!databaseDir.getType().equals((Object)FileType.FOLDER)) {
            logger.error("Not a directory: " + databaseDir.getName().getPath());
            return;
        }
        String databaseName = databaseDir.getName().getBaseName();
        FileObject databaseFile = databaseDir.resolveFile("database.xml");
        if (databaseFile.exists()) {
            logger.info("Loading database connection from " + databaseFile.getName().getPath());
            try (InputStream inputStream = databaseFile.getContent().getInputStream();){
                database = (com.manydesigns.portofino.model.database.Database)um.unmarshal(inputStream);
                database.afterUnmarshal(um, (Object)model);
                if (!databaseName.equals(database.getDatabaseName())) {
                    logger.error("Database named {} defined in directory named {}, skipping", (Object)database.getDatabaseName(), (Object)databaseName);
                    return;
                }
                model.getDatabases().removeIf(d -> databaseName.equals(d.getDatabaseName()));
                model.getDatabases().add(database);
            }
        } else {
            database = DatabaseLogic.findDatabaseByName((Model)model, (String)databaseName);
            if (database != null) {
                logger.info("Using legacy database defined in portofino-model.xml: " + databaseName + "; it will be automatically migrated to database.xml upon save.");
            } else {
                logger.warn("No database defined in " + databaseDir.getName().getPath());
                return;
            }
        }
        for (Schema schema : database.getSchemas()) {
            FileObject schemaDir = databaseDir.resolveFile(schema.getSchemaName());
            if (schemaDir.getType() == FileType.FOLDER) {
                FileObject[] tableFiles;
                logger.debug("Schema directory {} exists", (Object)schemaDir);
                for (FileObject tableFile : tableFiles = schemaDir.getChildren()) {
                    if (!tableFile.getName().getBaseName().endsWith(".table.xml")) continue;
                    try (InputStream tableInputStream = tableFile.getContent().getInputStream();){
                        Table table = (Table)um.unmarshal(tableInputStream);
                        if (!tableFile.getName().getBaseName().equalsIgnoreCase(table.getTableName() + ".table.xml")) {
                            logger.error("Skipping table " + table.getTableName() + " defined in file " + tableFile);
                            continue;
                        }
                        table.afterUnmarshal(um, (Object)schema);
                        schema.getTables().add(table);
                    }
                }
                continue;
            }
            logger.debug("Schema directory {} does not exist", (Object)schemaDir);
        }
    }

    @Deprecated
    public FileObject getModelFile() throws FileSystemException {
        return this.appDir.resolveFile(APP_MODEL_FILE);
    }

    public FileObject getModelDirectory() throws FileSystemException {
        return this.appDir.resolveFile(APP_MODEL_DIRECTORY);
    }

    public void runLiquibase(com.manydesigns.portofino.model.database.Database database) {
        logger.info("Updating database definitions");
        VFSResourceAccessor resourceAccessor = new VFSResourceAccessor(this.appDir);
        ConnectionProvider connectionProvider = database.getConnectionProvider();
        for (Schema schema : database.getSchemas()) {
            String schemaName = schema.getSchemaName();
            try {
                Connection connection = connectionProvider.acquireConnection();
                try {
                    FileObject changelogFile = this.getLiquibaseChangelogFile(schema);
                    if (changelogFile.getType() != FileType.FILE) {
                        logger.info("Changelog file does not exist or is not a normal file, skipping: {}", (Object)changelogFile);
                        continue;
                    }
                    logger.info("Running changelog file: {}", (Object)changelogFile);
                    JdbcConnection jdbcConnection = new JdbcConnection(connection);
                    Database lqDatabase = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)jdbcConnection);
                    lqDatabase.setDefaultSchemaName(schema.getActualSchemaName());
                    String relativeChangelogPath = this.appDir.getName().getRelativeName(changelogFile.getName());
                    Liquibase lq = new Liquibase(relativeChangelogPath, (ResourceAccessor)resourceAccessor, lqDatabase);
                    Object[] contexts = this.configuration.getStringArray(LIQUIBASE_CONTEXT);
                    logger.info("Using context {}", (Object)Arrays.toString(contexts));
                    lq.update(new Contexts((String[])contexts));
                }
                finally {
                    if (connection == null) continue;
                    connection.close();
                }
            }
            catch (Exception e) {
                logger.error("Couldn't update database: " + schemaName, (Throwable)e);
            }
        }
    }

    public synchronized void saveXmlModel() throws IOException, JAXBException, ConfigurationException {
        FileObject appModelFile;
        JAXBContext jc = JAXBContext.newInstance((String)Model.class.getPackage().getName());
        Marshaller m = jc.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        FileObject modelDir = this.getModelDirectory();
        modelDir.createFolder();
        for (com.manydesigns.portofino.model.database.Database database : this.model.getDatabases()) {
            FileObject databaseDir = modelDir.resolveFile(database.getDatabaseName());
            FileObject databaseFile = databaseDir.resolveFile("database.xml");
            databaseFile.createFile();
            try (OutputStream outputStream = databaseFile.getContent().getOutputStream();){
                m.marshal((Object)database, outputStream);
            }
            for (Schema schema : database.getSchemas()) {
                FileObject schemaDir = databaseDir.resolveFile(schema.getSchemaName());
                if (!schemaDir.exists()) {
                    logger.debug("Schema directory {} does not exist", (Object)schemaDir);
                    schemaDir.createFolder();
                }
                FileObject[] tableFiles = schemaDir.getChildren();
                for (FileObject tableFile : tableFiles) {
                    if (!tableFile.getName().getBaseName().endsWith(".table.xml") || tableFile.delete()) continue;
                    logger.warn("Could not delete table file {}", (Object)tableFile.getName().getPath());
                }
                for (Table table : schema.getTables()) {
                    FileObject tableFile = schemaDir.resolveFile(table.getTableName() + ".table.xml");
                    OutputStream outputStream = tableFile.getContent().getOutputStream();
                    try {
                        m.marshal((Object)table, outputStream);
                    }
                    finally {
                        if (outputStream == null) continue;
                        outputStream.close();
                    }
                }
            }
            this.deleteUnusedSchemaDirectories(database, databaseDir);
        }
        this.deleteUnusedDatabaseDirectories();
        logger.info("Saved xml model to directory: {}", (Object)modelDir.getName().getPath());
        if (this.configurationFile != null) {
            this.configurationFile.save();
            logger.info("Saved configuration file {}", (Object)this.configurationFile.getFileHandler().getFile().getAbsolutePath());
        }
        if ((appModelFile = this.getModelFile()).exists()) {
            appModelFile.delete();
            logger.info("Deleted legacy portofino-model.xml file: {}", (Object)appModelFile.getName().getPath());
        }
    }

    protected void deleteUnusedDatabaseDirectories() throws FileSystemException {
        Arrays.stream(this.getModelDirectory().getChildren()).forEach(dbDir -> {
            String dbDirPath = dbDir.getName().getPath();
            try {
                if (dbDir.getType() == FileType.FOLDER) {
                    String dirName = dbDir.getName().getBaseName();
                    if (this.model.getDatabases().stream().noneMatch(db -> db.getDatabaseName().equals(dirName))) {
                        logger.info("Deleting unused database directory {}", (Object)dbDirPath);
                        try {
                            dbDir.deleteAll();
                        }
                        catch (FileSystemException e) {
                            logger.warn("Could not delete unused database dir " + dbDirPath, (Throwable)e);
                        }
                    }
                }
            }
            catch (FileSystemException e) {
                logger.error("Unexpected filesystem error when trying to delete schema directory " + dbDirPath, (Throwable)e);
            }
        });
    }

    protected void deleteUnusedSchemaDirectories(com.manydesigns.portofino.model.database.Database database, FileObject databaseDir) throws FileSystemException {
        Arrays.stream(databaseDir.getChildren()).forEach(schemaDir -> {
            String schemaDirPath = schemaDir.getName().getPath();
            try {
                if (schemaDir.getType() == FileType.FOLDER) {
                    String dirName = schemaDir.getName().getBaseName();
                    if (database.getSchemas().stream().noneMatch(schema -> schema.getSchemaName().equals(dirName))) {
                        logger.info("Deleting unused schema directory {}", (Object)schemaDirPath);
                        try {
                            schemaDir.deleteAll();
                        }
                        catch (FileSystemException e) {
                            logger.warn("Could not delete unused schema dir " + schemaDirPath, (Throwable)e);
                        }
                    }
                }
            }
            catch (FileSystemException e) {
                logger.error("Unexpected filesystem error when trying to delete schema directory " + schemaDirPath, (Throwable)e);
            }
        });
    }

    public synchronized void initModel() {
        logger.info("Cleaning up old setups");
        this.closeSessions();
        for (Map.Entry<String, HibernateDatabaseSetup> current : this.setups.entrySet()) {
            String databaseName = current.getKey();
            logger.debug("Cleaning up old setup for: {}", (Object)databaseName);
            HibernateDatabaseSetup hibernateDatabaseSetup = current.getValue();
            try {
                SessionFactory sessionFactory = hibernateDatabaseSetup.getSessionFactory();
                sessionFactory.close();
            }
            catch (Throwable t) {
                logger.warn("Cannot close session factory for: " + databaseName, t);
            }
        }
        this.setups.clear();
        this.model.init(this.configuration);
        for (com.manydesigns.portofino.model.database.Database database : this.model.getDatabases()) {
            this.initConnectionProvider(database);
        }
        if (this.cacheResetListenerRegistry != null) {
            this.cacheResetListenerRegistry.fireReset(new CacheResetEvent((Object)this));
        }
    }

    protected void initConnectionProvider(com.manydesigns.portofino.model.database.Database database) {
        logger.info("Initializing connection provider for database " + database.getDatabaseName());
        try {
            ConnectionProvider connectionProvider = database.getConnectionProvider();
            connectionProvider.init(this.databasePlatformsRegistry);
            if (connectionProvider.getStatus().equals("connected")) {
                SessionFactoryBuilder builder = new SessionFactoryBuilder(database);
                SessionFactoryAndCodeBase sessionFactoryAndCodeBase = builder.buildSessionFactory();
                HibernateDatabaseSetup setup = new HibernateDatabaseSetup(database, sessionFactoryAndCodeBase.sessionFactory, sessionFactoryAndCodeBase.codeBase, builder.getEntityMode());
                String databaseName = database.getDatabaseName();
                this.setups.put(databaseName, setup);
            }
        }
        catch (Exception e) {
            logger.error("Could not create connection provider for " + database, (Throwable)e);
        }
    }

    public void retryFailedConnections() {
        Status currentStatus = (Status)((Object)this.status.getValue());
        if (currentStatus != Status.STARTED) {
            throw new IllegalStateException("Persistence not started: " + (Object)((Object)currentStatus));
        }
        for (com.manydesigns.portofino.model.database.Database database : this.model.getDatabases()) {
            if ("connected".equals(database.getConnectionProvider().getStatus())) continue;
            logger.info("Retrying failed connection to database " + database.getDatabaseName());
            this.initConnectionProvider(database);
        }
    }

    public ConnectionProvider getConnectionProvider(String databaseName) {
        for (com.manydesigns.portofino.model.database.Database database : this.model.getDatabases()) {
            if (!database.getDatabaseName().equals(databaseName)) continue;
            return database.getConnectionProvider();
        }
        return null;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public DatabasePlatformsRegistry getDatabasePlatformsRegistry() {
        return this.databasePlatformsRegistry;
    }

    public Model getModel() {
        return this.model;
    }

    public synchronized void syncDataModel(String databaseName) throws Exception {
        com.manydesigns.portofino.model.database.Database sourceDatabase = DatabaseLogic.findDatabaseByName((Model)this.model, (String)databaseName);
        if (sourceDatabase == null) {
            throw new IllegalArgumentException("Database " + databaseName + " does not exist");
        }
        if (this.configuration.getBoolean("liquibase.enabled", true)) {
            this.runLiquibase(sourceDatabase);
        } else {
            logger.debug("syncDataModel called, but Liquibase is not enabled");
        }
        ConnectionProvider connectionProvider = sourceDatabase.getConnectionProvider();
        DatabaseSyncer dbSyncer = new DatabaseSyncer(connectionProvider);
        com.manydesigns.portofino.model.database.Database targetDatabase = dbSyncer.syncDatabase(this.model);
        this.model.getDatabases().remove(sourceDatabase);
        this.model.getDatabases().add(targetDatabase);
    }

    public Session getSession(String databaseName) {
        return this.ensureDatabaseSetup(databaseName).getThreadSession();
    }

    protected HibernateDatabaseSetup ensureDatabaseSetup(String databaseName) {
        HibernateDatabaseSetup setup = this.getDatabaseSetup(databaseName);
        if (setup == null) {
            throw new Error("No setup exists for database: " + databaseName);
        }
        return setup;
    }

    public HibernateDatabaseSetup getDatabaseSetup(String databaseName) {
        return this.setups.get(databaseName);
    }

    public void closeSessions() {
        for (HibernateDatabaseSetup current : this.setups.values()) {
            this.closeSession(current);
        }
    }

    public void closeSession(String databaseName) {
        this.closeSession(this.ensureDatabaseSetup(databaseName));
    }

    protected void closeSession(HibernateDatabaseSetup current) {
        Session session = current.getThreadSession(false);
        if (session != null) {
            try {
                Transaction transaction = session.getTransaction();
                if (transaction != null && transaction.isActive()) {
                    transaction.rollback();
                }
                session.close();
            }
            catch (Throwable e) {
                logger.warn("Couldn't close session: " + ExceptionUtils.getRootCauseMessage((Throwable)e), e);
            }
            current.removeThreadSession();
        }
    }

    @NotNull
    public TableAccessor getTableAccessor(String databaseName, String entityName) {
        com.manydesigns.portofino.model.database.Database database = DatabaseLogic.findDatabaseByName((Model)this.model, (String)databaseName);
        if (database == null) {
            throw new IllegalArgumentException("Database " + databaseName + " does not exist");
        }
        Table table = DatabaseLogic.findTableByEntityName((com.manydesigns.portofino.model.database.Database)database, (String)entityName);
        if (table == null) {
            throw new IllegalArgumentException("Table " + entityName + " not found in database " + databaseName);
        }
        return table instanceof View ? new ViewAccessor((View)table) : new TableAccessor(table);
    }

    public void start() {
        this.status.onNext((Object)Status.STARTING);
        this.loadXmlModel();
        for (com.manydesigns.portofino.model.database.Database database : this.model.getDatabases()) {
            if (!"connected".equals(database.getConnectionProvider().getStatus())) continue;
            this.runLiquibase(database);
        }
        this.status.onNext((Object)Status.STARTED);
    }

    public void stop() {
        this.status.onNext((Object)Status.STOPPING);
        this.closeSessions();
        for (HibernateDatabaseSetup setup : this.setups.values()) {
            setup.getSessionFactory().close();
        }
        for (com.manydesigns.portofino.model.database.Database database : this.model.getDatabases()) {
            ConnectionProvider connectionProvider = database.getConnectionProvider();
            connectionProvider.shutdown();
        }
        this.status.onNext((Object)Status.STOPPED);
    }

    public String getName() {
        return this.getConfiguration().getString("app.name");
    }

    public FileObject getLiquibaseChangelogFile(Schema schema) throws FileSystemException {
        if (schema == null) {
            return null;
        }
        FileObject dbDir = this.getModelDirectory().resolveFile(schema.getDatabaseName());
        FileObject schemaDir = dbDir.resolveFile(schema.getSchemaName());
        return schemaDir.resolveFile(changelogFileNameTemplate);
    }

    @Deprecated
    public FileObject getAppModelFile() {
        try {
            return this.getModelFile();
        }
        catch (FileSystemException e) {
            throw new RuntimeException(e);
        }
    }

    public static enum Status {
        STARTING,
        STARTED,
        STOPPING,
        STOPPED;

    }
}

