/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.database.platforms;

import com.manydesigns.portofino.database.platforms.DatabasePlatform;
import com.manydesigns.portofino.model.database.ConnectionProvider;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabasePlatformsRegistry {
    public static final String copyright = "Copyright (c) 2005-2015, ManyDesigns srl";
    protected final Configuration portofinoConfiguration;
    protected final List<DatabasePlatform> databasePlatformList = new ArrayList<DatabasePlatform>();
    public static final Logger logger = LoggerFactory.getLogger(DatabasePlatformsRegistry.class);

    public DatabasePlatformsRegistry(Configuration portofinoConfiguration) {
        this.portofinoConfiguration = portofinoConfiguration;
    }

    public void addDatabasePlatform(DatabasePlatform databasePlatform) {
        logger.debug("Adding database platform: {}", (Object)databasePlatform);
        databasePlatform.test();
        this.databasePlatformList.add(databasePlatform);
    }

    public DatabasePlatform findApplicableAbstraction(ConnectionProvider connectionProvider) {
        for (DatabasePlatform current : this.databasePlatformList) {
            if (!current.isApplicable(connectionProvider)) continue;
            return current;
        }
        return null;
    }

    public DatabasePlatform[] getDatabasePlatforms() {
        DatabasePlatform[] result = new DatabasePlatform[this.databasePlatformList.size()];
        this.databasePlatformList.toArray(result);
        return result;
    }

    public Configuration getPortofinoConfiguration() {
        return this.portofinoConfiguration;
    }
}

