/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.persistence.hibernate;

import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HibernateDatabaseSetup {
    public static final String copyright = "Copyright (C) 2005-2017 ManyDesigns srl";
    protected final Configuration configuration;
    protected final SessionFactory sessionFactory;
    protected final ThreadLocal<Session> threadSessions;
    public static final Logger logger = LoggerFactory.getLogger(HibernateDatabaseSetup.class);

    public HibernateDatabaseSetup(Configuration configuration, SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
        this.configuration = configuration;
        this.threadSessions = new ThreadLocal();
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public ThreadLocal<Session> getThreadSessions() {
        return this.threadSessions;
    }

    public Session getThreadSession() {
        return this.getThreadSession(true);
    }

    public Session getThreadSession(boolean create) {
        Session session = this.threadSessions.get();
        if (session == null && create) {
            if (logger.isDebugEnabled()) {
                logger.debug("Creating thread-local session for {}", (Object)Thread.currentThread());
            }
            session = this.sessionFactory.openSession();
            session.beginTransaction();
            this.threadSessions.set(session);
        }
        return session;
    }

    public void setThreadSession(Session session) {
        this.threadSessions.set(session);
    }

    public void removeThreadSession() {
        this.threadSessions.remove();
    }
}

