/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.sync;

import com.manydesigns.elements.util.ReflectionUtil;
import com.manydesigns.portofino.model.Annotated;
import com.manydesigns.portofino.model.Annotation;
import com.manydesigns.portofino.model.Model;
import com.manydesigns.portofino.model.database.ConnectionProvider;
import com.manydesigns.portofino.model.database.DatabaseLogic;
import com.manydesigns.portofino.model.database.Generator;
import com.manydesigns.portofino.model.database.HasReferences;
import com.manydesigns.portofino.model.database.ModelSelectionProvider;
import com.manydesigns.portofino.model.database.PrimaryKey;
import com.manydesigns.portofino.model.database.PrimaryKeyColumn;
import com.manydesigns.portofino.model.database.Reference;
import com.manydesigns.portofino.model.database.Schema;
import com.manydesigns.portofino.model.database.Table;
import com.manydesigns.portofino.model.database.Type;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.Types;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import liquibase.CatalogAndSchema;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.SnapshotControl;
import liquibase.snapshot.SnapshotGeneratorFactory;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Column;
import liquibase.structure.core.ForeignKey;
import liquibase.structure.core.ForeignKeyConstraintType;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseSyncer {
    public static final String copyright = "Copyright (C) 2005-2017 ManyDesigns srl";
    public static final Logger logger = LoggerFactory.getLogger(DatabaseSyncer.class);
    protected final ConnectionProvider connectionProvider;

    public DatabaseSyncer(ConnectionProvider connectionProvider) {
        this.connectionProvider = connectionProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public com.manydesigns.portofino.model.database.Database syncDatabase(Model sourceModel) throws Exception {
        String databaseName = this.connectionProvider.getDatabase().getDatabaseName();
        com.manydesigns.portofino.model.database.Database targetDatabase = new com.manydesigns.portofino.model.database.Database();
        targetDatabase.setDatabaseName(databaseName);
        Connection conn = null;
        try {
            logger.debug("Acquiring connection");
            conn = this.connectionProvider.acquireConnection();
            logger.debug("Creating Liquibase connection");
            JdbcConnection liquibaseConnection = new JdbcConnection(conn);
            logger.debug("Retrieving source database");
            com.manydesigns.portofino.model.database.Database sourceDatabase = DatabaseLogic.findDatabaseByName((Model)sourceModel, (String)databaseName);
            if (sourceDatabase == null) {
                logger.debug("Source database not found. Creating an empty one.");
                sourceDatabase = new com.manydesigns.portofino.model.database.Database();
            } else {
                logger.debug("Source database was already configured. Copying true string and false string.");
                targetDatabase.setTrueString(sourceDatabase.getTrueString());
                targetDatabase.setFalseString(sourceDatabase.getFalseString());
            }
            logger.debug("Reading schema names from metadata");
            List schemas = this.connectionProvider.getDatabase().getSchemas();
            SnapshotGeneratorFactory dsgf = SnapshotGeneratorFactory.getInstance();
            logger.debug("Finding Liquibase database");
            DatabaseFactory databaseFactory = DatabaseFactory.getInstance();
            Database liquibaseDatabase = databaseFactory.findCorrectDatabaseImplementation((DatabaseConnection)liquibaseConnection);
            for (Schema schema : schemas) {
                String schemaName = schema.getSchemaName();
                logger.info("Processing schema: {}", (Object)schemaName);
                Schema sourceSchema = DatabaseLogic.findSchemaByNameIgnoreCase((com.manydesigns.portofino.model.database.Database)sourceDatabase, (String)schemaName);
                if (sourceSchema == null) {
                    logger.debug("Source schema not found. Creating an empty one.");
                    sourceSchema = new Schema();
                    sourceSchema.setSchemaName(schemaName);
                }
                logger.debug("Creating Liquibase database snapshot");
                String catalog = null;
                if (sourceSchema.getCatalog() != null) {
                    catalog = sourceSchema.getCatalog();
                }
                SnapshotControl snapshotControl = new SnapshotControl(liquibaseDatabase);
                DatabaseSnapshot snapshot = dsgf.createSnapshot(new CatalogAndSchema(catalog, schemaName), liquibaseDatabase, snapshotControl);
                logger.debug("Synchronizing schema");
                Schema targetSchema = new Schema();
                targetSchema.setDatabase(targetDatabase);
                targetSchema.setCatalog(catalog);
                targetDatabase.getSchemas().add(targetSchema);
                this.syncSchema(snapshot, sourceSchema, targetSchema);
            }
        }
        catch (Throwable throwable) {
            this.connectionProvider.releaseConnection(conn);
            throw throwable;
        }
        this.connectionProvider.releaseConnection(conn);
        targetDatabase.setConnectionProvider(this.connectionProvider);
        this.connectionProvider.setDatabase(targetDatabase);
        return targetDatabase;
    }

    public Schema syncSchema(DatabaseSnapshot databaseSnapshot, Schema sourceSchema, Schema targetSchema) {
        logger.info("Synchronizing schema: {}", (Object)sourceSchema.getSchemaName());
        targetSchema.setSchemaName(sourceSchema.getSchemaName());
        this.syncTables(databaseSnapshot, sourceSchema, targetSchema);
        this.syncPrimaryKeys(databaseSnapshot, sourceSchema, targetSchema);
        this.syncForeignKeys(databaseSnapshot, sourceSchema, targetSchema);
        return targetSchema;
    }

    protected void syncForeignKeys(DatabaseSnapshot databaseSnapshot, Schema sourceSchema, Schema targetSchema) {
        logger.info("Synchronizing foreign keys");
        for (ForeignKey liquibaseFK : databaseSnapshot.get(ForeignKey.class)) {
            String fkName = liquibaseFK.getName();
            logger.info("Synchronizing foreign key {}", (Object)fkName);
            String fkTableName = liquibaseFK.getForeignKeyTable().getName();
            Table sourceTable = DatabaseLogic.findTableByNameIgnoreCase((Schema)sourceSchema, (String)fkTableName);
            Table targetFromTable = DatabaseLogic.findTableByNameIgnoreCase((Schema)targetSchema, (String)fkTableName);
            if (targetFromTable == null) {
                logger.error("Table '{}' not found in schema '{}'. Skipping foreign key: {}", new Object[]{fkTableName, targetSchema.getSchemaName(), fkName});
                continue;
            }
            com.manydesigns.portofino.model.database.ForeignKey targetFK = new com.manydesigns.portofino.model.database.ForeignKey(targetFromTable);
            targetFK.setName(fkName);
            liquibase.structure.core.Table liquibasePkTable = liquibaseFK.getPrimaryKeyTable();
            targetFK.setToDatabase(targetSchema.getDatabaseName());
            String pkSchemaName = liquibasePkTable.getSchema().getName();
            String pkTableName = this.normalizeTableName(liquibasePkTable, databaseSnapshot);
            targetFK.setToSchema(pkSchemaName);
            targetFK.setToTableName(pkTableName);
            if (pkSchemaName == null || pkTableName == null) {
                logger.error("Null schema or table name: foreign key (schema: {}, table: {}, fk: {}) references primary key (schema: {}, table: {}). Skipping foreign key.", new Object[]{targetFromTable.getSchemaName(), targetFromTable.getTableName(), fkName, pkSchemaName, pkTableName});
                continue;
            }
            com.manydesigns.portofino.model.database.Database targetDatabase = targetSchema.getDatabase();
            Schema pkSchema = DatabaseLogic.findSchemaByNameIgnoreCase((com.manydesigns.portofino.model.database.Database)targetDatabase, (String)pkSchemaName);
            if (pkSchema == null) {
                logger.error("Cannot find referenced schema: {}. Skipping foreign key.", (Object)pkSchemaName);
                continue;
            }
            Table pkTable = DatabaseLogic.findTableByNameIgnoreCase((Schema)pkSchema, (String)pkTableName);
            if (pkTable == null) {
                logger.error("Cannot find referenced table (schema: {}, table: {}). Skipping foreign key.", (Object)pkSchemaName, (Object)pkTableName);
                continue;
            }
            ForeignKeyConstraintType updateRule = liquibaseFK.getUpdateRule();
            if (updateRule == null) {
                updateRule = ForeignKeyConstraintType.importedKeyRestrict;
                logger.warn("Foreign key '{}' with null update rule. Using: {}", (Object)fkName, (Object)updateRule.name());
            }
            targetFK.setOnUpdate(updateRule.name());
            ForeignKeyConstraintType deleteRule = liquibaseFK.getDeleteRule();
            if (deleteRule == null) {
                deleteRule = ForeignKeyConstraintType.importedKeyRestrict;
                logger.warn("Foreign key '{}' with null delete rule. Using: {}", (Object)fkName, (Object)deleteRule.name());
            }
            targetFK.setOnDelete(deleteRule.name());
            List fromColumns = liquibaseFK.getForeignKeyColumns();
            List toColumns = liquibaseFK.getPrimaryKeyColumns();
            if (fromColumns.size() != toColumns.size()) {
                logger.error("Invalid foreign key {} - columns don't match", (Object)fkName);
                continue;
            }
            boolean referencesHaveErrors = false;
            for (int i = 0; i < fromColumns.size(); ++i) {
                String fromColumnName = ((Column)fromColumns.get(i)).getName();
                String toColumnName = ((Column)toColumns.get(i)).getName();
                com.manydesigns.portofino.model.database.Column fromColumn = DatabaseLogic.findColumnByNameIgnoreCase((Table)targetFromTable, (String)fromColumnName);
                if (fromColumn == null) {
                    logger.error("Cannot find from column (schema: {}, table: {}, column: {}).", new Object[]{targetFromTable.getSchemaName(), targetFromTable.getTableName(), fromColumnName});
                    referencesHaveErrors = true;
                    break;
                }
                com.manydesigns.portofino.model.database.Column toColumn = DatabaseLogic.findColumnByNameIgnoreCase((Table)pkTable, (String)toColumnName);
                if (toColumn == null) {
                    logger.error("Cannot find to column (schema: {}, table: {}, column: {}).", new Object[]{pkTable.getSchemaName(), pkTable.getTableName(), toColumnName});
                    referencesHaveErrors = true;
                    break;
                }
                Reference reference = new Reference();
                reference.setOwner((HasReferences)targetFK);
                reference.setFromColumn(fromColumn.getColumnName());
                reference.setToColumn(toColumn.getColumnName());
                targetFK.getReferences().add(reference);
            }
            if (referencesHaveErrors) {
                logger.error("Skipping foreign key (schema: {}, table: {}, fk: {}) because of errors.", new Object[]{pkTable.getSchemaName(), pkTable.getTableName(), fkName});
                continue;
            }
            com.manydesigns.portofino.model.database.ForeignKey sourceFK = sourceTable == null ? null : DatabaseLogic.findForeignKeyByNameIgnoreCase((Table)sourceTable, (String)fkName);
            if (sourceFK != null) {
                logger.debug("Found a foreign key with the same name in the previous version of the schema");
                targetFK.setManyPropertyName(sourceFK.getManyPropertyName());
                targetFK.setOnePropertyName(sourceFK.getOnePropertyName());
            }
            logger.debug("FK creation successfull. Adding FK to table.");
            targetFromTable.getForeignKeys().add(targetFK);
        }
    }

    protected String normalizeTableName(liquibase.structure.core.Table table, DatabaseSnapshot databaseSnapshot) {
        String fkTableName;
        liquibase.structure.core.Table fkTable = (liquibase.structure.core.Table)databaseSnapshot.get((DatabaseObject)table);
        if (fkTable != null) {
            fkTableName = fkTable.getName();
        } else {
            logger.warn("Could not normalize table name: " + table.getName() + "; most probably this is a sign of a foreign key to another schema, which is not supported at the moment.");
            fkTableName = null;
        }
        return fkTableName;
    }

    protected void syncPrimaryKeys(DatabaseSnapshot databaseSnapshot, Schema sourceSchema, Schema targetSchema) {
        logger.info("Synchronizing primary keys");
        for (liquibase.structure.core.PrimaryKey liquibasePK : databaseSnapshot.get(liquibase.structure.core.PrimaryKey.class)) {
            String pkTableName = liquibasePK.getTable().getName();
            Table sourceTable = DatabaseLogic.findTableByNameIgnoreCase((Schema)sourceSchema, (String)pkTableName);
            PrimaryKey sourcePK = sourceTable == null ? null : sourceTable.getPrimaryKey();
            Table targetTable = DatabaseLogic.findTableByNameIgnoreCase((Schema)targetSchema, (String)pkTableName);
            if (targetTable == null) {
                logger.error("Coud not find table: {}. Skipping PK.", (Object)pkTableName);
                continue;
            }
            PrimaryKey targetPK = new PrimaryKey(targetTable);
            String primaryKeyName = liquibasePK.getName();
            targetPK.setPrimaryKeyName(primaryKeyName);
            List columnNamesAsList = liquibasePK.getColumnNamesAsList();
            if (columnNamesAsList == null || columnNamesAsList.isEmpty()) {
                logger.error("Primary key (table: {}, pk: {}) has no columns. Skipping PK.", (Object)pkTableName, (Object)primaryKeyName);
                continue;
            }
            boolean pkColumnsHaveErrors = false;
            for (String columnName : columnNamesAsList) {
                PrimaryKeyColumn sourcePKColumn;
                PrimaryKeyColumn targetPKColumn = new PrimaryKeyColumn(targetPK);
                com.manydesigns.portofino.model.database.Column pkColumn = DatabaseLogic.findColumnByNameIgnoreCase((Table)targetTable, (String)columnName);
                if (pkColumn == null) {
                    logger.error("Primary key (table: {}, pk: {}) has invalid column: {}", new Object[]{pkTableName, primaryKeyName, columnName});
                    pkColumnsHaveErrors = true;
                    break;
                }
                targetPKColumn.setColumnName(pkColumn.getColumnName());
                if (sourcePK != null && (sourcePKColumn = sourcePK.findPrimaryKeyColumnByNameIgnoreCase(columnName)) != null) {
                    logger.debug("Found source PK column: {}", (Object)columnName);
                    Generator sourceGenerator = sourcePKColumn.getGenerator();
                    if (sourceGenerator != null) {
                        logger.debug("Found generator: {}", (Object)sourceGenerator);
                        Generator targetGenerator = (Generator)ReflectionUtil.newInstance(sourceGenerator.getClass());
                        try {
                            BeanUtils.copyProperties((Object)targetGenerator, (Object)sourceGenerator);
                        }
                        catch (Exception e) {
                            logger.error("Couldn't copy generator", (Throwable)e);
                        }
                        targetGenerator.setPrimaryKeyColumn(targetPKColumn);
                        targetPKColumn.setGenerator(sourcePKColumn.getGenerator());
                    }
                }
                targetPK.getPrimaryKeyColumns().add(targetPKColumn);
            }
            if (pkColumnsHaveErrors) {
                logger.error("Primary key (table: {}, pk: {}) has problems with columns. Skipping PK.", (Object)pkTableName, (Object)primaryKeyName);
                continue;
            }
            logger.debug("PK creation successfull. Installing PK in table.");
            targetTable.setPrimaryKey(targetPK);
        }
    }

    protected void syncTables(DatabaseSnapshot databaseSnapshot, Schema sourceSchema, Schema targetSchema) {
        logger.info("Synchronizing tables");
        for (liquibase.structure.core.Table liquibaseTable : databaseSnapshot.get(liquibase.structure.core.Table.class)) {
            String tableName = liquibaseTable.getName();
            logger.info("Processing table: {}", (Object)tableName);
            Table sourceTable = DatabaseLogic.findTableByNameIgnoreCase((Schema)sourceSchema, (String)tableName);
            if (sourceTable == null) {
                logger.debug("Added new table: {}", (Object)tableName);
                sourceTable = new Table();
            }
            Table targetTable = new Table(targetSchema);
            targetSchema.getTables().add(targetTable);
            targetTable.setTableName(tableName);
            logger.debug("Merging table attributes and annotations");
            targetTable.setEntityName(sourceTable.getEntityName());
            targetTable.setJavaClass(sourceTable.getJavaClass());
            targetTable.setShortName(sourceTable.getShortName());
            this.copyAnnotations((Annotated)sourceTable, (Annotated)targetTable);
            this.syncColumns(liquibaseTable, sourceTable, targetTable);
            this.copySelectionProviders(sourceTable, targetTable);
        }
    }

    protected void copySelectionProviders(Table sourceTable, Table targetTable) {
        for (ModelSelectionProvider sourceSP : sourceTable.getSelectionProviders()) {
            ModelSelectionProvider targetSP = (ModelSelectionProvider)ReflectionUtil.newInstance(sourceSP.getClass());
            try {
                BeanUtils.copyProperties((Object)targetSP, (Object)sourceSP);
                targetSP.setFromTable(targetTable);
                targetTable.getSelectionProviders().add(targetSP);
                for (Reference sourceReference : sourceSP.getReferences()) {
                    Reference targetReference = new Reference((HasReferences)targetSP);
                    targetSP.getReferences().add(targetReference);
                    targetReference.setFromColumn(sourceReference.getFromColumn());
                    targetReference.setToColumn(sourceReference.getToColumn());
                }
            }
            catch (Exception e) {
                logger.error("Couldn't copy selection provider {}", (Object)sourceSP);
            }
        }
    }

    protected void syncColumns(liquibase.structure.core.Table liquibaseTable, final Table sourceTable, Table targetTable) {
        logger.debug("Synchronizing columns");
        for (Column liquibaseColumn : liquibaseTable.getColumns()) {
            logger.debug("Processing column: {}", (Object)liquibaseColumn.getName());
            com.manydesigns.portofino.model.database.Column targetColumn = new com.manydesigns.portofino.model.database.Column(targetTable);
            targetColumn.setColumnName(liquibaseColumn.getName());
            logger.debug("Merging column attributes and annotations");
            targetColumn.setAutoincrement(liquibaseColumn.isAutoIncrement());
            Integer jdbcType = liquibaseColumn.getType().getDataTypeId();
            String jdbcTypeName = liquibaseColumn.getType().getTypeName();
            if ("Oracle".equals(this.connectionProvider.getDatabaseProductName())) {
                if (jdbcType == null || jdbcType == 1111) {
                    if (jdbcTypeName != null && jdbcTypeName.toUpperCase().startsWith("TIMESTAMP")) {
                        jdbcType = 93;
                    }
                } else if (jdbcType == 91) {
                    boolean dateTypePresent = false;
                    for (Type type : this.connectionProvider.getTypes()) {
                        if (!type.getTypeName().equals("DATE")) continue;
                        dateTypePresent = true;
                        break;
                    }
                    if (!dateTypePresent) {
                        jdbcType = 93;
                    }
                }
            }
            if (jdbcType == null) {
                jdbcType = 1111;
            }
            if (jdbcType == 1111) {
                logger.debug("jdbcType = OTHER, trying to determine more specific type from type name");
                try {
                    Field field = Types.class.getField(jdbcTypeName);
                    jdbcType = (Integer)field.get(null);
                }
                catch (Exception e) {
                    logger.debug("Could not determine JDBC type (type name = {})", (Object)jdbcTypeName);
                }
            }
            targetColumn.setJdbcType(jdbcType.intValue());
            targetColumn.setColumnType(jdbcTypeName);
            targetColumn.setLength(liquibaseColumn.getType().getColumnSize());
            targetColumn.setNullable(liquibaseColumn.isNullable().booleanValue());
            targetColumn.setScale(liquibaseColumn.getType().getDecimalDigits());
            com.manydesigns.portofino.model.database.Column sourceColumn = DatabaseLogic.findColumnByNameIgnoreCase((Table)sourceTable, (String)liquibaseColumn.getName());
            if (sourceColumn != null) {
                targetColumn.setPropertyName(sourceColumn.getPropertyName());
                targetColumn.setJavaType(sourceColumn.getJavaType());
                this.copyAnnotations((Annotated)sourceColumn, (Annotated)targetColumn);
            }
            logger.debug("Column creation successfull. Adding column to table.");
            targetTable.getColumns().add(targetColumn);
        }
        logger.debug("Sorting columns to preserve their previous order as much as possible");
        Collections.sort(targetTable.getColumns(), new Comparator<com.manydesigns.portofino.model.database.Column>(){

            private int oldIndex(com.manydesigns.portofino.model.database.Column c) {
                int i = 0;
                for (com.manydesigns.portofino.model.database.Column old : sourceTable.getColumns()) {
                    if (old.getColumnName().equals(c.getColumnName())) {
                        return i;
                    }
                    ++i;
                }
                return -1;
            }

            @Override
            public int compare(com.manydesigns.portofino.model.database.Column c1, com.manydesigns.portofino.model.database.Column c2) {
                Integer index1 = this.oldIndex(c1);
                Integer index2 = this.oldIndex(c2);
                if (index1 != -1) {
                    if (index2 != -1) {
                        return index1.compareTo(index2);
                    }
                    return -1;
                }
                return index2 == -1 ? 0 : 1;
            }
        });
    }

    protected void copyAnnotations(Annotated source, Annotated target) {
        for (Annotation ann : source.getAnnotations()) {
            Annotation annCopy = new Annotation();
            annCopy.setParent((Object)target);
            annCopy.setType(ann.getType());
            for (String value : ann.getValues()) {
                annCopy.getValues().add(value);
            }
            target.getAnnotations().add(annCopy);
        }
    }
}

