/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.oauth;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.auth.oauth2.CredentialStore;
import com.manydesigns.elements.ognl.OgnlUtils;
import com.manydesigns.elements.reflection.PropertyAccessor;
import com.manydesigns.portofino.model.database.Column;
import com.manydesigns.portofino.model.database.Database;
import com.manydesigns.portofino.model.database.DatabaseLogic;
import com.manydesigns.portofino.model.database.Table;
import com.manydesigns.portofino.persistence.Persistence;
import com.manydesigns.portofino.reflection.TableAccessor;
import java.io.IOException;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class DatabaseCredentialStore
implements CredentialStore {
    public static final String copyright = "Copyright (C) 2005-2016, ManyDesigns srl";
    protected final Persistence persistence;
    protected final Table table;
    protected final String idProperty;
    protected final String accessTokenProperty;
    protected final String refreshTokenProperty;
    protected final String expirationProperty;

    public DatabaseCredentialStore(Persistence persistence, String databaseName, String entityName, String idProperty, String accessTokenProperty, String refreshTokenProperty, String expirationProperty) {
        this.persistence = persistence;
        this.idProperty = idProperty;
        this.accessTokenProperty = accessTokenProperty;
        this.refreshTokenProperty = refreshTokenProperty;
        this.expirationProperty = expirationProperty;
        Database database = DatabaseLogic.findDatabaseByName(persistence.getModel(), databaseName);
        this.table = DatabaseLogic.findTableByEntityName(database, entityName);
        if (this.table == null) {
            throw new IllegalArgumentException("Table not found: " + entityName);
        }
        try {
            TableAccessor tableAccessor = new TableAccessor(this.table);
            tableAccessor.getProperty(idProperty);
            tableAccessor.getProperty(accessTokenProperty);
            tableAccessor.getProperty(refreshTokenProperty);
            tableAccessor.getProperty(expirationProperty);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException("Invalid field name", e);
        }
    }

    public boolean load(String userId, Credential credential) throws IOException {
        Session session = this.persistence.getSession(this.table.getDatabaseName());
        Column idColumn = DatabaseLogic.findColumnByPropertyName(this.table, this.idProperty);
        Object idValue = OgnlUtils.convertValue((Object)userId, (Class)idColumn.getActualJavaType());
        Criteria criteria = session.createCriteria(this.table.getActualEntityName()).add((Criterion)Restrictions.eq((String)this.idProperty, (Object)idValue));
        TableAccessor tableAccessor = new TableAccessor(this.table);
        Object record = criteria.uniqueResult();
        if (record == null) {
            return false;
        }
        try {
            Object value = tableAccessor.getProperty(this.accessTokenProperty).get(record);
            credential.setAccessToken((String)value);
            value = tableAccessor.getProperty(this.refreshTokenProperty).get(record);
            credential.setRefreshToken((String)value);
            value = tableAccessor.getProperty(this.expirationProperty).get(record);
            credential.setExpirationTimeMilliseconds((Long)OgnlUtils.convertValue((Object)value, Long.class));
            return true;
        }
        catch (NoSuchFieldException e) {
            throw new Error(e);
        }
    }

    public void store(String userId, Credential credential) throws IOException {
        boolean isNew;
        Session session = this.persistence.getSession(this.table.getDatabaseName());
        Column idColumn = DatabaseLogic.findColumnByPropertyName(this.table, this.idProperty);
        Object idValue = OgnlUtils.convertValue((Object)userId, (Class)idColumn.getActualJavaType());
        Criteria criteria = session.createCriteria(this.table.getActualEntityName()).add((Criterion)Restrictions.eq((String)this.idProperty, (Object)idValue));
        TableAccessor tableAccessor = new TableAccessor(this.table);
        Object record = criteria.uniqueResult();
        boolean bl = isNew = record == null;
        if (isNew) {
            record = this.create(tableAccessor, idValue);
        }
        try {
            tableAccessor.getProperty(this.accessTokenProperty).set(record, (Object)credential.getAccessToken());
            tableAccessor.getProperty(this.refreshTokenProperty).set(record, (Object)credential.getRefreshToken());
            PropertyAccessor exp = tableAccessor.getProperty(this.expirationProperty);
            exp.set(record, OgnlUtils.convertValue((Object)credential.getExpirationTimeMilliseconds(), (Class)exp.getType()));
        }
        catch (NoSuchFieldException e) {
            throw new Error(e);
        }
        if (isNew) {
            session.save(this.table.getActualEntityName(), record);
        } else {
            session.update(this.table.getActualEntityName(), record);
        }
        session.getTransaction().commit();
        session.beginTransaction();
    }

    protected Object create(TableAccessor tableAccessor, Object idValue) {
        Object object = tableAccessor.newInstance();
        try {
            tableAccessor.getProperty(this.idProperty).set(object, idValue);
        }
        catch (NoSuchFieldException e) {
            throw new Error(e);
        }
        return object;
    }

    public void delete(String userId, Credential credential) throws IOException {
        Session session = this.persistence.getSession(this.table.getDatabaseName());
        Column idColumn = DatabaseLogic.findColumnByPropertyName(this.table, this.idProperty);
        Object idValue = OgnlUtils.convertValue((Object)userId, (Class)idColumn.getActualJavaType());
        Criteria criteria = session.createCriteria(this.table.getActualEntityName()).add((Criterion)Restrictions.eq((String)this.idProperty, (Object)idValue));
        TableAccessor tableAccessor = new TableAccessor(this.table);
        Object record = criteria.uniqueResult();
        if (record == null) {
            throw new IllegalArgumentException("No record exists with id: " + userId);
        }
        this.delete(session, tableAccessor, record);
    }

    protected void delete(Session session, TableAccessor tableAccessor, Object record) {
        try {
            tableAccessor.getProperty(this.accessTokenProperty).set(record, null);
            tableAccessor.getProperty(this.refreshTokenProperty).set(record, null);
            tableAccessor.getProperty(this.expirationProperty).set(record, null);
            session.update(this.table.getActualEntityName(), record);
        }
        catch (NoSuchFieldException e) {
            throw new Error(e);
        }
    }
}

