/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.model;

import com.manydesigns.elements.annotations.AnnotationsManager;
import com.manydesigns.elements.ognl.OgnlUtils;
import com.manydesigns.elements.util.ReflectionUtil;
import com.manydesigns.elements.util.Util;
import com.manydesigns.portofino.model.Model;
import com.manydesigns.portofino.model.ModelObject;
import com.manydesigns.portofino.model.ModelObjectVisitor;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlAccessorType(value=XmlAccessType.NONE)
public class Annotation
implements ModelObject {
    public static final String copyright = "Copyright (C) 2005-2016, ManyDesigns srl";
    protected Object parent;
    protected String type;
    protected List<String> values = new ArrayList<String>();
    protected Class javaAnnotationClass;
    protected java.lang.annotation.Annotation javaAnnotation;
    public static final Logger logger = LoggerFactory.getLogger(Annotation.class);

    public Annotation() {
    }

    public Annotation(String type) {
        this();
        this.type = type;
    }

    public Annotation(Object parent, String type) {
        this();
        this.parent = parent;
        this.type = type;
    }

    @Override
    public void afterUnmarshal(Unmarshaller u, Object parent) {
        this.parent = parent;
    }

    @Override
    public void reset() {
        this.javaAnnotation = null;
        this.javaAnnotationClass = null;
    }

    @Override
    public void init(Model model) {
        Constructor<?>[] constructors;
        this.javaAnnotationClass = ReflectionUtil.loadClass((String)this.type);
        if (this.javaAnnotationClass == null) {
            logger.warn("Cannot load annotation class: {}", (Object)this.type);
            return;
        }
        AnnotationsManager annotationsManager = AnnotationsManager.getManager();
        Class annotationImplClass = annotationsManager.getAnnotationImplementationClass(this.javaAnnotationClass);
        if (annotationImplClass == null) {
            logger.warn("Cannot find implementation for annotation class: {}", (Object)this.javaAnnotationClass);
            return;
        }
        for (Constructor<?> candidateConstructor : constructors = annotationImplClass.getConstructors()) {
            Class<?>[] parameterTypes = candidateConstructor.getParameterTypes();
            if (parameterTypes.length != this.values.size()) continue;
            try {
                Object[] castValues = new Object[parameterTypes.length];
                for (int i = 0; i < parameterTypes.length; ++i) {
                    Object value;
                    Class<?> parameterType = parameterTypes[i];
                    String stringValue = this.values.get(i);
                    if (parameterType.isArray()) {
                        value = Util.matchStringArray((String)stringValue);
                    } else if (parameterType.isEnum()) {
                        ?[] enumValues = parameterType.getEnumConstants();
                        value = stringValue;
                        for (Object current : enumValues) {
                            Enum enumValue = (Enum)current;
                            if (!enumValue.name().equals(stringValue)) continue;
                            value = enumValue;
                            break;
                        }
                    } else {
                        value = stringValue;
                    }
                    castValues[i] = OgnlUtils.convertValue((Object)value, parameterType);
                }
                this.javaAnnotation = (java.lang.annotation.Annotation)ReflectionUtil.newInstance(candidateConstructor, (Object[])castValues);
            }
            catch (Throwable e) {
                logger.debug("Failed to use constructor: " + candidateConstructor, e);
            }
        }
        if (this.javaAnnotation == null) {
            logger.warn("Cannot instanciate annotation: {}", (Object)this.javaAnnotationClass);
        }
    }

    @Override
    public void link(Model model) {
    }

    @Override
    public void visitChildren(ModelObjectVisitor visitor) {
    }

    public Object getParent() {
        return this.parent;
    }

    public void setParent(Object parent) {
        this.parent = parent;
    }

    @XmlAttribute(required=true)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @XmlElement(name="value", type=String.class)
    public List<String> getValues() {
        return this.values;
    }

    public Class getJavaAnnotationClass() {
        return this.javaAnnotationClass;
    }

    public java.lang.annotation.Annotation getJavaAnnotation() {
        return this.javaAnnotation;
    }
}

