/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.logic;

import com.manydesigns.elements.ognl.OgnlUtils;
import com.manydesigns.elements.options.DefaultSelectionProvider;
import com.manydesigns.elements.options.OptionProvider;
import com.manydesigns.elements.reflection.JavaClassAccessor;
import com.manydesigns.elements.reflection.PropertyAccessor;
import com.manydesigns.elements.text.TextFormat;
import java.text.MessageFormat;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectionProviderLogic {
    public static final String copyright = "Copyright (C) 2005-2021 ManyDesigns srl";
    public static final Logger logger = LoggerFactory.getLogger(SelectionProviderLogic.class);

    @Deprecated
    public static DefaultSelectionProvider createSelectionProvider(String name, int fieldCount, Class[] fieldTypes, Collection<Object[]> objects) {
        return SelectionProviderLogic.createSelectionProvider(name, fieldTypes, objects);
    }

    public static DefaultSelectionProvider createSelectionProvider(String name, Class[] fieldTypes, Collection<Object[]> objects) {
        DefaultSelectionProvider selectionProvider = new DefaultSelectionProvider(name, fieldTypes.length);
        for (Object[] valueAndLabel : objects) {
            OptionProvider.Option option = SelectionProviderLogic.getOption(fieldTypes, valueAndLabel);
            selectionProvider.appendOption(option);
        }
        return selectionProvider;
    }

    @NotNull
    public static OptionProvider.Option getOption(Class[] fieldTypes, Object[] valueAndLabel) {
        int fieldCount = fieldTypes.length;
        Object[] values = new Object[fieldCount];
        String[] labels = new String[fieldCount];
        for (int j = 0; j < fieldCount; ++j) {
            Class valueType = fieldTypes[j];
            values[j] = OgnlUtils.convertValue((Object)valueAndLabel[j * 2], (Class)valueType);
            labels[j] = OgnlUtils.convertValueToString((Object)valueAndLabel[j * 2 + 1]);
        }
        boolean active = true;
        if (valueAndLabel.length > 2 * fieldCount) {
            Object booleanValue = OgnlUtils.convertValue((Object)valueAndLabel[fieldCount * 2], Boolean.class);
            active = booleanValue instanceof Boolean && (Boolean)booleanValue != false;
        }
        return new OptionProvider.Option(values, labels, active);
    }

    public static DefaultSelectionProvider createSelectionProvider(String name, Collection objects, PropertyAccessor[] propertyAccessors, @Nullable TextFormat[] textFormats) {
        DefaultSelectionProvider selectionProvider = new DefaultSelectionProvider(name, propertyAccessors.length);
        for (Object current : objects) {
            OptionProvider.Option option = SelectionProviderLogic.getOption(name, propertyAccessors, textFormats, current);
            selectionProvider.appendOption(option);
        }
        return selectionProvider;
    }

    @NotNull
    public static OptionProvider.Option getOption(String name, PropertyAccessor[] propertyAccessors, @Nullable TextFormat[] textFormats, Object object) {
        boolean active = true;
        if (object instanceof Object[]) {
            Object[] valueAndActive = (Object[])object;
            if (valueAndActive.length > 1) {
                boolean bl = active = valueAndActive[1] instanceof Boolean && (Boolean)valueAndActive[1] != false;
            }
            if (valueAndActive.length > 0) {
                object = valueAndActive[0];
            } else {
                throw new IllegalArgumentException("Invalid selection provider query result - sp: " + name);
            }
        }
        Object[] values = new Object[propertyAccessors.length];
        String[] labels = new String[propertyAccessors.length];
        int j = 0;
        for (PropertyAccessor property : propertyAccessors) {
            Object value;
            values[j] = value = property.get(object);
            if (textFormats == null || textFormats[j] == null) {
                String label;
                labels[j] = label = OgnlUtils.convertValueToString((Object)value);
            } else {
                TextFormat textFormat = textFormats[j];
                labels[j] = textFormat.format(object);
            }
            ++j;
        }
        return new OptionProvider.Option(values, labels, active);
    }

    public static DefaultSelectionProvider createSelectionProvider(String name, Collection objects, Class objectClass, @Nullable TextFormat[] textFormats, String[] propertyNames) {
        JavaClassAccessor classAccessor = JavaClassAccessor.getClassAccessor((Class)objectClass);
        PropertyAccessor[] propertyAccessors = new PropertyAccessor[propertyNames.length];
        for (int i = 0; i < propertyNames.length; ++i) {
            String currentName = propertyNames[i];
            try {
                PropertyAccessor propertyAccessor;
                propertyAccessors[i] = propertyAccessor = classAccessor.getProperty(currentName);
                continue;
            }
            catch (Throwable e) {
                String msg = MessageFormat.format("Could not access property: {0}", currentName);
                logger.warn(msg, e);
                throw new IllegalArgumentException(msg, e);
            }
        }
        return SelectionProviderLogic.createSelectionProvider(name, objects, propertyAccessors, textFormats);
    }
}

