/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.persistence.hibernate;

import com.manydesigns.elements.reflection.JavaClassAccessor;
import com.manydesigns.elements.reflection.PropertyAccessor;
import com.manydesigns.portofino.database.StringBooleanType;
import com.manydesigns.portofino.model.database.Column;
import com.manydesigns.portofino.model.database.ConnectionProvider;
import com.manydesigns.portofino.model.database.Database;
import com.manydesigns.portofino.model.database.ForeignKey;
import com.manydesigns.portofino.model.database.Generator;
import com.manydesigns.portofino.model.database.IncrementGenerator;
import com.manydesigns.portofino.model.database.JdbcConnectionProvider;
import com.manydesigns.portofino.model.database.JndiConnectionProvider;
import com.manydesigns.portofino.model.database.PrimaryKey;
import com.manydesigns.portofino.model.database.PrimaryKeyColumn;
import com.manydesigns.portofino.model.database.Reference;
import com.manydesigns.portofino.model.database.Schema;
import com.manydesigns.portofino.model.database.SequenceGenerator;
import com.manydesigns.portofino.model.database.TableGenerator;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import liquibase.database.structure.ForeignKeyConstraintType;
import org.apache.commons.configuration.Configuration;
import org.hibernate.FetchMode;
import org.hibernate.cfg.Mappings;
import org.hibernate.mapping.Bag;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.DependantValue;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.ManyToOne;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.Value;
import org.hibernate.type.BigDecimalType;
import org.hibernate.type.BigIntegerType;
import org.hibernate.type.BlobType;
import org.hibernate.type.BooleanType;
import org.hibernate.type.ByteType;
import org.hibernate.type.CharacterType;
import org.hibernate.type.DateType;
import org.hibernate.type.DoubleType;
import org.hibernate.type.FloatType;
import org.hibernate.type.IntegerType;
import org.hibernate.type.LongType;
import org.hibernate.type.NumericBooleanType;
import org.hibernate.type.ShortType;
import org.hibernate.type.StringType;
import org.hibernate.type.TimeType;
import org.hibernate.type.TimestampType;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HibernateConfig {
    protected final ConnectionProvider connectionProvider;
    protected final Configuration portofinoConfiguration;
    private static final boolean LAZY = true;
    public static final Logger logger = LoggerFactory.getLogger(HibernateConfig.class);
    private String trueString = "T";
    private String falseString = "F";

    public HibernateConfig(ConnectionProvider connectionProvider, Configuration portofinoConfiguration) {
        this.connectionProvider = connectionProvider;
        this.portofinoConfiguration = portofinoConfiguration;
    }

    public org.hibernate.cfg.Configuration buildSessionFactory(Database database) {
        try {
            org.hibernate.cfg.Configuration configuration = new org.hibernate.cfg.Configuration();
            this.setupConnection(configuration);
            this.setupConfigurationProperties(configuration);
            Mappings mappings = configuration.createMappings();
            this.classMapping(database, mappings);
            this.o2mMapping(database, configuration, mappings);
            this.m2oMapping(database, configuration, mappings);
            return configuration;
        }
        catch (Throwable ex) {
            System.err.println("Initial SessionFactory creation failed." + ex);
            ex.printStackTrace();
            throw new ExceptionInInitializerError(ex);
        }
    }

    protected void setupConfigurationProperties(org.hibernate.cfg.Configuration configuration) {
        configuration.setProperty("hibernate.current_session_context_class", "org.hibernate.context.ThreadLocalSessionContext").setProperty("org.hibernate.hql.ast.AST", "true").setProperty("hibernate.globally_quoted_identifiers", "false");
    }

    protected void setupConnection(org.hibernate.cfg.Configuration configuration) {
        if (!this.connectionProvider.getDatabasePlatform().isDialectAutodetected()) {
            configuration.setProperty("hibernate.dialect", this.connectionProvider.getDatabasePlatform().getHibernateDialect().getClass().getName());
        }
        if (this.connectionProvider instanceof JdbcConnectionProvider) {
            JdbcConnectionProvider jdbcConnectionProvider = (JdbcConnectionProvider)this.connectionProvider;
            configuration.setProperty("hibernate.connection.url", jdbcConnectionProvider.getActualUrl());
            configuration.setProperty("hibernate.connection.driver_class", jdbcConnectionProvider.getDriver());
            if (jdbcConnectionProvider.getUsername() != null) {
                configuration.setProperty("hibernate.connection.username", jdbcConnectionProvider.getUsername());
            }
            if (jdbcConnectionProvider.getPassword() != null) {
                configuration.setProperty("hibernate.connection.password", jdbcConnectionProvider.getPassword());
            }
        } else if (this.connectionProvider instanceof JndiConnectionProvider) {
            JndiConnectionProvider jndiConnectionProvider = (JndiConnectionProvider)this.connectionProvider;
            configuration.setProperty("hibernate.connection.datasource", jndiConnectionProvider.getJndiResource());
        } else {
            throw new Error("Unsupported connection provider: " + this.connectionProvider);
        }
    }

    private Mappings classMapping(Database database, Mappings mappings) {
        for (Schema schema : database.getSchemas()) {
            for (com.manydesigns.portofino.model.database.Table aTable : schema.getTables()) {
                logger.debug("Class - {}", (Object)aTable.getQualifiedName());
                PrimaryKey primaryKey = aTable.getPrimaryKey();
                if (primaryKey == null) {
                    logger.debug("Skipping table without primary key: {}", (Object)aTable.getQualifiedName());
                    continue;
                }
                if (!primaryKey.isValid()) {
                    logger.debug("Skipping table with invalid primary key: {}", (Object)aTable.getQualifiedName());
                    continue;
                }
                RootClass clazz = this.createTableMapping(mappings, aTable);
                if (clazz == null) continue;
                mappings.addClass((PersistentClass)clazz);
                mappings.addImport(clazz.getEntityName(), clazz.getEntityName());
            }
        }
        return mappings;
    }

    private void m2oMapping(Database database, org.hibernate.cfg.Configuration configuration, Mappings mappings) {
        for (Schema schema : database.getSchemas()) {
            for (com.manydesigns.portofino.model.database.Table aTable : schema.getTables()) {
                for (ForeignKey rel : aTable.getForeignKeys()) {
                    logger.debug(MessageFormat.format("Many to one - {0} {1}", aTable.getQualifiedName(), rel.getName()));
                    this.createM2O(configuration, mappings, rel);
                }
            }
        }
    }

    private void o2mMapping(Database database, org.hibernate.cfg.Configuration configuration, Mappings mappings) {
        for (Schema schema : database.getSchemas()) {
            for (com.manydesigns.portofino.model.database.Table aTable : schema.getTables()) {
                for (ForeignKey rel : aTable.getOneToManyRelationships()) {
                    logger.debug(MessageFormat.format("One to many - {0} {1}", aTable.getQualifiedName(), rel.getName()));
                    this.createO2M(configuration, mappings, rel);
                }
            }
        }
    }

    protected RootClass createTableMapping(Mappings mappings, com.manydesigns.portofino.model.database.Table aTable) {
        Table tab = mappings.addTable(this.escapeName(aTable.getSchemaName()), null, this.escapeName(aTable.getTableName()), null, false);
        mappings.addTableBinding(aTable.getSchemaName(), null, aTable.getTableName(), aTable.getTableName(), null);
        RootClass clazz = new RootClass();
        clazz.setEntityName(aTable.getActualEntityName());
        clazz.setJpaEntityName(aTable.getActualEntityName());
        if (aTable.getJavaClass() != null) {
            clazz.setClassName(aTable.getJavaClass());
            clazz.setProxyInterfaceName(aTable.getJavaClass());
        }
        clazz.setLazy(true);
        clazz.setTable(tab);
        ArrayList<Column> columnList = new ArrayList<Column>();
        for (Column modelColumn : aTable.getColumns()) {
            int jdbcType = modelColumn.getJdbcType();
            Class javaType = modelColumn.getActualJavaType();
            boolean hibernateTypeOk = this.setHibernateType(null, modelColumn, javaType, jdbcType);
            if (hibernateTypeOk) {
                columnList.add(modelColumn);
                continue;
            }
            logger.error("Cannot find Hibernate type for table: {}, column: {}, jdbc type: {}, type name: {}. Skipping column.", new Object[]{aTable.getQualifiedName(), modelColumn.getColumnName(), jdbcType, javaType != null ? javaType.getName() : null});
        }
        List<Column> columnPKList = aTable.getPrimaryKey().getColumns();
        if (!columnList.containsAll(columnPKList)) {
            logger.error("Primary key refers to some invalid columns, skipping table {}", (Object)aTable.getQualifiedName());
            return null;
        }
        if (columnPKList.size() > 1) {
            this.createPKComposite(mappings, aTable, aTable.getPrimaryKey().getPrimaryKeyName(), clazz, tab, columnPKList);
        } else {
            this.createPKSingle(mappings, aTable, aTable.getPrimaryKey().getPrimaryKeyName(), clazz, tab, columnPKList);
        }
        columnList.removeAll(columnPKList);
        for (Column column : columnList) {
            org.hibernate.mapping.Column col = this.createColumn(mappings, tab, column);
            if (col == null) continue;
            clazz.addProperty(this.createProperty(column, col.getValue()));
        }
        return clazz;
    }

    protected org.hibernate.mapping.Column createColumn(Mappings mappings, Table tab, Column column) {
        org.hibernate.mapping.Column col = new org.hibernate.mapping.Column();
        col.setName(this.escapeName(column.getColumnName()));
        col.setLength(column.getLength().intValue());
        col.setPrecision(column.getLength().intValue());
        col.setScale(column.getScale().intValue());
        col.setNullable(column.isNullable());
        String columnType = column.getColumnType();
        int jdbcType = column.getJdbcType();
        col.setSqlTypeCode(Integer.valueOf(jdbcType));
        col.setSqlType(columnType);
        SimpleValue value = new SimpleValue(mappings, tab);
        if (!this.setHibernateType(value, column, column.getActualJavaType(), jdbcType)) {
            logger.error("Skipping column {}", (Object)column.getQualifiedName());
            return null;
        }
        value.addColumn(col);
        tab.addColumn(col);
        mappings.addColumnBinding(column.getColumnName(), col, tab);
        return col;
    }

    protected Property createProperty(Column column, Value value) {
        Property prop = new Property();
        prop.setName(column.getActualPropertyName());
        prop.setValue(value);
        return prop;
    }

    protected void createPKComposite(Mappings mappings, com.manydesigns.portofino.model.database.Table mdTable, String pkName, RootClass clazz, Table tab, List<Column> columnPKList) {
        org.hibernate.mapping.PrimaryKey primaryKey = new org.hibernate.mapping.PrimaryKey();
        primaryKey.setName(pkName);
        primaryKey.setTable(tab);
        clazz.setEmbeddedIdentifier(true);
        Component component = new Component(mappings, (PersistentClass)clazz);
        component.setDynamic(mdTable.getActualJavaClass() == null);
        String name = mdTable.getQualifiedName();
        component.setRoleName(name + ".id");
        component.setEmbedded(true);
        component.setKey(true);
        component.setNullValue("undefined");
        if (!component.isDynamic()) {
            component.setComponentClassName(mdTable.getJavaClass());
        }
        boolean hasErrors = false;
        for (Column column : columnPKList) {
            if (column == null) {
                throw new InternalError("Null column");
            }
            org.hibernate.mapping.Column col = this.createColumn(mappings, tab, column);
            boolean bl = hasErrors = col == null || hasErrors;
            if (col == null) continue;
            primaryKey.addColumn(col);
            Property prop = this.createProperty(column, col.getValue());
            prop.setCascade("none");
            prop.setPersistentClass((PersistentClass)clazz);
            component.addProperty(prop);
        }
        if (hasErrors) {
            logger.error("Skipping primary key");
            return;
        }
        tab.setIdentifierValue((KeyValue)component);
        clazz.setIdentifier((KeyValue)component);
        clazz.setDiscriminatorValue(name);
        tab.setPrimaryKey(primaryKey);
    }

    protected void createPKSingle(Mappings mappings, com.manydesigns.portofino.model.database.Table mdTable, String pkName, RootClass clazz, Table tab, List<Column> columnPKList) {
        PrimaryKeyColumn pkcol = mdTable.getPrimaryKey().getPrimaryKeyColumns().get(0);
        Column column = columnPKList.get(0);
        org.hibernate.mapping.PrimaryKey primaryKey = new org.hibernate.mapping.PrimaryKey();
        primaryKey.setName(pkName);
        primaryKey.setTable(tab);
        tab.setPrimaryKey(primaryKey);
        org.hibernate.mapping.Column col = this.createColumn(mappings, tab, column);
        if (col == null) {
            logger.error("Skipping primary key");
            return;
        }
        SimpleValue id = (SimpleValue)col.getValue();
        id.setIdentifierGeneratorStrategy("assigned");
        id.setNullValue("undefined");
        tab.getPrimaryKey().addColumn(col);
        Property prop = this.createProperty(column, (Value)id);
        clazz.addProperty(prop);
        prop.setPropertyAccessorName(mappings.getDefaultAccess());
        prop.setInsertable(false);
        prop.setUpdateable(false);
        Generator generator = pkcol.getGenerator();
        this.setPKColumnGenerator(mappings, clazz, tab, column, id, generator);
        tab.setIdentifierValue((KeyValue)id);
        clazz.setIdentifier((KeyValue)id);
        clazz.setIdentifierProperty(prop);
        clazz.setDiscriminatorValue(mdTable.getQualifiedName());
    }

    protected void setPKColumnGenerator(Mappings mappings, RootClass clazz, Table tab, Column column, SimpleValue id, Generator generator) {
        if (column.isAutoincrement()) {
            this.manageIdentityGenerator(mappings, tab, id);
        } else if (generator != null) {
            if (generator instanceof SequenceGenerator) {
                this.manageSequenceGenerator(mappings, tab, id, (SequenceGenerator)generator);
            } else if (generator instanceof TableGenerator) {
                this.manageTableGenerator(mappings, tab, id, (TableGenerator)generator);
            } else if (generator instanceof IncrementGenerator) {
                this.manageIncrementGenerator(mappings, tab, id, clazz.getEntityName());
            }
        }
    }

    private void manageIdentityGenerator(Mappings mappings, Table tab, SimpleValue id) {
        id.setIdentifierGeneratorStrategy("identity");
        Properties params = new Properties();
        params.put("identifier_normalizer", mappings.getObjectNameNormalizer());
        params.setProperty("schema", this.escapeName(tab.getSchema()));
        id.setIdentifierGeneratorProperties(params);
        id.setNullValue(null);
    }

    private void manageSequenceGenerator(Mappings mappings, Table tab, SimpleValue id, SequenceGenerator generator) {
        id.setIdentifierGeneratorStrategy("enhanced-sequence");
        Properties params = new Properties();
        params.put("identifier_normalizer", mappings.getObjectNameNormalizer());
        params.put("sequence_name", this.escapeName(generator.getName()));
        params.setProperty("schema", this.escapeName(tab.getSchema()));
        id.setIdentifierGeneratorProperties(params);
        id.setNullValue(null);
    }

    private void manageTableGenerator(Mappings mappings, Table tab, SimpleValue id, TableGenerator generator) {
        id.setIdentifierGeneratorStrategy("enhanced-table");
        Properties params = new Properties();
        params.put("target_table", tab);
        params.put("table_name", this.escapeName(generator.getTable()));
        params.put("identifier_normalizer", mappings.getObjectNameNormalizer());
        params.put("segment_column_name", this.escapeName(generator.getKeyColumn()));
        params.put("segment_value", generator.getKeyValue());
        params.put("value_column_name", this.escapeName(generator.getValueColumn()));
        params.setProperty("schema", this.escapeName(tab.getSchema()));
        id.setIdentifierGeneratorProperties(params);
        id.setNullValue(null);
    }

    private void manageIncrementGenerator(Mappings mappings, Table tab, SimpleValue id, String entityName) {
        id.setIdentifierGeneratorStrategy("increment");
        Properties params = new Properties();
        params.put("identifier_normalizer", mappings.getObjectNameNormalizer());
        params.setProperty("schema", this.escapeName(tab.getSchema()));
        params.put("entity_name", entityName);
        id.setIdentifierGeneratorProperties(params);
        id.setNullValue(null);
    }

    protected void createO2M(org.hibernate.cfg.Configuration config, Mappings mappings, ForeignKey relationship) {
        com.manydesigns.portofino.model.database.Table manyMDTable = relationship.getFromTable();
        com.manydesigns.portofino.model.database.Table oneMDTable = relationship.getToTable();
        if (oneMDTable.getJavaClass() != null) {
            try {
                Class oneClass = oneMDTable.getActualJavaClass();
                JavaClassAccessor accessor = JavaClassAccessor.getClassAccessor((Class)oneClass);
                PropertyAccessor[] propertyAccessors = accessor.getProperties();
                boolean found = false;
                for (PropertyAccessor propertyAccessor : propertyAccessors) {
                    if (!propertyAccessor.getName().equals(relationship.getActualManyPropertyName())) continue;
                    found = true;
                }
                if (!found) {
                    logger.warn("Property '{}' not found, skipping relationship {}", (Object)relationship.getActualManyPropertyName(), (Object)relationship.getQualifiedName());
                    return;
                }
            }
            catch (Exception e) {
                logger.warn("Property not found, skipping relationship ", (Throwable)e);
                return;
            }
        }
        if (!manyMDTable.getDatabaseName().equalsIgnoreCase(oneMDTable.getDatabaseName())) {
            logger.warn("Relationship crosses databases, skipping: {}", (Object)relationship.getQualifiedName());
            return;
        }
        String manyMDQualifiedTableName = manyMDTable.getActualEntityName();
        String oneMDQualifiedTableName = oneMDTable.getActualEntityName();
        PersistentClass clazzOne = config.getClassMapping(oneMDQualifiedTableName);
        if (clazzOne == null) {
            logger.error("Cannot find table '{}' as 'one' side of foreign key '{}'. Skipping relationship.", (Object)oneMDQualifiedTableName, (Object)relationship.getName());
            return;
        }
        PersistentClass clazzMany = config.getClassMapping(manyMDQualifiedTableName);
        if (clazzMany == null) {
            logger.error("Cannot find table '{}' as 'many' side of foreign key '{}'. Skipping relationship.", (Object)manyMDQualifiedTableName, (Object)relationship.getName());
            return;
        }
        Bag set = new Bag(mappings, clazzOne);
        set.setLazy(true);
        set.setRole(relationship.getToTable().getActualEntityName() + "." + relationship.getActualManyPropertyName());
        set.setCollectionTable(clazzMany.getTable());
        OneToMany oneToMany = new OneToMany(mappings, set.getOwner());
        set.setElement((Value)oneToMany);
        oneToMany.setReferencedEntityName(manyMDQualifiedTableName);
        oneToMany.setAssociatedClass(clazzMany);
        oneToMany.setEmbedded(true);
        set.setSorted(false);
        set.setFetchMode(FetchMode.DEFAULT);
        Table tableMany = clazzMany.getTable();
        Table tableOne = clazzOne.getTable();
        ArrayList<org.hibernate.mapping.Column> oneColumns = new ArrayList<org.hibernate.mapping.Column>();
        ArrayList<org.hibernate.mapping.Column> manyColumns = new ArrayList<org.hibernate.mapping.Column>();
        List<Reference> refs = relationship.getReferences();
        DependantValue dv = refs.size() > 1 ? this.createFKComposite(mappings, relationship, manyMDTable, clazzOne, clazzMany, set, tableMany, tableOne, oneColumns, manyColumns) : this.createFKSingle(mappings, clazzOne, clazzMany, tableOne, oneColumns, manyColumns, refs);
        tableMany.createForeignKey(relationship.getName(), manyColumns, oneMDQualifiedTableName, oneColumns);
        dv.setNullable(false);
        set.setKey((KeyValue)dv);
        mappings.addCollection((Collection)set);
        Property prop = new Property();
        prop.setName(relationship.getActualManyPropertyName());
        prop.setValue((Value)set);
        if (ForeignKeyConstraintType.importedKeyCascade.name().equalsIgnoreCase(relationship.getOnDelete())) {
            prop.setCascade("delete");
        } else {
            prop.setCascade("none");
        }
        clazzOne.addProperty(prop);
    }

    private DependantValue createFKComposite(Mappings mappings, ForeignKey relationship, com.manydesigns.portofino.model.database.Table manyMDTable, PersistentClass clazzOne, PersistentClass clazzMany, Bag set, Table tableMany, Table tableOne, List<org.hibernate.mapping.Column> oneColumns, List<org.hibernate.mapping.Column> manyColumns) {
        Component component = new Component(mappings, (Collection)set);
        component.setDynamic(manyMDTable.getActualJavaClass() == null);
        component.setEmbedded(true);
        DependantValue dv = new DependantValue(mappings, clazzMany.getTable(), (KeyValue)component);
        dv.setNullable(true);
        dv.setUpdateable(true);
        for (Reference ref : relationship.getReferences()) {
            String colToName = ref.getToColumn();
            String colToPropertyName = ref.getActualToColumn().getActualPropertyName();
            String colFromName = ref.getFromColumn();
            Iterator it = tableMany.getColumnIterator();
            while (it.hasNext()) {
                org.hibernate.mapping.Column col = (org.hibernate.mapping.Column)it.next();
                if (!col.getName().equals(colFromName)) continue;
                dv.addColumn(col);
                manyColumns.add(col);
                break;
            }
            Iterator it2 = tableOne.getColumnIterator();
            while (it2.hasNext()) {
                org.hibernate.mapping.Column col = (org.hibernate.mapping.Column)it2.next();
                if (!col.getName().equals(colToName)) continue;
                oneColumns.add(col);
                break;
            }
            Property refProp = this.getRefProperty(clazzOne, colToPropertyName);
            component.addProperty(refProp);
        }
        return dv;
    }

    private DependantValue createFKSingle(Mappings mappings, PersistentClass clazzOne, PersistentClass clazzMany, Table tableOne, List<org.hibernate.mapping.Column> oneColumns, List<org.hibernate.mapping.Column> manyColumns, List<Reference> refs) {
        Reference reference = refs.get(0);
        String colFromName = reference.getFromColumn();
        String colToName = reference.getToColumn();
        String colToPropertyName = reference.getActualToColumn().getActualPropertyName();
        Property refProp = this.getRefProperty(clazzOne, colToPropertyName);
        DependantValue dv = new DependantValue(mappings, clazzMany.getTable(), refProp.getPersistentClass().getKey());
        dv.setNullable(true);
        dv.setUpdateable(true);
        Iterator it = clazzMany.getTable().getColumnIterator();
        while (it.hasNext()) {
            org.hibernate.mapping.Column col = (org.hibernate.mapping.Column)it.next();
            if (!col.getName().equals(colFromName)) continue;
            dv.addColumn(col);
            manyColumns.add(col);
            break;
        }
        Iterator it2 = tableOne.getColumnIterator();
        while (it2.hasNext()) {
            org.hibernate.mapping.Column col = (org.hibernate.mapping.Column)it2.next();
            if (!col.getName().equals(colToName)) continue;
            oneColumns.add(col);
            break;
        }
        return dv;
    }

    protected void createM2O(org.hibernate.cfg.Configuration config, Mappings mappings, ForeignKey relationship) {
        com.manydesigns.portofino.model.database.Table manyMDTable = relationship.getFromTable();
        com.manydesigns.portofino.model.database.Table oneMDTable = relationship.getToTable();
        String manyMDQualifiedTableName = manyMDTable.getActualEntityName();
        String oneMDQualifiedTableName = oneMDTable.getActualEntityName();
        RootClass clazz = (RootClass)mappings.getClass(manyMDQualifiedTableName);
        if (clazz == null) {
            logger.error("Cannot find table '{}' as 'many' side of foreign key '{}'. Skipping relationship.", (Object)manyMDQualifiedTableName, (Object)relationship.getName());
            return;
        }
        Table tab = clazz.getTable();
        ArrayList<String> columnNames = new ArrayList<String>();
        for (Reference ref : relationship.getReferences()) {
            if (ref.getActualFromColumn() == null) {
                logger.error("Missing from column {}, skipping relationship", (Object)ref.getFromColumn());
                return;
            }
            columnNames.add(ref.getFromColumn());
        }
        ManyToOne m2o = new ManyToOne(mappings, tab);
        m2o.setLazy(true);
        HashMap<String, PersistentClass> persistentClasses = new HashMap<String, PersistentClass>();
        persistentClasses.put(oneMDQualifiedTableName, config.getClassMapping(oneMDQualifiedTableName));
        m2o.setReferencedEntityName(oneMDQualifiedTableName);
        m2o.createPropertyRefConstraints(persistentClasses);
        PersistentClass manyClass = config.getClassMapping(manyMDQualifiedTableName);
        for (String columnName : columnNames) {
            org.hibernate.mapping.Column col = new org.hibernate.mapping.Column();
            col.setName(this.escapeName(columnName));
            col = manyClass.getTable().getColumn(col);
            if (col == null) {
                logger.error("Column not found in 'many' entity {}: {}, skipping relationship", (Object)manyClass.getEntityName(), (Object)columnName);
                return;
            }
            m2o.addColumn(col);
        }
        Property prop = new Property();
        prop.setName(relationship.getActualOnePropertyName());
        prop.setValue((Value)m2o);
        prop.setCascade("none");
        prop.setInsertable(false);
        prop.setUpdateable(false);
        clazz.addProperty(prop);
    }

    private Property getRefProperty(PersistentClass clazzOne, String propertyName) {
        Property refProp = null != clazzOne.getIdentifierProperty() ? clazzOne.getIdentifierProperty() : (null != clazzOne.getIdentifier() ? ((Component)clazzOne.getIdentifier()).getProperty(propertyName) : clazzOne.getProperty(propertyName));
        return refProp;
    }

    private String escapeName(String name) {
        return "`" + name + "`";
    }

    public boolean setHibernateType(@Nullable SimpleValue value, Column column, Class javaType, int jdbcType) {
        String typeName;
        Properties typeParams = null;
        if (javaType == null) {
            return false;
        }
        if (javaType == Long.class) {
            typeName = LongType.INSTANCE.getName();
        } else if (javaType == Short.class) {
            typeName = ShortType.INSTANCE.getName();
        } else if (javaType == Integer.class) {
            typeName = IntegerType.INSTANCE.getName();
        } else if (javaType == Byte.class) {
            typeName = ByteType.INSTANCE.getName();
        } else if (javaType == Float.class) {
            typeName = FloatType.INSTANCE.getName();
        } else if (javaType == Double.class) {
            typeName = DoubleType.INSTANCE.getName();
        } else if (javaType == Character.class) {
            typeName = CharacterType.INSTANCE.getName();
        } else if (javaType == String.class) {
            typeName = StringType.INSTANCE.getName();
        } else if (Date.class.isAssignableFrom(javaType)) {
            switch (jdbcType) {
                case 91: {
                    typeName = DateType.INSTANCE.getName();
                    break;
                }
                case 92: {
                    typeName = TimeType.INSTANCE.getName();
                    break;
                }
                case 93: {
                    typeName = TimestampType.INSTANCE.getName();
                    break;
                }
                default: {
                    typeName = null;
                    break;
                }
            }
        } else if (javaType == Boolean.class) {
            if (jdbcType == -7 || jdbcType == 16) {
                typeName = BooleanType.INSTANCE.getName();
            } else if (jdbcType == 2 || jdbcType == 3 || jdbcType == 4 || jdbcType == 5 || jdbcType == -6 || jdbcType == -5) {
                typeName = NumericBooleanType.INSTANCE.getName();
            } else if (jdbcType == 1 || jdbcType == 12) {
                typeName = StringBooleanType.class.getName();
                typeParams = new Properties();
                typeParams.setProperty("true", this.trueString != null ? this.trueString : StringBooleanType.NULL);
                typeParams.setProperty("false", this.falseString != null ? this.falseString : StringBooleanType.NULL);
                typeParams.setProperty("sqlType", String.valueOf(jdbcType));
            } else {
                typeName = null;
            }
        } else {
            typeName = javaType == BigDecimal.class ? BigDecimalType.INSTANCE.getName() : (javaType == BigInteger.class ? BigIntegerType.INSTANCE.getName() : (javaType == byte[].class ? BlobType.INSTANCE.getName() : null));
        }
        if (typeName == null) {
            logger.error("Unsupported type (java type: {}, jdbc type: {}) for column '{}'.", new Object[]{javaType, jdbcType, column.getColumnName()});
            return false;
        }
        if (value != null) {
            value.setTypeName(typeName);
            if (typeParams != null) {
                value.setTypeParameters(typeParams);
            }
        }
        return true;
    }

    public String getTrueString() {
        return this.trueString;
    }

    public void setTrueString(String trueString) {
        this.trueString = trueString;
    }

    public String getFalseString() {
        return this.falseString;
    }

    public void setFalseString(String falseString) {
        this.falseString = falseString;
    }
}

