/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.model.database;

import com.manydesigns.elements.annotations.Required;
import com.manydesigns.portofino.model.Model;
import com.manydesigns.portofino.model.ModelObject;
import com.manydesigns.portofino.model.ModelObjectVisitor;
import com.manydesigns.portofino.model.database.Column;
import com.manydesigns.portofino.model.database.PrimaryKeyColumn;
import com.manydesigns.portofino.model.database.Table;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlAccessorType(value=XmlAccessType.NONE)
public class PrimaryKey
implements ModelObject {
    public static final String copyright = "Copyright (c) 2005-2014, ManyDesigns srl";
    protected final List<PrimaryKeyColumn> primaryKeyColumns;
    protected Table table;
    protected String primaryKeyName;
    protected final List<Column> columns = new ArrayList<Column>();
    protected boolean valid;
    public static final Logger logger = LoggerFactory.getLogger(Table.class);

    public PrimaryKey() {
        this.primaryKeyColumns = new ArrayList<PrimaryKeyColumn>();
    }

    public PrimaryKey(Table table) {
        this();
        this.table = table;
    }

    public String getQualifiedName() {
        return MessageFormat.format("{0}#{1}", this.table.getQualifiedName(), this.primaryKeyName);
    }

    @Override
    public void afterUnmarshal(Unmarshaller u, Object parent) {
        this.table = (Table)parent;
    }

    @Override
    public void reset() {
        this.columns.clear();
        this.valid = true;
    }

    @Override
    public void init(Model model) {
        assert (this.table != null);
        if (this.primaryKeyColumns.isEmpty()) {
            throw new Error(MessageFormat.format("Primary key {0} has no columns", this.getQualifiedName()));
        }
    }

    @Override
    public void link(Model model) {
        for (PrimaryKeyColumn pkc : this.primaryKeyColumns) {
            Column column = pkc.getActualColumn();
            if (column == null) {
                this.valid = false;
                logger.error("Invalid primary key column: {}-{}", (Object)this.getQualifiedName(), (Object)pkc.getColumnName());
                continue;
            }
            this.columns.add(column);
        }
        if (this.columns.isEmpty()) {
            logger.warn("Primary key '{}' has no columns", (Object)this);
        }
    }

    @Override
    public void visitChildren(ModelObjectVisitor visitor) {
        for (PrimaryKeyColumn pkc : this.primaryKeyColumns) {
            visitor.visit(pkc);
        }
    }

    public PrimaryKeyColumn findPrimaryKeyColumnByNameIgnoreCase(String columnName) {
        for (PrimaryKeyColumn primaryKeyColumn : this.primaryKeyColumns) {
            if (!primaryKeyColumn.getColumnName().equalsIgnoreCase(columnName)) continue;
            return primaryKeyColumn;
        }
        return null;
    }

    public PrimaryKeyColumn findPrimaryKeyColumnByName(String columnName) {
        for (PrimaryKeyColumn primaryKeyColumn : this.primaryKeyColumns) {
            if (!primaryKeyColumn.getColumnName().equals(columnName)) continue;
            return primaryKeyColumn;
        }
        return null;
    }

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public String getDatabaseName() {
        return this.table.getTableName();
    }

    public String getSchemaName() {
        return this.table.getSchemaName();
    }

    public String getTableName() {
        return this.table.getTableName();
    }

    @Required
    @XmlAttribute(required=true)
    public String getPrimaryKeyName() {
        return this.primaryKeyName;
    }

    public void setPrimaryKeyName(String primaryKeyName) {
        this.primaryKeyName = primaryKeyName;
    }

    @XmlElement(name="column", type=PrimaryKeyColumn.class)
    public List<PrimaryKeyColumn> getPrimaryKeyColumns() {
        return this.primaryKeyColumns;
    }

    public boolean isValid() {
        return this.valid;
    }

    public String toString() {
        return MessageFormat.format("primary key {0}", this.getQualifiedName());
    }
}

