/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.model.database;

import com.manydesigns.elements.text.OgnlTextFormat;
import com.manydesigns.portofino.database.platforms.DatabasePlatformsRegistry;
import com.manydesigns.portofino.model.database.ConnectionProvider;
import java.sql.Connection;
import java.sql.DriverManager;
import java.text.MessageFormat;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.lang.builder.ToStringBuilder;

@XmlAccessorType(value=XmlAccessType.NONE)
public class JdbcConnectionProvider
extends ConnectionProvider {
    public static final String copyright = "Copyright (c) 2005-2014, ManyDesigns srl";
    protected String driver;
    protected String url;
    protected String username;
    protected String password;
    protected String actualUrl;

    @Override
    public void reset() {
        this.actualUrl = null;
        super.reset();
    }

    @Override
    public void init(DatabasePlatformsRegistry databasePlatformsRegistry) {
        this.actualUrl = OgnlTextFormat.format((String)this.url, null);
        super.init(databasePlatformsRegistry);
    }

    @Override
    public String getDescription() {
        return MessageFormat.format("JDBC connection to URL: {0}", this.url);
    }

    @Override
    public Connection acquireConnection() throws Exception {
        Class.forName(this.driver);
        return DriverManager.getConnection(this.actualUrl, this.username, this.password);
    }

    @Override
    public void releaseConnection(Connection conn) {
        DbUtils.closeQuietly((Connection)conn);
    }

    @XmlAttribute(required=true)
    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    @XmlAttribute(required=true)
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @XmlAttribute(required=false)
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @XmlAttribute(required=false)
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getActualUrl() {
        return this.actualUrl;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("driver", (Object)this.driver).append("url", (Object)this.url).append("username", (Object)this.username).append("password", (Object)this.password).toString();
    }
}

