/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.persistence;

import com.manydesigns.elements.util.ElementsFileUtils;
import com.manydesigns.portofino.cache.CacheResetEvent;
import com.manydesigns.portofino.cache.CacheResetListenerRegistry;
import com.manydesigns.portofino.database.platforms.DatabasePlatformsRegistry;
import com.manydesigns.portofino.di.Inject;
import com.manydesigns.portofino.model.Model;
import com.manydesigns.portofino.model.database.ConnectionProvider;
import com.manydesigns.portofino.model.database.DatabaseLogic;
import com.manydesigns.portofino.model.database.Schema;
import com.manydesigns.portofino.model.database.Table;
import com.manydesigns.portofino.persistence.hibernate.HibernateConfig;
import com.manydesigns.portofino.persistence.hibernate.HibernateDatabaseSetup;
import com.manydesigns.portofino.reflection.TableAccessor;
import com.manydesigns.portofino.sync.DatabaseSyncer;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import liquibase.Contexts;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.resource.FileSystemResourceAccessor;
import liquibase.resource.ResourceAccessor;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.service.ServiceRegistry;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Persistence {
    public static final String copyright = "Copyright (c) 2005-2015, ManyDesigns srl";
    public static final String APP_DBS_DIR = "dbs";
    public static final String APP_MODEL_FILE = "portofino-model.xml";
    public static final String changelogFileNameTemplate = "{0}-changelog.xml";
    protected final DatabasePlatformsRegistry databasePlatformsRegistry;
    protected Model model;
    protected final Map<String, HibernateDatabaseSetup> setups;
    protected final File appDir;
    protected final File appDbsDir;
    protected final File appModelFile;
    protected final Configuration configuration;
    @Inject(value="com.manydesigns.portofino.cache.CacheResetListenerRegistry")
    public CacheResetListenerRegistry cacheResetListenerRegistry;
    public static final Logger logger = LoggerFactory.getLogger(Persistence.class);
    protected Date lastLiquibaseRunTime = new Date(0L);

    public Persistence(File appDir, Configuration configuration, DatabasePlatformsRegistry databasePlatformsRegistry) {
        this.appDir = appDir;
        this.configuration = configuration;
        this.databasePlatformsRegistry = databasePlatformsRegistry;
        this.appDbsDir = new File(appDir, APP_DBS_DIR);
        logger.info("Application dbs dir: {}", (Object)this.appDbsDir.getAbsolutePath());
        boolean result = ElementsFileUtils.ensureDirectoryExistsAndWarnIfNotWritable((File)this.appDbsDir);
        this.appModelFile = new File(appDir, APP_MODEL_FILE);
        logger.info("Application model file: {}", (Object)this.appModelFile.getAbsolutePath());
        if (!result) {
            throw new Error("Could not initialize application");
        }
        this.setups = new HashMap<String, HibernateDatabaseSetup>();
    }

    public synchronized void loadXmlModel() {
        logger.info("Loading xml model from file: {}", (Object)this.appModelFile.getAbsolutePath());
        try {
            JAXBContext jc = JAXBContext.newInstance((String)"com.manydesigns.portofino.model");
            Unmarshaller um = jc.createUnmarshaller();
            this.model = (Model)um.unmarshal(this.appModelFile);
            boolean syncOnStart = false;
            this.initModel();
            if (this.configuration.getBoolean("liquibase.enabled", true)) {
                this.runLiquibaseScripts();
            }
            if (syncOnStart) {
                ArrayList<String> databaseNames = new ArrayList<String>();
                for (com.manydesigns.portofino.model.database.Database sourceDatabase : this.model.getDatabases()) {
                    String databaseName = sourceDatabase.getDatabaseName();
                    databaseNames.add(databaseName);
                }
                for (String databaseName : databaseNames) {
                    this.syncDataModel(databaseName);
                }
                this.initModel();
            }
        }
        catch (Exception e) {
            String msg = "Cannot load/parse model: " + this.appModelFile;
            logger.error(msg, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runLiquibaseScripts() {
        logger.info("Updating database definitions");
        FileSystemResourceAccessor resourceAccessor = new FileSystemResourceAccessor(this.appDir.getAbsolutePath());
        for (com.manydesigns.portofino.model.database.Database database : this.model.getDatabases()) {
            ConnectionProvider connectionProvider = database.getConnectionProvider();
            String databaseName = database.getDatabaseName();
            for (Schema schema : database.getSchemas()) {
                String schemaName = schema.getSchemaName();
                String changelogFileName = MessageFormat.format(changelogFileNameTemplate, databaseName + "-" + schemaName);
                File changelogFile = new File(this.appDbsDir, changelogFileName);
                if (!changelogFile.isFile()) {
                    logger.info("Changelog file does not exist or is not a normal file, skipping: {}", (Object)changelogFile);
                    continue;
                }
                if (changelogFile.lastModified() <= this.lastLiquibaseRunTime.getTime()) {
                    logger.info("Changelog file not modified since last reload, skipping: {}", (Object)changelogFile);
                    continue;
                }
                logger.info("Running changelog file: {}", (Object)changelogFile);
                Connection connection = null;
                try {
                    connection = connectionProvider.acquireConnection();
                    JdbcConnection jdbcConnection = new JdbcConnection(connection);
                    Database lqDatabase = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)jdbcConnection);
                    lqDatabase.setDefaultSchemaName(schemaName);
                    String relativeChangelogPath = ElementsFileUtils.getRelativePath((File)this.appDir, (File)changelogFile, (String)System.getProperty("file.separator"));
                    if (new File(relativeChangelogPath).isAbsolute()) {
                        logger.warn("The application dbs dir {} is not inside the apps dir {}; using an absolute path for Liquibase update", (Object)this.appDbsDir, (Object)this.appDir);
                    }
                    Liquibase lq = new Liquibase(relativeChangelogPath, (ResourceAccessor)resourceAccessor, lqDatabase);
                    lq.update((Contexts)null);
                }
                catch (Exception e) {
                    String msg = "Couldn't update database: " + schemaName;
                    logger.error(msg, (Throwable)e);
                }
                finally {
                    connectionProvider.releaseConnection(connection);
                }
            }
        }
        this.lastLiquibaseRunTime = new Date();
    }

    public synchronized void saveXmlModel() throws IOException, JAXBException {
        File tempFile = File.createTempFile(this.appModelFile.getName(), "");
        JAXBContext jc = JAXBContext.newInstance((String)"com.manydesigns.portofino.model");
        Marshaller m = jc.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        m.marshal((Object)this.model, tempFile);
        ElementsFileUtils.moveFileSafely((File)tempFile, (String)this.appModelFile.getAbsolutePath());
        this.lastLiquibaseRunTime = new Date(0L);
        logger.info("Saved xml model to file: {}", (Object)this.appModelFile);
    }

    public synchronized void initModel() {
        if (this.setups != null) {
            logger.info("Cleaning up old setups");
            for (Map.Entry entry : this.setups.entrySet()) {
                String databaseName = (String)entry.getKey();
                logger.info("Cleaning up old setup for: {}", (Object)databaseName);
                HibernateDatabaseSetup hibernateDatabaseSetup = (HibernateDatabaseSetup)entry.getValue();
                try {
                    SessionFactory sessionFactory = hibernateDatabaseSetup.getSessionFactory();
                    sessionFactory.close();
                }
                catch (Throwable t) {
                    logger.warn("Cannot close session factory for: " + databaseName, t);
                }
            }
        }
        this.setups.clear();
        this.model.init();
        for (com.manydesigns.portofino.model.database.Database database : this.model.getDatabases()) {
            String falseString;
            ConnectionProvider connectionProvider = database.getConnectionProvider();
            connectionProvider.init(this.databasePlatformsRegistry);
            if (!connectionProvider.getStatus().equals("connected")) continue;
            HibernateConfig builder = new HibernateConfig(connectionProvider, this.configuration);
            String trueString = database.getTrueString();
            if (trueString != null) {
                builder.setTrueString("null".equalsIgnoreCase(trueString) ? null : trueString);
            }
            if ((falseString = database.getFalseString()) != null) {
                builder.setFalseString("null".equalsIgnoreCase(falseString) ? null : falseString);
            }
            org.hibernate.cfg.Configuration configuration = builder.buildSessionFactory(database);
            StandardServiceRegistryBuilder registryBuilder = new StandardServiceRegistryBuilder().applySettings((Map)configuration.getProperties());
            SessionFactory sessionFactory = configuration.buildSessionFactory((ServiceRegistry)registryBuilder.build());
            HibernateDatabaseSetup setup = new HibernateDatabaseSetup(configuration, sessionFactory);
            String databaseName = database.getDatabaseName();
            this.setups.put(databaseName, setup);
        }
        this.cacheResetListenerRegistry.fireReset(new CacheResetEvent((Object)this));
    }

    public ConnectionProvider getConnectionProvider(String databaseName) {
        for (com.manydesigns.portofino.model.database.Database database : this.model.getDatabases()) {
            if (!database.getDatabaseName().equals(databaseName)) continue;
            return database.getConnectionProvider();
        }
        return null;
    }

    public Configuration getPortofinoProperties() {
        return this.configuration;
    }

    public DatabasePlatformsRegistry getDatabasePlatformsRegistry() {
        return this.databasePlatformsRegistry;
    }

    public Model getModel() {
        return this.model;
    }

    public void syncDataModel(String databaseName) throws Exception {
        if (!this.configuration.getBoolean("liquibase.enabled", true)) {
            logger.warn("syncDataModel called, but Liquibase is not enabled");
            return;
        }
        com.manydesigns.portofino.model.database.Database sourceDatabase = DatabaseLogic.findDatabaseByName(this.model, databaseName);
        ConnectionProvider connectionProvider = sourceDatabase.getConnectionProvider();
        DatabaseSyncer dbSyncer = new DatabaseSyncer(connectionProvider);
        com.manydesigns.portofino.model.database.Database targetDatabase = dbSyncer.syncDatabase(this.model);
        this.model.getDatabases().remove(sourceDatabase);
        this.model.getDatabases().add(targetDatabase);
    }

    public Session getSession(String databaseName) {
        return this.ensureDatabaseSetup(databaseName).getThreadSession();
    }

    protected HibernateDatabaseSetup ensureDatabaseSetup(String databaseName) {
        HibernateDatabaseSetup setup = this.setups.get(databaseName);
        if (setup == null) {
            throw new Error("No setup exists for database: " + databaseName);
        }
        return setup;
    }

    public void closeSessions() {
        for (HibernateDatabaseSetup current : this.setups.values()) {
            this.closeSession(current);
        }
    }

    public void closeSession(String databaseName) {
        this.closeSession(this.ensureDatabaseSetup(databaseName));
    }

    protected void closeSession(HibernateDatabaseSetup current) {
        Session session = current.getThreadSession(false);
        if (session != null) {
            try {
                Transaction transaction = session.getTransaction();
                if (transaction != null && transaction.isActive()) {
                    transaction.rollback();
                }
                session.close();
            }
            catch (Throwable e) {
                logger.warn("Couldn't close session: " + ExceptionUtils.getRootCauseMessage((Throwable)e), e);
            }
            current.removeThreadSession();
        }
    }

    @NotNull
    public TableAccessor getTableAccessor(String databaseName, String entityName) {
        com.manydesigns.portofino.model.database.Database database = DatabaseLogic.findDatabaseByName(this.model, databaseName);
        assert (database != null);
        Table table = DatabaseLogic.findTableByEntityName(database, entityName);
        assert (table != null);
        return new TableAccessor(table);
    }

    public void shutdown() {
        for (HibernateDatabaseSetup setup : this.setups.values()) {
            setup.getSessionFactory().close();
        }
        for (com.manydesigns.portofino.model.database.Database database : this.model.getDatabases()) {
            ConnectionProvider connectionProvider = database.getConnectionProvider();
            connectionProvider.shutdown();
        }
    }

    public String getName() {
        return this.getPortofinoProperties().getString("app.name");
    }

    public File getAppDbsDir() {
        return this.appDbsDir;
    }

    public File getAppModelFile() {
        return this.appModelFile;
    }
}

