/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.model.database;

import com.manydesigns.portofino.model.Model;
import com.manydesigns.portofino.model.database.DatabaseLogic;
import com.manydesigns.portofino.model.database.DatabaseSelectionProvider;
import com.manydesigns.portofino.model.database.HasReferences;
import com.manydesigns.portofino.model.database.Reference;
import com.manydesigns.portofino.model.database.Table;
import com.manydesigns.portofino.util.Pair;
import java.text.MessageFormat;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlAccessorType(value=XmlAccessType.NONE)
public class ForeignKey
extends DatabaseSelectionProvider
implements HasReferences {
    public static final String copyright = "Copyright (c) 2005-2015, ManyDesigns srl";
    protected String onUpdate;
    protected String onDelete;
    protected String toSchema;
    protected String manyPropertyName;
    protected String onePropertyName;
    protected String toTableName;
    protected String actualManyPropertyName;
    protected String actualOnePropertyName;
    protected Table toTable;
    public static final Logger logger = LoggerFactory.getLogger(ForeignKey.class);

    public ForeignKey() {
    }

    public ForeignKey(Table fromTable) {
        this();
        this.fromTable = fromTable;
    }

    @Override
    public String getQualifiedName() {
        return MessageFormat.format("{0}${1}", this.fromTable.getQualifiedName(), this.name);
    }

    @Override
    public void reset() {
        super.reset();
        this.toTable = null;
        this.actualManyPropertyName = null;
        this.actualOnePropertyName = null;
    }

    @Override
    public void init(Model model) {
        super.init(model);
        assert (this.fromTable != null);
        assert (this.name != null);
        assert (this.toSchema != null);
        assert (this.toTableName != null);
        if (this.references.isEmpty()) {
            throw new Error(MessageFormat.format("Foreign key {0} has no references", this.getQualifiedName()));
        }
    }

    @Override
    public void link(Model model) {
        super.link(model);
        this.toTable = DatabaseLogic.findTableByName(model, this.toDatabase, this.toSchema, this.toTableName);
        if (this.toTable != null) {
            this.toTable.getOneToManyRelationships().add(this);
            this.hql = "from " + this.toTable.getActualEntityName();
            this.actualManyPropertyName = this.manyPropertyName == null ? DatabaseLogic.getUniquePropertyName(this.toTable, DatabaseLogic.normalizeName(this.name)) : this.manyPropertyName;
        } else {
            logger.warn("Cannot find destination table '{}'", (Object)Table.composeQualifiedName(this.toDatabase, this.toSchema, this.toTableName));
            this.actualManyPropertyName = this.manyPropertyName == null ? DatabaseLogic.normalizeName(this.name) : this.manyPropertyName;
        }
        this.actualOnePropertyName = this.onePropertyName == null ? DatabaseLogic.getUniquePropertyName(this.fromTable, DatabaseLogic.normalizeName(this.name)) : this.onePropertyName;
    }

    public Reference findReferenceByColumnNamePair(Pair<String> columnNamePair) {
        for (Reference reference : this.references) {
            if (!ObjectUtils.equals((Object)reference.getFromColumn(), columnNamePair.left) || !ObjectUtils.equals((Object)reference.getToColumn(), columnNamePair.right)) continue;
            return reference;
        }
        return null;
    }

    public String getFromDatabaseName() {
        return this.fromTable.getDatabaseName();
    }

    public String getFromSchemaName() {
        return this.fromTable.getSchemaName();
    }

    public String getFromTableName() {
        return this.fromTable.getTableName();
    }

    @XmlAttribute(required=true)
    public String getOnUpdate() {
        return this.onUpdate;
    }

    public void setOnUpdate(String onUpdate) {
        this.onUpdate = onUpdate;
    }

    @XmlAttribute(required=true)
    public String getOnDelete() {
        return this.onDelete;
    }

    public void setOnDelete(String onDelete) {
        this.onDelete = onDelete;
    }

    @XmlAttribute(required=false)
    public String getManyPropertyName() {
        return this.manyPropertyName;
    }

    public void setManyPropertyName(String manyPropertyName) {
        this.manyPropertyName = manyPropertyName;
    }

    @XmlAttribute(required=false)
    public String getOnePropertyName() {
        return this.onePropertyName;
    }

    public void setOnePropertyName(String onePropertyName) {
        this.onePropertyName = onePropertyName;
    }

    public String getActualManyPropertyName() {
        return this.actualManyPropertyName;
    }

    public String getActualOnePropertyName() {
        return this.actualOnePropertyName;
    }

    @Override
    @XmlTransient
    public String getHql() {
        return this.hql;
    }

    @XmlAttribute(required=true)
    public String getToSchema() {
        return this.toSchema;
    }

    public void setToSchema(String toSchema) {
        this.toSchema = toSchema;
    }

    @Override
    public Table getToTable() {
        return this.toTable;
    }

    public void setToTable(Table toTable) {
        this.toTable = toTable;
    }

    @XmlAttribute(name="toTable")
    public String getToTableName() {
        return this.toTableName;
    }

    public void setToTableName(String toTableName) {
        this.toTableName = toTableName;
    }

    public String toString() {
        return MessageFormat.format("foreign key {0}", this.getQualifiedName());
    }
}

