/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.model.database;

import com.manydesigns.elements.annotations.Required;
import com.manydesigns.elements.util.ReflectionUtil;
import com.manydesigns.portofino.database.Type;
import com.manydesigns.portofino.model.Annotated;
import com.manydesigns.portofino.model.Annotation;
import com.manydesigns.portofino.model.Model;
import com.manydesigns.portofino.model.ModelObject;
import com.manydesigns.portofino.model.ModelObjectVisitor;
import com.manydesigns.portofino.model.database.DatabaseLogic;
import com.manydesigns.portofino.model.database.Table;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlAccessorType(value=XmlAccessType.NONE)
public class Column
implements ModelObject,
Annotated {
    public static final String copyright = "Copyright (c) 2005-2015, ManyDesigns srl";
    protected Table table;
    protected String columnName;
    protected int jdbcType;
    protected String columnType;
    protected boolean nullable;
    protected boolean autoincrement;
    protected Integer length;
    protected Integer scale;
    protected String javaType;
    protected String propertyName;
    protected final List<Annotation> annotations = new ArrayList<Annotation>();
    protected String actualPropertyName;
    protected Class actualJavaType;
    public static final Logger logger = LoggerFactory.getLogger(Column.class);

    public Column() {
    }

    public Column(Table table) {
        this();
        this.table = table;
    }

    public String getQualifiedName() {
        return MessageFormat.format("{0}.{1}", this.table.getQualifiedName(), this.columnName);
    }

    @Override
    public void afterUnmarshal(Unmarshaller u, Object parent) {
        this.table = (Table)parent;
    }

    @Override
    public void reset() {
        this.actualPropertyName = null;
        this.actualJavaType = null;
    }

    @Override
    public void init(Model model) {
        assert (this.table != null);
        assert (this.columnName != null);
        assert (this.columnType != null);
        this.actualPropertyName = this.propertyName == null ? DatabaseLogic.getUniquePropertyName(this.table, DatabaseLogic.normalizeName(this.columnName)) : this.propertyName;
        if (this.javaType != null) {
            this.actualJavaType = ReflectionUtil.loadClass((String)this.javaType);
            if (this.actualJavaType == null) {
                logger.warn("Cannot load column {} of java type: {}", (Object)this.getQualifiedName(), (Object)this.javaType);
            }
        } else {
            this.actualJavaType = Type.getDefaultJavaType(this.jdbcType, this.length, this.scale);
            if (this.actualJavaType == null) {
                logger.error("Cannot determine default Java type for table: {}, column: {}, jdbc type: {}, type name: {}. Skipping column.", new Object[]{this.table.getTableName(), this.getColumnName(), this.jdbcType, this.javaType});
            }
        }
    }

    @Override
    public void link(Model model) {
    }

    @Override
    public void visitChildren(ModelObjectVisitor visitor) {
        for (Annotation annotation : this.annotations) {
            visitor.visit(annotation);
        }
    }

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public String getDatabaseName() {
        return this.table.getDatabaseName();
    }

    public String getSchemaName() {
        return this.table.getSchemaName();
    }

    public String getTableName() {
        return this.table.getTableName();
    }

    @Required
    @XmlAttribute(required=true)
    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    @XmlAttribute(required=true)
    public int getJdbcType() {
        return this.jdbcType;
    }

    public void setJdbcType(int jdbcType) {
        this.jdbcType = jdbcType;
    }

    @Required
    @XmlAttribute(required=true)
    public String getColumnType() {
        return this.columnType;
    }

    public void setColumnType(String columnType) {
        this.columnType = columnType;
    }

    @XmlAttribute(required=true)
    public boolean isNullable() {
        return this.nullable;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    @XmlAttribute(required=true)
    public Integer getLength() {
        return this.length;
    }

    public void setLength(Integer length) {
        this.length = length;
    }

    @XmlAttribute(required=true)
    public Integer getScale() {
        return this.scale;
    }

    public void setScale(Integer scale) {
        this.scale = scale;
    }

    @XmlAttribute(required=true)
    public boolean isAutoincrement() {
        return this.autoincrement;
    }

    public void setAutoincrement(boolean autoincrement) {
        this.autoincrement = autoincrement;
    }

    public boolean isSearchable() {
        return true;
    }

    public Class getActualJavaType() {
        return this.actualJavaType;
    }

    @XmlAttribute(required=false)
    public String getJavaType() {
        return this.javaType;
    }

    public void setJavaType(String javaType) {
        this.javaType = javaType;
    }

    public String getActualPropertyName() {
        return this.actualPropertyName;
    }

    @XmlAttribute(required=false)
    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    @Override
    @XmlElementWrapper(name="annotations")
    @XmlElement(name="annotation", type=Annotation.class)
    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    public String toString() {
        return MessageFormat.format("column {0} {1}({2},{3}){4}", this.getQualifiedName(), this.columnType, Integer.toString(this.length), Integer.toString(this.scale), this.nullable ? "" : " NOT NULL");
    }

    public static String composeQualifiedName(String databaseName, String schemaName, String tableName, String columnName) {
        return MessageFormat.format("{0}.{1}.{2}.{3}", databaseName, schemaName, tableName, columnName);
    }

    public Annotation findModelAnnotationByType(String annotationType) {
        for (Annotation annotation : this.annotations) {
            if (!annotation.getType().equals(annotationType)) continue;
            return annotation;
        }
        return null;
    }
}

