/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.ui.support;

import com.manydesigns.portofino.ui.support.ApiInfo;
import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Resource {
    public static final String AUTHORIZATION_HEADER = "Authorization";
    private static final Logger logger = LoggerFactory.getLogger(Resource.class);
    @Context
    protected ServletContext servletContext;
    @Context
    protected HttpServletRequest request;
    @Context
    protected UriInfo uriInfo;

    public WebTarget path(String path) {
        Client c = ClientBuilder.newClient();
        return this.path(c, path);
    }

    protected WebTarget path(Client c, String path) {
        String baseUri;
        String localAddr = this.request.getLocalAddr();
        if (localAddr.contains(":")) {
            localAddr = "[" + localAddr + "]";
        }
        String localUri = this.request.getScheme() + "://" + localAddr + ":" + this.request.getLocalPort() + this.request.getContextPath();
        try {
            URI uri = new URI(localUri);
            baseUri = ApiInfo.getApiRootUri(this.servletContext, uri);
        }
        catch (URISyntaxException e) {
            logger.debug("Invalid local URI: " + localUri, (Throwable)e);
            baseUri = ApiInfo.getApiRootUri(this.servletContext, this.uriInfo);
        }
        if (path.startsWith(baseUri)) {
            path = path.substring(baseUri.length());
        }
        WebTarget target = c.target(baseUri);
        return target.path(path);
    }
}

