/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.ui.support;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseHrefReplaceListener
implements ServletContextListener {
    private static Logger logger = LoggerFactory.getLogger(BaseHrefReplaceListener.class);

    public void contextInitialized(ServletContextEvent sce) {
        String indexPath = sce.getServletContext().getRealPath("/index.html");
        File indexFile = new File(indexPath);
        if (indexFile.exists() && indexFile.canRead() && indexFile.canWrite()) {
            try (FileReader reader = new FileReader(indexFile);){
                StringWriter fileContents = new StringWriter();
                IOUtils.copy((Reader)reader, (Writer)fileContents);
                String newContents = fileContents.toString();
                String regex = "<base +href *= *['\"][^'\"]*['\"] */?>";
                String replacement = "<base href='" + sce.getServletContext().getContextPath() + "/'>";
                newContents = newContents.replaceFirst(regex, replacement);
                try (FileWriter writer = new FileWriter(indexFile);){
                    writer.write(newContents);
                }
            }
            catch (IOException e) {
                logger.warn("Could not patch index.html with the correct base href", (Throwable)e);
            }
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }
}

