/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.elements.pdf;

import com.manydesigns.elements.fields.Field;
import com.manydesigns.elements.forms.TableForm;
import com.manydesigns.elements.xml.XmlBuffer;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.lang.StringUtils;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;

@Deprecated
public class TableFormPdfExporter {
    public static final String copyright = "Copyright (C) 2005-2020 ManyDesigns srl";
    private final TableForm form;
    private final Source xsltSource;
    private String title;

    public TableFormPdfExporter(TableForm form, Source xsltSource) {
        this.form = form;
        this.xsltSource = xsltSource;
    }

    public void export(OutputStream outputStream) throws FOPException, IOException, TransformerException {
        FopFactory fopFactory = FopFactory.newInstance((URI)new File(".").toURI());
        Fop fop = fopFactory.newFop("application/pdf", outputStream);
        TransformerFactory factory = TransformerFactory.newInstance();
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        Transformer transformer = factory.newTransformer(this.xsltSource);
        transformer.setParameter("versionParam", "2.0");
        Reader reader = this.composeXml();
        StreamSource src = new StreamSource(reader);
        SAXResult res = new SAXResult(fop.getDefaultHandler());
        transformer.transform(src, res);
        reader.close();
        outputStream.flush();
    }

    protected Reader composeXml() {
        double[] columnSizes;
        XmlBuffer xb = new XmlBuffer();
        xb.writeXmlHeader("UTF-8");
        xb.openElement("class");
        xb.openElement("table");
        if (this.title != null) {
            xb.write(this.title);
        }
        xb.closeElement("table");
        for (double columnSize : columnSizes = this.setupColumnSizes()) {
            xb.openElement("column");
            xb.openElement("width");
            xb.write(columnSize + "em");
            xb.closeElement("width");
            xb.closeElement("column");
        }
        for (TableForm.Column col : this.form.getColumns()) {
            xb.openElement("header");
            xb.openElement("nameColumn");
            xb.write(col.getLabel());
            xb.closeElement("nameColumn");
            xb.closeElement("header");
        }
        for (TableForm.Row row : this.form.getRows()) {
            xb.openElement("rows");
            for (Field field : row) {
                xb.openElement("row");
                xb.openElement("value");
                xb.write(field.getStringValue());
                xb.closeElement("value");
                xb.closeElement("row");
            }
            xb.closeElement("rows");
        }
        xb.closeElement("class");
        return new StringReader(xb.toString());
    }

    protected double[] setupColumnSizes() {
        double[] headerSizes = new double[this.form.getColumns().length];
        for (int i = 0; i < headerSizes.length; ++i) {
            TableForm.Row[] col = this.form.getColumns()[i];
            int length = StringUtils.length((String)col.getLabel());
            headerSizes[i] = length;
        }
        double[] columnSizes = new double[this.form.getColumns().length];
        for (TableForm.Row row : this.form.getRows()) {
            int i = 0;
            for (Field field : row) {
                int size = StringUtils.length((String)field.getStringValue());
                double relativeSize = (double)size / (double)this.form.getRows().length;
                int n = i++;
                columnSizes[n] = columnSizes[n] + relativeSize;
            }
        }
        double totalSize = 0.0;
        for (int i = 0; i < columnSizes.length; ++i) {
            double effectiveSize;
            columnSizes[i] = effectiveSize = Math.max(columnSizes[i], headerSizes[i]);
            totalSize += effectiveSize;
        }
        while (totalSize > 75.0) {
            int maxIndex = 0;
            double max = 0.0;
            for (int i = 0; i < columnSizes.length; ++i) {
                if (!(columnSizes[i] > max)) continue;
                max = columnSizes[i];
                maxIndex = i;
            }
            int n = maxIndex;
            columnSizes[n] = columnSizes[n] - 1.0;
            totalSize -= 1.0;
        }
        while (totalSize < 70.0) {
            int minIndex = 0;
            double min = Double.MAX_VALUE;
            for (int i = 0; i < columnSizes.length; ++i) {
                if (!(columnSizes[i] < min)) continue;
                min = columnSizes[i];
                minIndex = i;
            }
            int n = minIndex;
            columnSizes[n] = columnSizes[n] + 1.0;
            totalSize += 1.0;
        }
        return columnSizes;
    }

    public TableForm getForm() {
        return this.form;
    }

    public Source getXsltSource() {
        return this.xsltSource;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }
}

