/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.elements.servlet;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class UrlBuilder {
    private String baseUrl;
    private String anchor;
    private String parameterSeparator;
    private List<Parameter> parameters = new ArrayList<Parameter>();
    private Charset charset;
    private String url;

    public UrlBuilder(Charset charset, String url, boolean isForPage) {
        this(charset, isForPage);
        if (url != null) {
            int index = url.indexOf(35);
            if (index != -1) {
                if (index < url.length() - 1) {
                    this.anchor = url.substring(index + 1);
                }
                url = url.substring(0, index);
            }
            this.baseUrl = url;
        }
    }

    protected UrlBuilder(Charset charset, boolean isForPage) {
        this.charset = charset;
        this.parameterSeparator = isForPage ? "&amp;" : "&";
    }

    public String getParameterSeparator() {
        return this.parameterSeparator;
    }

    public void setParameterSeparator(String parameterSeparator) {
        this.parameterSeparator = parameterSeparator;
    }

    public UrlBuilder addParameter(String name, Object ... values) {
        if (values == null || values.length == 0) {
            values = new String[]{""};
        }
        for (Object v : values) {
            if (v instanceof Collection) {
                this.addParameter(name, ((Collection)v).toArray());
                continue;
            }
            if (v != null && v.getClass().isArray()) {
                this.addParameter(name, (Object[])v);
                continue;
            }
            this.parameters.add(new Parameter(name, v));
            this.url = null;
        }
        return this;
    }

    public UrlBuilder addParameters(Map<? extends Object, ? extends Object> parameters) {
        for (Map.Entry<? extends Object, ? extends Object> parameter : parameters.entrySet()) {
            String name = parameter.getKey().toString();
            Object valueOrValues = parameter.getValue();
            if (valueOrValues == null) {
                this.addParameter(name, new Object[]{null});
                continue;
            }
            if (valueOrValues.getClass().isArray()) {
                this.addParameter(name, (Object[])valueOrValues);
                continue;
            }
            if (valueOrValues instanceof Collection) {
                this.addParameter(name, (Collection)valueOrValues);
                continue;
            }
            this.addParameter(name, valueOrValues);
        }
        return this;
    }

    public String getAnchor() {
        return this.anchor;
    }

    public UrlBuilder setAnchor(String anchor) {
        this.anchor = anchor != null && anchor.startsWith("#") && anchor.length() > 1 ? anchor.substring(1) : anchor;
        return this;
    }

    public String toString() {
        if (this.url == null) {
            this.url = this.build();
        }
        if (this.anchor != null && this.anchor.length() > 0) {
            try {
                return this.url + "#" + URLEncoder.encode(this.anchor, this.charset.name());
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return this.url;
    }

    protected String format(Object value) {
        if (value == null) {
            return "";
        }
        return value.toString();
    }

    protected String build() {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>(this.parameters.size() + 1);
        parameters.addAll(this.parameters);
        StringBuilder buffer = new StringBuilder(256);
        buffer.append(this.baseUrl);
        boolean seenQuestionMark = buffer.indexOf("?") != -1;
        for (Parameter param : parameters) {
            if (!seenQuestionMark) {
                buffer.append('?');
                seenQuestionMark = true;
            } else {
                buffer.append(this.getParameterSeparator());
            }
            try {
                buffer.append(URLEncoder.encode(param.name, this.charset.name())).append('=');
                if (param.value == null) continue;
                String formatted = this.format(param.value);
                buffer.append(URLEncoder.encode(formatted, this.charset.name()));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return buffer.toString();
    }

    private static class Parameter {
        String name;
        Object value;

        Parameter(String name, Object value) {
            this.name = name;
            this.value = value;
        }

        public String toString() {
            return "" + this.name + "=" + this.value;
        }
    }
}

