/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.elements;

import com.manydesigns.elements.FieldEncrypter;
import com.manydesigns.elements.crypto.CryptoService;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFieldEncrypter
implements FieldEncrypter {
    private static final Logger logger = LoggerFactory.getLogger(DefaultFieldEncrypter.class);

    @Override
    public String encrypt(String value) {
        if (StringUtils.trimToNull((String)value) == null) {
            return value;
        }
        try {
            CryptoService.getInstance().encrypt(value);
        }
        catch (Exception e) {
            logger.error("DefaultFieldEncrypter.encrypt error:" + e.getMessage(), (Throwable)e);
        }
        return value;
    }

    @Override
    public String decrypt(String value) {
        if (StringUtils.trimToNull((String)value) == null) {
            return value;
        }
        try {
            CryptoService.getInstance().decrypt(value);
        }
        catch (Exception e) {
            logger.error("DefaultFieldEncrypter.decrypt error:" + e.getMessage(), (Throwable)e);
        }
        return value;
    }
}

