/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.elements.reflection;

import com.manydesigns.elements.reflection.AbstractAnnotatedAccessor;
import com.manydesigns.elements.reflection.ClassAccessor;
import com.manydesigns.elements.reflection.PropertyAccessor;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;

public class MutableClassAccessor
extends AbstractAnnotatedAccessor
implements ClassAccessor {
    protected String name;
    protected Class<?> type;
    protected final List<PropertyAccessor> properties = new ArrayList<PropertyAccessor>();
    protected final List<PropertyAccessor> keyProperties = new ArrayList<PropertyAccessor>();

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    public void setType(Class<?> type) {
        this.type = type;
    }

    @Override
    public PropertyAccessor getProperty(String propertyName) throws NoSuchFieldException {
        for (PropertyAccessor p : this.properties) {
            if (!p.getName().equals(propertyName)) continue;
            return p;
        }
        throw new NoSuchFieldException(propertyName);
    }

    @Override
    public PropertyAccessor[] getProperties() {
        return (PropertyAccessor[])this.properties.toArray();
    }

    @Override
    public PropertyAccessor[] getKeyProperties() {
        return (PropertyAccessor[])this.keyProperties.toArray();
    }

    @Override
    public Object newInstance() {
        throw new UnsupportedOperationException();
    }

    public void addProperty(PropertyAccessor propertyAccessor) {
        this.properties.add(propertyAccessor);
    }

    public void addKeyProperty(PropertyAccessor propertyAccessor) {
        this.addProperty(propertyAccessor);
        this.keyProperties.add(propertyAccessor);
    }

    public List<PropertyAccessor> getMutableProperties() {
        return this.properties;
    }

    public List<PropertyAccessor> getMutableKeyProperties() {
        return this.keyProperties;
    }

    public MutableClassAccessor configureAnnotation(Annotation annotation) {
        this.annotations.put(annotation.annotationType(), annotation);
        return this;
    }
}

