/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.elements.messages;

import com.manydesigns.elements.ElementsThreadLocals;
import com.manydesigns.elements.xml.XhtmlBuffer;
import com.manydesigns.elements.xml.XhtmlFragment;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionMessages {
    public static final String copyright = "Copyright (C) 2005-2016, ManyDesigns srl";
    public static final String INFO_MESSAGES_KEY = "info_messages_key";
    public static final String WARNING_MESSAGES_KEY = "warning_messages_key";
    public static final String ERROR_MESSAGES_KEY = "error_messages_key";
    public static final Logger logger = LoggerFactory.getLogger(SessionMessages.class);

    public static void addInfoMessage(String msg) {
        SessionMessages.getInfoQueue().add(StringEscapeUtils.escapeXml((String)msg));
    }

    public static void addInfoMessage(XhtmlFragment xml) {
        XhtmlBuffer buf = new XhtmlBuffer();
        xml.toXhtml(buf);
        SessionMessages.getInfoQueue().add(buf.toString());
    }

    public static void addWarningMessage(String msg) {
        SessionMessages.getWarningQueue().add(StringEscapeUtils.escapeXml((String)msg));
    }

    public static void addWarningMessage(XhtmlFragment xml) {
        XhtmlBuffer buf = new XhtmlBuffer();
        xml.toXhtml(buf);
        SessionMessages.getWarningQueue().add(buf.toString());
    }

    public static void addErrorMessage(String msg) {
        SessionMessages.getErrorQueue().add(StringEscapeUtils.escapeXml((String)msg));
    }

    public static void addErrorMessage(XhtmlFragment xml) {
        XhtmlBuffer buf = new XhtmlBuffer();
        xml.toXhtml(buf);
        SessionMessages.getErrorQueue().add(buf.toString());
    }

    public static List<String> consumeInfoMessages() {
        ArrayList<String> result = new ArrayList<String>();
        SessionMessages.getInfoQueue().drainTo(result);
        return result;
    }

    public static List<String> consumeWarningMessages() {
        ArrayList<String> result = new ArrayList<String>();
        SessionMessages.getWarningQueue().drainTo(result);
        return result;
    }

    public static List<String> consumeErrorMessages() {
        ArrayList<String> result = new ArrayList<String>();
        SessionMessages.getErrorQueue().drainTo(result);
        return result;
    }

    public static BlockingQueue<String> getInfoQueue() {
        return SessionMessages.getQueue(INFO_MESSAGES_KEY);
    }

    public static BlockingQueue<String> getWarningQueue() {
        return SessionMessages.getQueue(WARNING_MESSAGES_KEY);
    }

    public static BlockingQueue<String> getErrorQueue() {
        return SessionMessages.getQueue(ERROR_MESSAGES_KEY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static BlockingQueue<String> getQueue(String queueName) {
        LinkedBlockingQueue<String> infoQueue;
        HttpSession session;
        HttpServletRequest req = ElementsThreadLocals.getHttpServletRequest();
        if (req == null) {
            logger.debug("No request available. Returning dummy queue.");
            return new LinkedBlockingQueue<String>();
        }
        HttpSession httpSession = session = req.getSession();
        synchronized (httpSession) {
            infoQueue = (LinkedBlockingQueue<String>)session.getAttribute(queueName);
            if (infoQueue == null) {
                infoQueue = new LinkedBlockingQueue<String>();
                session.setAttribute(queueName, infoQueue);
            }
        }
        return infoQueue;
    }
}

