/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.elements.xls;

import com.manydesigns.elements.ElementsThreadLocals;
import com.manydesigns.elements.fields.BooleanField;
import com.manydesigns.elements.fields.DateField;
import com.manydesigns.elements.fields.Field;
import com.manydesigns.elements.fields.NumericField;
import com.manydesigns.elements.fields.PasswordField;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import jxl.CellView;
import jxl.biff.DisplayFormat;
import jxl.format.CellFormat;
import jxl.write.DateFormat;
import jxl.write.DateTime;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.NumberFormat;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableSheet;
import jxl.write.WriteException;

public class XlsUtil {
    public static final String copyright = "Copyright (C) 2005-2025 ManyDesigns srl";
    private HashMap<String, WritableCellFormat> formatMap = new HashMap();

    public void addFieldToCell(WritableSheet sheet, int i, int j, Field field) throws WriteException {
        if (field instanceof NumericField) {
            NumericField numField = (NumericField)field;
            if (numField.getValue() != null) {
                BigDecimal decimalValue = numField.getValue();
                Number number = numField.getDecimalFormat() == null ? new Number(j, i, (decimalValue == null ? null : Double.valueOf(decimalValue.doubleValue())).doubleValue()) : new Number(j, i, (decimalValue == null ? null : Double.valueOf(decimalValue.doubleValue())).doubleValue(), (CellFormat)this.getNumberFormat(numField.getDecimalFormat().toPattern()));
                sheet.addCell((WritableCell)number);
            }
        } else if (field instanceof PasswordField) {
            Label label = new Label(j, i, "********");
            sheet.addCell((WritableCell)label);
        } else if (field instanceof DateField) {
            DateField dateField = (DateField)field;
            Date date = (Date)dateField.getValue();
            if (date != null) {
                DateTime dateCell = new DateTime(j, i, date, (CellFormat)this.getDateFormat(dateField.getDatePattern()));
                sheet.addCell((WritableCell)dateCell);
            }
        } else if (field instanceof BooleanField) {
            BooleanField booleanField = (BooleanField)field;
            Boolean booleanFieldValue = booleanField.getValue();
            if (booleanFieldValue != null) {
                Label label = new Label(j, i, booleanFieldValue != false ? this.getText("elements.Yes", new Object[0]) : this.getText("elements.No", new Object[0]));
                sheet.addCell((WritableCell)label);
            }
        } else {
            Label label = new Label(j, i, field.getStringValue());
            sheet.addCell((WritableCell)label);
        }
    }

    protected String getText(String key, Object ... args) {
        return ElementsThreadLocals.getTextProvider().getText(key, args);
    }

    public static void autoSizeColumns(WritableSheet sheet, int columns) {
        for (int c = 0; c < columns; ++c) {
            CellView cell = sheet.getColumnView(c);
            cell.setAutosize(true);
            sheet.setColumnView(c, cell);
        }
    }

    private WritableCellFormat getDateFormat(String pattern) {
        if (this.formatMap.containsKey(pattern)) {
            return this.formatMap.get(pattern);
        }
        DateFormat dateFormat = new DateFormat(pattern);
        WritableCellFormat wDateFormat = new WritableCellFormat((DisplayFormat)dateFormat);
        this.formatMap.put(pattern, wDateFormat);
        return wDateFormat;
    }

    private WritableCellFormat getNumberFormat(String pattern) {
        if (this.formatMap.containsKey(pattern)) {
            return this.formatMap.get(pattern);
        }
        NumberFormat numberFormat = new NumberFormat(pattern);
        WritableCellFormat wNumberFormat = new WritableCellFormat((DisplayFormat)numberFormat);
        this.formatMap.put(pattern, wNumberFormat);
        return wNumberFormat;
    }
}

