/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.elements.fields;

import com.manydesigns.elements.Mode;
import com.manydesigns.elements.annotations.DatabaseBlob;
import com.manydesigns.elements.blobs.Blob;
import com.manydesigns.elements.blobs.BlobManager;
import com.manydesigns.elements.fields.AbstractBlobField;
import com.manydesigns.elements.ognl.OgnlUtils;
import com.manydesigns.elements.reflection.ClassAccessor;
import com.manydesigns.elements.reflection.PropertyAccessor;
import com.manydesigns.elements.util.RandomUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseBlobField
extends AbstractBlobField {
    public static final String copyright = "Copyright (C) 2005-2025 ManyDesigns srl";
    private static final Logger logger = LoggerFactory.getLogger(DatabaseBlobField.class);
    protected final PropertyAccessor contentTypeAccessor;
    protected final PropertyAccessor fileNameAccessor;
    protected final PropertyAccessor timestampAccessor;

    public DatabaseBlobField(@NotNull ClassAccessor classAccessor, @NotNull PropertyAccessor accessor, @NotNull Mode mode, @Nullable String prefix) throws NoSuchFieldException {
        super(accessor, mode, prefix);
        DatabaseBlob databaseBlob = accessor.getAnnotation(DatabaseBlob.class);
        this.contentTypeAccessor = databaseBlob != null && !StringUtils.isEmpty((String)databaseBlob.contentTypeProperty()) ? classAccessor.getProperty(databaseBlob.contentTypeProperty()) : null;
        this.fileNameAccessor = databaseBlob != null && !StringUtils.isEmpty((String)databaseBlob.fileNameProperty()) ? classAccessor.getProperty(databaseBlob.fileNameProperty()) : null;
        this.timestampAccessor = databaseBlob != null && !StringUtils.isEmpty((String)databaseBlob.timestampProperty()) ? classAccessor.getProperty(databaseBlob.timestampProperty()) : null;
    }

    @Override
    public boolean isSaveBlobOnObject() {
        return true;
    }

    @Override
    public void readFromObject(Object obj) {
        super.readFromObject(obj);
        if (obj == null) {
            this.forgetBlob();
        } else {
            byte[] value = (byte[])this.accessor.get(obj);
            if (value == null) {
                this.forgetBlob();
            } else {
                this.blob = new Blob(null);
                this.blob.setSize(value.length);
                this.blob.setInputStream(new ByteArrayInputStream(value));
                if (this.fileNameAccessor != null) {
                    this.blob.setFilename((String)this.fileNameAccessor.get(obj));
                } else {
                    this.blob.setFilename("binary.blob");
                }
                if (this.contentTypeAccessor != null) {
                    this.blob.setContentType((String)this.contentTypeAccessor.get(obj));
                } else {
                    this.blob.setContentType("application/octet-stream");
                }
                if (this.timestampAccessor != null) {
                    DateTime dt = OgnlUtils.convertValue(this.timestampAccessor.get(obj), DateTime.class);
                    this.blob.setCreateTimestamp(dt != null ? dt : new DateTime());
                } else {
                    this.blob.setCreateTimestamp(new DateTime());
                }
            }
        }
    }

    @Override
    public void writeToObject(Object obj) {
        if (this.blob == null) {
            this.writeToObject(obj, null);
        } else {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                IOUtils.copyLarge((InputStream)this.blob.getInputStream(), (OutputStream)baos);
                this.writeToObject(obj, baos.toByteArray());
                if (this.fileNameAccessor != null) {
                    this.writeToObject(this.fileNameAccessor, obj, this.blob.getFilename());
                }
                if (this.contentTypeAccessor != null) {
                    this.writeToObject(this.contentTypeAccessor, obj, this.blob.getContentType());
                }
                if (this.timestampAccessor != null) {
                    Object ts = OgnlUtils.convertValue(this.blob.getCreateTimestamp(), this.timestampAccessor.getType());
                    if (ts == null) {
                        ts = OgnlUtils.convertValue(new DateTime(), this.timestampAccessor.getType());
                    }
                    this.writeToObject(this.timestampAccessor, obj, ts);
                }
            }
            catch (IOException e) {
                logger.error("Could not save blob", (Throwable)e);
                this.blobError = this.getText("elements.error.field.databaseblob.couldntSaveBlob", new Object[0]);
            }
        }
    }

    @Override
    protected void loadBlob(BlobManager blobManager, Blob blob, boolean loadContents) throws IOException {
        if (!blob.isPropertiesLoaded()) {
            blobManager.loadMetadata(blob);
        }
        if (loadContents || blob.getInputStream() == null) {
            blobManager.openStream(blob);
        }
    }

    @Override
    public String generateNewCode() {
        return RandomUtil.createRandomId(25);
    }

    public PropertyAccessor getContentTypeAccessor() {
        return this.contentTypeAccessor;
    }

    public PropertyAccessor getFileNameAccessor() {
        return this.fileNameAccessor;
    }
}

