/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.elements.fields.search;

import com.manydesigns.elements.annotations.MaxLength;
import com.manydesigns.elements.fields.search.AbstractSearchField;
import com.manydesigns.elements.fields.search.Criteria;
import com.manydesigns.elements.fields.search.TextMatchMode;
import com.manydesigns.elements.reflection.PropertyAccessor;
import com.manydesigns.elements.xml.XhtmlBuffer;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;

public class TextSearchField
extends AbstractSearchField {
    public static final String copyright = "Copyright (C) 2005-2021 ManyDesigns srl";
    public static final String MODE_SUFFIX = "_mode";
    public static final String MATCH_MODE_LABEL = "Match mode";
    protected String value;
    protected TextMatchMode matchMode = TextMatchMode.CONTAINS;
    protected String matchModeId;
    protected String matchModeParam;
    protected boolean showMatchMode = true;
    protected Integer maxLength = null;

    public TextSearchField(PropertyAccessor accessor) {
        this(accessor, null);
    }

    public TextSearchField(PropertyAccessor accessor, String prefix) {
        super(accessor, prefix);
        if (accessor.isAnnotationPresent(MaxLength.class)) {
            this.maxLength = accessor.getAnnotation(MaxLength.class).value();
        }
        this.matchModeId = this.id + MODE_SUFFIX;
        this.matchModeParam = this.inputName + MODE_SUFFIX;
    }

    @Override
    public void toXhtml(@NotNull XhtmlBuffer xb) {
        xb.openElement("div");
        xb.addAttribute("class", "form-group");
        xb.writeLabel(StringUtils.capitalize((String)this.label), this.id, "control-label");
        xb.openElement("div");
        xb.addAttribute("class", "text-search-form-control");
        if (this.showMatchMode) {
            xb.writeLabel(MATCH_MODE_LABEL, this.matchModeId, "match_mode");
            xb.openElement("select");
            xb.addAttribute("id", this.matchModeId);
            xb.addAttribute("name", this.matchModeParam);
            xb.addAttribute("class", "form-control match_mode");
            for (TextMatchMode m : TextMatchMode.values()) {
                boolean checked = this.matchMode == m;
                String option = m.getStringValue();
                xb.writeOption(option, checked, this.getText(m.getI18nKey(), new Object[0]));
            }
            xb.closeElement("select");
            xb.write(" ");
        }
        xb.writeInputText(this.id, this.inputName, this.value, "form-control", 18, this.maxLength);
        xb.closeElement("div");
        xb.closeElement("div");
    }

    @Override
    public void readFromRequest(HttpServletRequest req) {
        this.value = StringUtils.trimToNull((String)req.getParameter(this.inputName));
        if (this.showMatchMode) {
            String matchModeStr = req.getParameter(this.matchModeParam);
            this.matchMode = TextMatchMode.CONTAINS;
            for (TextMatchMode m : TextMatchMode.values()) {
                if (!m.getStringValue().equals(matchModeStr)) continue;
                this.matchMode = m;
            }
        }
    }

    @Override
    public boolean validate() {
        return true;
    }

    @Override
    public void toSearchString(StringBuilder sb, String encoding) {
        if (this.value != null) {
            this.appendToSearchString(sb, this.inputName, this.value, encoding);
        }
        if (this.matchMode != null && this.matchMode != TextMatchMode.CONTAINS && this.showMatchMode) {
            this.appendToSearchString(sb, this.matchModeParam, this.matchMode.getStringValue(), encoding);
        }
    }

    @Override
    public void configureCriteria(Criteria criteria) {
        if (this.value != null) {
            criteria.ilike(this.accessor, this.value, this.matchMode);
        }
    }

    public TextMatchMode getMatchMode() {
        return this.matchMode;
    }

    public void setMatchMode(TextMatchMode matchMode) {
        this.matchMode = matchMode;
    }

    public boolean isShowMatchMode() {
        return this.showMatchMode;
    }

    public void setShowMatchMode(boolean showMatchMode) {
        this.showMatchMode = showMatchMode;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getMatchModeId() {
        return this.matchModeId;
    }

    public void setMatchModeId(String matchModeId) {
        this.matchModeId = matchModeId;
    }

    public String getMatchModeParam() {
        return this.matchModeParam;
    }

    public void setMatchModeParam(String matchModeParam) {
        this.matchModeParam = matchModeParam;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
    }
}

