/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.elements.fields;

import com.manydesigns.elements.Mode;
import com.manydesigns.elements.blobs.Blob;
import com.manydesigns.elements.fields.AbstractBlobField;
import com.manydesigns.elements.reflection.PropertyAccessor;
import com.manydesigns.elements.util.RandomUtil;
import java.util.concurrent.Callable;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileBlobField
extends AbstractBlobField {
    public static final String copyright = "Copyright (C) 2005-2021 ManyDesigns srl";
    public final Callable<String> DEFAULT_CODE_GENERATOR = new Callable<String>(){

        @Override
        public String call() {
            return RandomUtil.createRandomId(FileBlobField.this.size);
        }
    };
    protected Callable<String> blobCodeGenerator = this.DEFAULT_CODE_GENERATOR;
    protected String encryptionType = null;

    public FileBlobField(@NotNull PropertyAccessor accessor, @NotNull Mode mode, @Nullable String prefix) {
        super(accessor, mode, prefix);
    }

    public FileBlobField(@NotNull PropertyAccessor accessor, @NotNull Mode mode, @Nullable String prefix, @Nullable String encryptionType) {
        super(accessor, mode, prefix);
        this.encryptionType = encryptionType;
    }

    @Override
    public boolean isSaveBlobOnObject() {
        return false;
    }

    @Override
    public void readFromObject(Object obj) {
        super.readFromObject(obj);
        if (obj == null) {
            this.forgetBlob();
        } else {
            String code = (String)this.accessor.get(obj);
            if (StringUtils.isBlank((String)code)) {
                this.forgetBlob();
            } else {
                this.blob = new Blob(code);
                this.blob.setEncryptionType(this.encryptionType);
            }
        }
    }

    @Override
    public void writeToObject(Object obj) {
        if (this.blob == null) {
            this.writeToObject(obj, null);
        } else {
            this.writeToObject(obj, this.blob.getCode());
        }
    }

    @Override
    public String generateNewCode() {
        try {
            return this.blobCodeGenerator.call();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Callable<String> getBlobCodeGenerator() {
        return this.blobCodeGenerator;
    }

    public void setBlobCodeGenerator(Callable<String> blobCodeGenerator) {
        this.blobCodeGenerator = blobCodeGenerator;
    }

    public String getEncryptionType() {
        return this.encryptionType;
    }

    public void setEncryptionType(String encryptionType) {
        this.encryptionType = encryptionType;
    }
}

