/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.elements.blobs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Blob {
    public static final String copyright = "Copyright (c) 2005-2014, ManyDesigns srl";
    public static final String CODE_PROPERTY = "code";
    public static final String FILENAME_PROPERTY = "filename";
    public static final String CONTENT_TYPE_PROPERTY = "content.type";
    public static final String SIZE_PROPERTY = "size";
    public static final String CREATE_TIMESTAMP_PROPERTY = "create.timestamp";
    public static final String CHARACTER_ENCODING_PROPERTY = "character.encoding";
    public static final String COMMENT = "Blob metadata";
    protected static final DateTimeFormatter formatter = ISODateTimeFormat.dateTime();
    protected final File metaFile;
    protected final File dataFile;
    protected String code;
    protected String contentType;
    protected String filename;
    protected long size;
    protected DateTime createTimestamp;
    protected String characterEncoding;
    public static final Logger logger = LoggerFactory.getLogger(Blob.class);

    public Blob(@NotNull File metaFile, @NotNull File dataFile) {
        this.metaFile = metaFile;
        this.dataFile = dataFile;
    }

    public boolean createFiles() throws IOException {
        if (this.dataFile.createNewFile()) {
            logger.warn("Blob data file already exists: {}", (Object)this.metaFile.getAbsolutePath());
            return false;
        }
        if (this.metaFile.createNewFile()) {
            logger.warn("Blob meta file already exists: {}", (Object)this.metaFile.getAbsolutePath());
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveMetaProperties() throws IOException {
        Properties metaProperties = new Properties();
        this.createTimestamp = new DateTime();
        this.safeSetProperty(metaProperties, CODE_PROPERTY, this.code);
        this.safeSetProperty(metaProperties, FILENAME_PROPERTY, this.filename);
        this.safeSetProperty(metaProperties, CONTENT_TYPE_PROPERTY, this.contentType);
        this.safeSetProperty(metaProperties, SIZE_PROPERTY, Long.toString(this.size));
        this.safeSetProperty(metaProperties, CREATE_TIMESTAMP_PROPERTY, formatter.print((ReadableInstant)this.createTimestamp));
        this.safeSetProperty(metaProperties, CHARACTER_ENCODING_PROPERTY, this.characterEncoding);
        FileOutputStream metaStream = null;
        try {
            metaStream = new FileOutputStream(this.metaFile);
            metaProperties.store(metaStream, COMMENT);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(metaStream);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)metaStream);
    }

    protected void safeSetProperty(Properties metaProperties, String key, String value) {
        if (value == null) {
            metaProperties.remove(key);
        } else {
            metaProperties.setProperty(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadMetaProperties() throws IOException {
        Properties metaProperties = new Properties();
        FileInputStream metaStream = null;
        try {
            metaStream = new FileInputStream(this.metaFile);
            metaProperties.load(metaStream);
            this.code = metaProperties.getProperty(CODE_PROPERTY);
            this.filename = metaProperties.getProperty(FILENAME_PROPERTY);
            this.contentType = metaProperties.getProperty(CONTENT_TYPE_PROPERTY);
            this.size = Long.parseLong(metaProperties.getProperty(SIZE_PROPERTY));
            this.createTimestamp = formatter.parseDateTime(metaProperties.getProperty(CREATE_TIMESTAMP_PROPERTY));
            this.characterEncoding = metaProperties.getProperty(CHARACTER_ENCODING_PROPERTY);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(metaStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)metaStream);
    }

    public File getMetaFile() {
        return this.metaFile;
    }

    public File getDataFile() {
        return this.dataFile;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public DateTime getCreateTimestamp() {
        return this.createTimestamp;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setCharacterEncoding(String characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Blob)) {
            return false;
        }
        Blob blob = (Blob)o;
        if (this.size != blob.size) {
            return false;
        }
        if (this.characterEncoding != null ? !this.characterEncoding.equals(blob.characterEncoding) : blob.characterEncoding != null) {
            return false;
        }
        if (this.code != null ? !this.code.equals(blob.code) : blob.code != null) {
            return false;
        }
        if (this.contentType != null ? !this.contentType.equals(blob.contentType) : blob.contentType != null) {
            return false;
        }
        if (this.createTimestamp != null ? !this.createTimestamp.equals((Object)blob.createTimestamp) : blob.createTimestamp != null) {
            return false;
        }
        if (this.dataFile != null ? !this.dataFile.equals(blob.dataFile) : blob.dataFile != null) {
            return false;
        }
        if (this.filename != null ? !this.filename.equals(blob.filename) : blob.filename != null) {
            return false;
        }
        return !(this.metaFile != null ? !this.metaFile.equals(blob.metaFile) : blob.metaFile != null);
    }

    public int hashCode() {
        int result = this.metaFile != null ? this.metaFile.hashCode() : 0;
        result = 31 * result + (this.dataFile != null ? this.dataFile.hashCode() : 0);
        result = 31 * result + (this.code != null ? this.code.hashCode() : 0);
        result = 31 * result + (this.contentType != null ? this.contentType.hashCode() : 0);
        result = 31 * result + (this.filename != null ? this.filename.hashCode() : 0);
        result = 31 * result + (int)(this.size ^ this.size >>> 32);
        result = 31 * result + (this.createTimestamp != null ? this.createTimestamp.hashCode() : 0);
        result = 31 * result + (this.characterEncoding != null ? this.characterEncoding.hashCode() : 0);
        return result;
    }
}

