/*
 * Decompiled with CFR 0.152.
 */
package com.mangopay.core;

import com.mangopay.MangoPayApi;
import com.mangopay.core.Base64Encoder;
import com.mangopay.core.OAuthToken;
import java.util.HashMap;
import java.util.Map;

public class AuthenticationHelper {
    private MangoPayApi _root;

    public AuthenticationHelper(MangoPayApi root) throws Exception {
        this._root = root;
    }

    public Map<String, String> getHttpHeaderKey() throws Exception {
        return this.getHttpHeaderStrong();
    }

    public String getHttpHeaderBasicKey() throws Exception {
        if (this._root.Config.ClientId == null || this._root.Config.ClientId.length() == 0) {
            throw new Exception("MangoPay.Config.ClientId is not set.");
        }
        if (this._root.Config.ClientPassword == null || this._root.Config.ClientPassword.length() == 0) {
            throw new Exception("MangoPay.Config.ClientPassword is not set.");
        }
        String signature = this._root.Config.ClientId + ':' + this._root.Config.ClientPassword;
        return Base64Encoder.encode(signature);
    }

    private Map<String, String> getHttpHeaderBasic() throws Exception {
        return new HashMap<String, String>(){
            {
                this.put("Authorization", "Basic " + AuthenticationHelper.this.getHttpHeaderBasicKey());
            }
        };
    }

    private Map<String, String> getHttpHeaderStrong() throws Exception {
        final OAuthToken token = this._root.OAuthTokenManager.getToken();
        if (token == null || token.access_token.length() == 0 || token.token_type.length() == 0) {
            throw new Exception("OAuth token is not created (or is invalid) for strong authentication");
        }
        return new HashMap<String, String>(){
            {
                this.put("Authorization", token.token_type + " " + token.access_token);
            }
        };
    }
}

