/*
 * Decompiled with CFR 0.152.
 */
package com.mangopay.core.APIs;

import com.mangopay.MangoPayApi;
import com.mangopay.core.Dto;
import com.mangopay.core.EntityBase;
import com.mangopay.core.Pagination;
import com.mangopay.core.RestTool;
import com.mangopay.core.Sorting;
import com.mangopay.core.enumerations.RequestType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class ApiBase {
    protected MangoPayApi _root;
    private Map<String, String[]> methods = new HashMap<String, String[]>(){
        {
            this.put("client_get", new String[]{"/clients/", RequestType.GET.toString()});
            this.put("client_save", new String[]{"/clients/", RequestType.PUT.toString()});
            this.put("client_upload_logo", new String[]{"/clients/logo/", RequestType.PUT.toString()});
            this.put("client_get_wallets_default", new String[]{"/clients/wallets", RequestType.GET.toString()});
            this.put("client_get_wallets_fees", new String[]{"/clients/wallets/fees", RequestType.GET.toString()});
            this.put("client_get_wallets_credit", new String[]{"/clients/wallets/credit", RequestType.GET.toString()});
            this.put("client_get_wallets_default_with_currency", new String[]{"/clients/wallets/%s", RequestType.GET.toString()});
            this.put("client_get_wallets_fees_with_currency", new String[]{"/clients/wallets/fees/%s", RequestType.GET.toString()});
            this.put("client_get_wallets_credit_with_currency", new String[]{"/clients/wallets/credit/%s", RequestType.GET.toString()});
            this.put("client_get_wallet_transactions", new String[]{"/clients/wallets/%s/%s/transactions", RequestType.GET.toString()});
            this.put("client_get_transactions", new String[]{"/clients/transactions", RequestType.GET.toString()});
            this.put("client_get_kyc_documents", new String[]{"/KYC/documents", RequestType.GET.toString()});
            this.put("client_create_bankwire_direct", new String[]{"/clients/payins/bankwire/direct", RequestType.POST.toString()});
            this.put("authentication_base", new String[]{"/clients/", RequestType.POST.toString()});
            this.put("authentication_oauth", new String[]{"/oauth/token ", RequestType.POST.toString()});
            this.put("events_all", new String[]{"/events", RequestType.GET.toString()});
            this.put("hooks_create", new String[]{"/hooks", RequestType.POST.toString()});
            this.put("hooks_all", new String[]{"/hooks", RequestType.GET.toString()});
            this.put("hooks_get", new String[]{"/hooks/%s", RequestType.GET.toString()});
            this.put("hooks_save", new String[]{"/hooks/%s", RequestType.PUT.toString()});
            this.put("cardregistration_create", new String[]{"/cardregistrations", RequestType.POST.toString()});
            this.put("cardregistration_get", new String[]{"/cardregistrations/%s", RequestType.GET.toString()});
            this.put("cardregistration_save", new String[]{"/cardregistrations/%s", RequestType.PUT.toString()});
            this.put("preauthorization_create", new String[]{"/preauthorizations/card/direct", RequestType.POST.toString()});
            this.put("preauthorization_get", new String[]{"/preauthorizations/%s", RequestType.GET.toString()});
            this.put("preauthorization_save", new String[]{"/preauthorizations/%s", RequestType.PUT.toString()});
            this.put("card_get", new String[]{"/cards/%s", RequestType.GET.toString()});
            this.put("card_save", new String[]{"/cards/%s", RequestType.PUT.toString()});
            this.put("payins_paypal-web_create", new String[]{"/payins/paypal/web/", RequestType.POST.toString()});
            this.put("payins_card-web_create", new String[]{"/payins/card/web/", RequestType.POST.toString()});
            this.put("payins_card-direct_create", new String[]{"/payins/card/direct/", RequestType.POST.toString()});
            this.put("payins_preauthorized-direct_create", new String[]{"/payins/preauthorized/direct/", RequestType.POST.toString()});
            this.put("payins_bankwire-direct_create", new String[]{"/payins/bankwire/direct/", RequestType.POST.toString()});
            this.put("payins_directdebit-web_create", new String[]{"/payins/directdebit/web", RequestType.POST.toString()});
            this.put("payins_get", new String[]{"/payins/%s", RequestType.GET.toString()});
            this.put("payins_getrefunds", new String[]{"/payins/%s/refunds", RequestType.GET.toString()});
            this.put("payins_createrefunds", new String[]{"/payins/%s/refunds", RequestType.POST.toString()});
            this.put("payins_directdebit-direct_create", new String[]{"/payins/directdebit/direct", RequestType.POST.toString()});
            this.put("payouts_bankwire_create", new String[]{"/payouts/bankwire/", RequestType.POST.toString()});
            this.put("payouts_get", new String[]{"/payouts/%s", RequestType.GET.toString()});
            this.put("refunds_get", new String[]{"/refunds/%s", RequestType.GET.toString()});
            this.put("transfers_create", new String[]{"/transfers", RequestType.POST.toString()});
            this.put("transfers_get", new String[]{"/transfers/%s", RequestType.GET.toString()});
            this.put("transfers_getrefunds", new String[]{"/transfers/%s/refunds", RequestType.GET.toString()});
            this.put("transfers_createrefunds", new String[]{"/transfers/%s/refunds", RequestType.POST.toString()});
            this.put("users_createnaturals", new String[]{"/users/natural", RequestType.POST.toString()});
            this.put("users_createlegals", new String[]{"/users/legal", RequestType.POST.toString()});
            this.put("users_createbankaccounts_iban", new String[]{"/users/%s/bankaccounts/iban", RequestType.POST.toString()});
            this.put("users_createbankaccounts_gb", new String[]{"/users/%s/bankaccounts/gb", RequestType.POST.toString()});
            this.put("users_createbankaccounts_us", new String[]{"/users/%s/bankaccounts/us", RequestType.POST.toString()});
            this.put("users_createbankaccounts_ca", new String[]{"/users/%s/bankaccounts/ca", RequestType.POST.toString()});
            this.put("users_createbankaccounts_other", new String[]{"/users/%s/bankaccounts/other", RequestType.POST.toString()});
            this.put("users_savebankaccount", new String[]{"/users/%s/bankaccounts/%s", RequestType.PUT.toString()});
            this.put("users_all", new String[]{"/users", RequestType.GET.toString()});
            this.put("users_allwallets", new String[]{"/users/%s/wallets", RequestType.GET.toString()});
            this.put("users_allbankaccount", new String[]{"/users/%s/bankaccounts", RequestType.GET.toString()});
            this.put("users_allcards", new String[]{"/users/%s/cards", RequestType.GET.toString()});
            this.put("users_alltransactions", new String[]{"/users/%s/transactions", RequestType.GET.toString()});
            this.put("users_allkycdocuments", new String[]{"/users/%s/KYC/documents", RequestType.GET.toString()});
            this.put("users_get", new String[]{"/users/%s", RequestType.GET.toString()});
            this.put("users_getnaturals", new String[]{"/users/natural/%s", RequestType.GET.toString()});
            this.put("users_getlegals", new String[]{"/users/legal/%s", RequestType.GET.toString()});
            this.put("users_getbankaccount", new String[]{"/users/%s/bankaccounts/%s", RequestType.GET.toString()});
            this.put("users_savenaturals", new String[]{"/users/natural/%s", RequestType.PUT.toString()});
            this.put("users_savelegals", new String[]{"/users/legal/%s", RequestType.PUT.toString()});
            this.put("wallets_create", new String[]{"/wallets", RequestType.POST.toString()});
            this.put("wallets_alltransactions", new String[]{"/wallets/%s/transactions", RequestType.GET.toString()});
            this.put("wallets_get", new String[]{"/wallets/%s", RequestType.GET.toString()});
            this.put("wallets_save", new String[]{"/wallets/%s", RequestType.PUT.toString()});
            this.put("users_createkycdocument", new String[]{"/users/%s/KYC/documents/", RequestType.POST.toString()});
            this.put("users_getkycdocument", new String[]{"/users/%s/KYC/documents/%s", RequestType.GET.toString()});
            this.put("users_savekycdocument", new String[]{"/users/%s/KYC/documents/%s", RequestType.PUT.toString()});
            this.put("kyc_page_create", new String[]{"/users/%s/KYC/documents/%s/pages", RequestType.POST.toString()});
            this.put("kyc_documents_all", new String[]{"/KYC/documents", RequestType.GET.toString()});
            this.put("kyc_document_get", new String[]{"/KYC/documents/%s", RequestType.GET.toString()});
            this.put("disputes_get", new String[]{"/disputes/%s", RequestType.GET.toString()});
            this.put("disputes_save_tag", new String[]{"/disputes/%s", RequestType.PUT.toString()});
            this.put("disputes_save_contest_funds", new String[]{"/disputes/%s/submit", RequestType.PUT.toString()});
            this.put("disputes_save_close", new String[]{"/disputes/%s/close", RequestType.PUT.toString()});
            this.put("disputes_get_transactions", new String[]{"/disputes/%s/transactions", RequestType.GET.toString()});
            this.put("disputes_get_all", new String[]{"/disputes", RequestType.GET.toString()});
            this.put("disputes_get_for_wallet", new String[]{"/wallets/%s/disputes", RequestType.GET.toString()});
            this.put("disputes_get_for_user", new String[]{"/users/%s/disputes", RequestType.GET.toString()});
            this.put("disputes_document_create", new String[]{"/disputes/%s/documents", RequestType.POST.toString()});
            this.put("disputes_document_page_create", new String[]{"/disputes/%s/documents/%s/pages", RequestType.POST.toString()});
            this.put("disputes_document_submit", new String[]{"/disputes/%s/documents/%s", RequestType.PUT.toString()});
            this.put("disputes_document_get", new String[]{"/dispute-documents/%s", RequestType.GET.toString()});
            this.put("disputes_document_get_for_dispute", new String[]{"/disputes/%s/documents", RequestType.GET.toString()});
            this.put("disputes_document_get_for_client", new String[]{"/dispute-documents", RequestType.GET.toString()});
            this.put("disputes_repudiation_get", new String[]{"/repudiations/%s", RequestType.GET.toString()});
            this.put("disputes_repudiation_create_settlement", new String[]{"/repudiations/%s/settlementtransfer", RequestType.POST.toString()});
            this.put("idempotency_response_get", new String[]{"/responses/%s", RequestType.GET.toString()});
            this.put("mandate_create", new String[]{"/mandates/directdebit/web", RequestType.POST.toString()});
            this.put("mandate_cancel", new String[]{"/mandates/%s/cancel", RequestType.PUT.toString()});
            this.put("mandate_get", new String[]{"/mandates/%s", RequestType.GET.toString()});
            this.put("mandates_get_all", new String[]{"/mandates", RequestType.GET.toString()});
            this.put("mandates_get_for_user", new String[]{"/users/%s/mandates", RequestType.GET.toString()});
            this.put("mandates_get_for_bank_account", new String[]{"/users/%s/bankaccounts/%s/mandates", RequestType.GET.toString()});
            this.put("reports_request", new String[]{"/reports/%s", RequestType.POST.toString()});
            this.put("reports_get_all", new String[]{"/reports", RequestType.GET.toString()});
            this.put("reports_get", new String[]{"/reports/%s", RequestType.GET.toString()});
            this.put("temp_paymentcards_create", new String[]{"/temp/paymentcards", RequestType.POST.toString()});
            this.put("temp_paymentcards_get", new String[]{"/temp/paymentcards/%s", RequestType.GET.toString()});
            this.put("temp_immediatepayins_create", new String[]{"/temp/immediate-payins", RequestType.POST.toString()});
        }
    };

    public ApiBase(MangoPayApi root) {
        this._root = root;
    }

    protected String getRequestUrl(String key) throws Exception {
        String result = "";
        try {
            result = this.methods.get(key)[0];
        }
        catch (Exception ex) {
            throw new Exception("Unknown method key: " + key);
        }
        return result;
    }

    protected String getRequestType(String key) {
        return this.methods.get(key)[1];
    }

    protected <T extends Dto> T createObject(Class<T> classOfT, String idempotencyKey, String methodKey, T entity, String entityId, String secondEntityId) throws Exception {
        String urlMethod = entityId.length() == 0 ? this.getRequestUrl(methodKey) : (secondEntityId.length() == 0 ? String.format(this.getRequestUrl(methodKey), entityId) : String.format(this.getRequestUrl(methodKey), entityId, secondEntityId));
        RestTool rest = new RestTool(this._root, true);
        T result = rest.request(classOfT, idempotencyKey, urlMethod, this.getRequestType(methodKey), null, null, entity);
        return result;
    }

    protected <T extends Dto> T createObject(Class<T> classOfT, String idempotencyKey, String methodKey, T entity, String entityId) throws Exception {
        return this.createObject(classOfT, idempotencyKey, methodKey, entity, entityId, "");
    }

    protected <T extends Dto> T createObject(Class<T> classOfT, String idempotencyKey, String methodKey, T entity) throws Exception {
        return this.createObject(classOfT, idempotencyKey, methodKey, entity, "");
    }

    protected <T extends Dto> T getObject(Class<T> classOfT, String methodKey, String entityId, String secondEntityId) throws Exception {
        String urlMethod = String.format(this.getRequestUrl(methodKey), entityId, secondEntityId);
        RestTool rest = new RestTool(this._root, true);
        T response = rest.request(classOfT, null, urlMethod, this.getRequestType(methodKey));
        return response;
    }

    protected <T extends Dto> T getObject(Class<T> classOfT, String methodKey, String entityId) throws Exception {
        return this.getObject(classOfT, methodKey, entityId, "");
    }

    protected <T extends Dto> List<T> getList(Class<T[]> classOfT, Class<T> classOfTItem, String methodKey, Pagination pagination, String entityId, String secondEntityId, Map<String, String> filter, Sorting sorting) throws Exception {
        String urlMethod = "";
        urlMethod = entityId != null && entityId.length() > 0 && secondEntityId != null && secondEntityId.length() > 0 ? String.format(this.getRequestUrl(methodKey), entityId, secondEntityId) : (entityId != null && entityId.length() > 0 ? String.format(this.getRequestUrl(methodKey), entityId) : this.getRequestUrl(methodKey));
        if (pagination == null) {
            pagination = new Pagination();
        }
        HashMap<String, String> additionalUrlParams = new HashMap<String, String>();
        if (filter != null) {
            additionalUrlParams.putAll(filter);
        }
        if (sorting != null) {
            additionalUrlParams.putAll(sorting.GetSortParameter());
        }
        RestTool rest = new RestTool(this._root, true);
        return rest.requestList(classOfT, classOfTItem, urlMethod, this.getRequestType(methodKey), null, pagination, additionalUrlParams);
    }

    protected <T extends Dto> List<T> getList(Class<T[]> classOfT, Class<T> classOfTItem, String methodKey, Pagination pagination, String entityId, Map<String, String> filter, Sorting sorting) throws Exception {
        return this.getList(classOfT, classOfTItem, methodKey, pagination, entityId, null, filter, sorting);
    }

    protected <T extends Dto> List<T> getList(Class<T[]> classOfT, Class<T> classOfTItem, String methodKey, Pagination pagination, String entityId, Sorting sorting) throws Exception {
        return this.getList(classOfT, classOfTItem, methodKey, pagination, entityId, null, null, sorting);
    }

    protected <T extends Dto> List<T> getList(Class<T[]> classOfT, Class<T> classOfTItem, String methodKey, Pagination pagination, String entityId) throws Exception {
        return this.getList(classOfT, classOfTItem, methodKey, pagination, entityId, null, null, null);
    }

    protected <T extends Dto> List<T> getList(Class<T[]> classOfT, Class<T> classOfTItem, String methodKey, Pagination pagination) throws Exception {
        return this.getList(classOfT, classOfTItem, methodKey, pagination, "", null);
    }

    protected <T extends Dto> List<T> getList(Class<T[]> classOfT, Class<T> classOfTItem, String methodKey, Pagination pagination, Sorting sorting) throws Exception {
        return this.getList(classOfT, classOfTItem, methodKey, pagination, "", sorting);
    }

    protected <T extends Dto> T updateObject(Class<T> classOfT, String methodKey, T entity) throws Exception {
        return this.updateObject(classOfT, methodKey, entity, "", "");
    }

    protected <T extends Dto> T updateObject(Class<T> classOfT, String methodKey, T entity, String entityId) throws Exception {
        return this.updateObject(classOfT, methodKey, entity, entityId, "");
    }

    protected <T extends Dto> T updateObject(Class<T> classOfT, String methodKey, T entity, String entityId, String secondEntityId) throws Exception {
        if (entity instanceof EntityBase) {
            String urlMethod = secondEntityId.length() > 0 ? String.format(this.getRequestUrl(methodKey), entityId, secondEntityId) : (entityId.length() > 0 ? String.format(this.getRequestUrl(methodKey), entityId, ((EntityBase)entity).Id) : String.format(this.getRequestUrl(methodKey), ((EntityBase)entity).Id));
            RestTool rest = new RestTool(this._root, true);
            return rest.request(classOfT, null, urlMethod, this.getRequestType(methodKey), null, null, entity);
        }
        return null;
    }
}

