/*
 * Decompiled with CFR 0.152.
 */
package com.makeramen;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.widget.ImageView;
import com.makeramen.R;
import com.makeramen.RoundedDrawable;

public class RoundedImageView
extends ImageView {
    public static final String TAG = "RoundedImageView";
    public static final int DEFAULT_RADIUS = 0;
    public static final int DEFAULT_BORDER = 0;
    private int mCornerRadius;
    private int mBorderWidth;
    private ColorStateList mBorderColor;
    private boolean mRoundBackground = false;
    private boolean mOval = false;
    private Drawable mDrawable;
    private Drawable mBackgroundDrawable;
    private ImageView.ScaleType mScaleType;
    private static final ImageView.ScaleType[] sScaleTypeArray = new ImageView.ScaleType[]{ImageView.ScaleType.MATRIX, ImageView.ScaleType.FIT_XY, ImageView.ScaleType.FIT_START, ImageView.ScaleType.FIT_CENTER, ImageView.ScaleType.FIT_END, ImageView.ScaleType.CENTER, ImageView.ScaleType.CENTER_CROP, ImageView.ScaleType.CENTER_INSIDE};

    public RoundedImageView(Context context) {
        super(context);
        this.mCornerRadius = 0;
        this.mBorderWidth = 0;
        this.mBorderColor = ColorStateList.valueOf((int)-16777216);
    }

    public RoundedImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public RoundedImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.RoundedImageView, defStyle, 0);
        int index = a.getInt(0, -1);
        if (index >= 0) {
            this.setScaleType(sScaleTypeArray[index]);
        }
        this.mCornerRadius = a.getDimensionPixelSize(1, -1);
        this.mBorderWidth = a.getDimensionPixelSize(2, -1);
        if (this.mCornerRadius < 0) {
            this.mCornerRadius = 0;
        }
        if (this.mBorderWidth < 0) {
            this.mBorderWidth = 0;
        }
        this.mBorderColor = a.getColorStateList(3);
        if (this.mBorderColor == null) {
            this.mBorderColor = ColorStateList.valueOf((int)-16777216);
        }
        this.mRoundBackground = a.getBoolean(4, false);
        this.mOval = a.getBoolean(5, false);
        if (this.mDrawable instanceof RoundedDrawable) {
            this.updateDrawableAttrs((RoundedDrawable)this.mDrawable);
        }
        if (this.mRoundBackground) {
            if (!(this.mBackgroundDrawable instanceof RoundedDrawable)) {
                this.setBackgroundDrawable(this.mBackgroundDrawable);
            }
            if (this.mBackgroundDrawable instanceof RoundedDrawable) {
                this.updateDrawableAttrs((RoundedDrawable)this.mBackgroundDrawable);
            }
        }
        a.recycle();
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        this.invalidate();
    }

    public void setScaleType(ImageView.ScaleType scaleType) {
        if (scaleType == null) {
            throw new NullPointerException();
        }
        if (this.mScaleType != scaleType) {
            this.mScaleType = scaleType;
            switch (scaleType) {
                case CENTER: 
                case CENTER_CROP: 
                case CENTER_INSIDE: 
                case FIT_CENTER: 
                case FIT_START: 
                case FIT_END: 
                case FIT_XY: {
                    super.setScaleType(ImageView.ScaleType.FIT_XY);
                    break;
                }
                default: {
                    super.setScaleType(scaleType);
                }
            }
            if (this.mDrawable instanceof RoundedDrawable && ((RoundedDrawable)this.mDrawable).getScaleType() != scaleType) {
                ((RoundedDrawable)this.mDrawable).setScaleType(scaleType);
            }
            if (this.mBackgroundDrawable instanceof RoundedDrawable && ((RoundedDrawable)this.mBackgroundDrawable).getScaleType() != scaleType) {
                ((RoundedDrawable)this.mBackgroundDrawable).setScaleType(scaleType);
            }
            this.setWillNotCacheDrawing(true);
            this.requestLayout();
            this.invalidate();
        }
    }

    public ImageView.ScaleType getScaleType() {
        return this.mScaleType;
    }

    public void setImageDrawable(Drawable drawable) {
        if (drawable != null) {
            this.mDrawable = RoundedDrawable.fromDrawable(drawable, this.mCornerRadius, this.mBorderWidth, this.mBorderColor, this.mOval);
            this.updateDrawableAttrs((RoundedDrawable)this.mDrawable);
        } else {
            this.mDrawable = null;
        }
        super.setImageDrawable(this.mDrawable);
    }

    public void setImageBitmap(Bitmap bm) {
        if (bm != null) {
            this.mDrawable = new RoundedDrawable(bm, this.mCornerRadius, this.mBorderWidth, this.mBorderColor, this.mOval);
            this.updateDrawableAttrs((RoundedDrawable)this.mDrawable);
        } else {
            this.mDrawable = null;
        }
        super.setImageDrawable(this.mDrawable);
    }

    public void setBackground(Drawable background) {
        this.setBackgroundDrawable(background);
    }

    private void updateDrawableAttrs(RoundedDrawable drawable) {
        drawable.setScaleType(this.mScaleType);
        drawable.setCornerRadius(this.mCornerRadius);
        drawable.setBorderWidth(this.mBorderWidth);
        drawable.setBorderColors(this.mBorderColor);
        drawable.setOval(this.mOval);
    }

    @Deprecated
    public void setBackgroundDrawable(Drawable background) {
        if (this.mRoundBackground && background != null) {
            this.mBackgroundDrawable = RoundedDrawable.fromDrawable(background, this.mCornerRadius, this.mBorderWidth, this.mBorderColor, this.mOval);
            this.updateDrawableAttrs((RoundedDrawable)this.mBackgroundDrawable);
        } else {
            this.mBackgroundDrawable = background;
        }
        super.setBackgroundDrawable(this.mBackgroundDrawable);
    }

    public int getCornerRadius() {
        return this.mCornerRadius;
    }

    public int getBorder() {
        return this.mBorderWidth;
    }

    public int getBorderColor() {
        return this.mBorderColor.getDefaultColor();
    }

    public ColorStateList getBorderColors() {
        return this.mBorderColor;
    }

    public void setCornerRadius(int radius) {
        if (this.mCornerRadius == radius) {
            return;
        }
        this.mCornerRadius = radius;
        if (this.mDrawable instanceof RoundedDrawable) {
            ((RoundedDrawable)this.mDrawable).setCornerRadius(radius);
        }
        if (this.mRoundBackground && this.mBackgroundDrawable instanceof RoundedDrawable) {
            ((RoundedDrawable)this.mBackgroundDrawable).setCornerRadius(radius);
        }
    }

    public void setBorderWidth(int width) {
        if (this.mBorderWidth == width) {
            return;
        }
        this.mBorderWidth = width;
        if (this.mDrawable instanceof RoundedDrawable) {
            ((RoundedDrawable)this.mDrawable).setBorderWidth(width);
        }
        if (this.mRoundBackground && this.mBackgroundDrawable instanceof RoundedDrawable) {
            ((RoundedDrawable)this.mBackgroundDrawable).setBorderWidth(width);
        }
        this.invalidate();
    }

    public void setBorderColor(int color) {
        this.setBorderColors(ColorStateList.valueOf((int)color));
    }

    public void setBorderColors(ColorStateList colors) {
        if (this.mBorderColor.equals(colors)) {
            return;
        }
        ColorStateList colorStateList = this.mBorderColor = colors != null ? colors : ColorStateList.valueOf((int)-16777216);
        if (this.mDrawable instanceof RoundedDrawable) {
            ((RoundedDrawable)this.mDrawable).setBorderColors(colors);
        }
        if (this.mRoundBackground && this.mBackgroundDrawable instanceof RoundedDrawable) {
            ((RoundedDrawable)this.mBackgroundDrawable).setBorderColors(colors);
        }
        if (this.mBorderWidth > 0) {
            this.invalidate();
        }
    }

    public void setOval(boolean oval) {
        this.mOval = oval;
        if (this.mDrawable instanceof RoundedDrawable) {
            ((RoundedDrawable)this.mDrawable).setOval(oval);
        }
        if (this.mRoundBackground && this.mBackgroundDrawable instanceof RoundedDrawable) {
            ((RoundedDrawable)this.mBackgroundDrawable).setOval(oval);
        }
        this.invalidate();
    }

    public boolean isOval() {
        return this.mOval;
    }

    public void setImageResource(int resId) {
        super.setImageResource(resId);
        this.setImageDrawable(this.getDrawable());
    }

    public boolean isRoundBackground() {
        return this.mRoundBackground;
    }

    public void setRoundBackground(boolean roundBackground) {
        if (this.mRoundBackground == roundBackground) {
            return;
        }
        this.mRoundBackground = roundBackground;
        if (roundBackground) {
            if (this.mBackgroundDrawable instanceof RoundedDrawable) {
                this.updateDrawableAttrs((RoundedDrawable)this.mBackgroundDrawable);
            } else {
                this.setBackgroundDrawable(this.mBackgroundDrawable);
            }
        } else if (this.mBackgroundDrawable instanceof RoundedDrawable) {
            ((RoundedDrawable)this.mBackgroundDrawable).setBorderWidth(0);
            ((RoundedDrawable)this.mBackgroundDrawable).setCornerRadius(0.0f);
        }
        this.invalidate();
    }
}

