/*
 * Decompiled with CFR 0.152.
 */
package com.mailosaur;

import com.google.api.client.json.GenericJson;
import com.mailosaur.MailosaurClient;
import com.mailosaur.MailosaurException;
import com.mailosaur.models.Server;
import com.mailosaur.models.ServerCreateOptions;
import com.mailosaur.models.ServerListResult;
import java.io.IOException;
import java.util.Random;

public class Servers {
    private MailosaurClient client;
    private Random random = new Random();

    public Servers(MailosaurClient client) {
        this.client = client;
    }

    public ServerListResult list() throws IOException, MailosaurException {
        return (ServerListResult)this.client.request("GET", "api/servers").parseAs(ServerListResult.class);
    }

    public Server create(ServerCreateOptions options) throws IOException, MailosaurException {
        return (Server)this.client.request("POST", "api/servers", options).parseAs(Server.class);
    }

    public Server get(String serverId) throws IOException, MailosaurException {
        return (Server)this.client.request("GET", "api/servers/" + serverId).parseAs(Server.class);
    }

    public String getPassword(String serverId) throws IOException, MailosaurException {
        GenericJson json = (GenericJson)this.client.request("GET", "api/servers/" + serverId + "/password").parseAs(GenericJson.class);
        return json.get((Object)"value").toString();
    }

    public Server update(String serverId, Server server) throws IOException, MailosaurException {
        return (Server)this.client.request("PUT", "api/servers/" + serverId, server).parseAs(Server.class);
    }

    public void delete(String serverId) throws MailosaurException {
        this.client.request("DELETE", "api/servers/" + serverId);
    }

    public String generateEmailAddress(String serverId) {
        String host = System.getenv("MAILOSAUR_SMTP_HOST");
        host = host != null ? host : "mailosaur.net";
        String randomString = String.valueOf(this.random.nextInt(10000000));
        return String.format("%s@%s.%s", randomString, serverId, host);
    }
}

