/*
 * Decompiled with CFR 0.152.
 */
package com.mailjet.client.transactional;

import com.google.gson.annotations.SerializedName;
import com.mailjet.client.transactional.Attachment;
import com.mailjet.client.transactional.SendContact;
import com.mailjet.client.transactional.TrackClicks;
import com.mailjet.client.transactional.TrackOpens;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class TransactionalEmail {
    private String subject;
    @SerializedName(value="HTMLPart")
    private String htmlPart;
    private String textPart;
    private SendContact sender;
    private SendContact from;
    private SendContact replyTo;
    private List<SendContact> to;
    private List<SendContact> cc;
    private List<SendContact> bcc;
    private Long templateID;
    private Boolean templateLanguage;
    private SendContact templateErrorReporting;
    private Boolean templateErrorDelivery;
    private List<Attachment> attachments;
    private List<Attachment> inlinedAttachments;
    private Integer priority;
    private String customCampaign;
    private Boolean deduplicateCampaign;
    private TrackOpens trackOpens;
    private TrackClicks trackClicks;
    private String customID;
    private String eventPayload;
    @SerializedName(value="URLTags")
    private String urlTags;
    private Map<String, Object> headers;
    private Map<String, Object> variables;

    TransactionalEmail(String subject, String htmlPart, String textPart, SendContact sender, SendContact from, SendContact replyTo, List<SendContact> to, List<SendContact> cc, List<SendContact> bcc, Long templateID, Boolean templateLanguage, SendContact templateErrorReporting, Boolean templateErrorDelivery, List<Attachment> attachments, List<Attachment> inlinedAttachments, Integer priority, String customCampaign, Boolean deduplicateCampaign, TrackOpens trackOpens, TrackClicks trackClicks, String customID, String eventPayload, String urlTags, Map<String, Object> headers, Map<String, Object> variables) {
        this.subject = subject;
        this.htmlPart = htmlPart;
        this.textPart = textPart;
        this.sender = sender;
        this.from = from;
        this.replyTo = replyTo;
        this.to = to;
        this.cc = cc;
        this.bcc = bcc;
        this.templateID = templateID;
        this.templateLanguage = templateLanguage;
        this.templateErrorReporting = templateErrorReporting;
        this.templateErrorDelivery = templateErrorDelivery;
        this.attachments = attachments;
        this.inlinedAttachments = inlinedAttachments;
        this.priority = priority;
        this.customCampaign = customCampaign;
        this.deduplicateCampaign = deduplicateCampaign;
        this.trackOpens = trackOpens;
        this.trackClicks = trackClicks;
        this.customID = customID;
        this.eventPayload = eventPayload;
        this.urlTags = urlTags;
        this.headers = headers;
        this.variables = variables;
    }

    public static TransactionalEmailBuilder builder() {
        return new TransactionalEmailBuilder();
    }

    public static class TransactionalEmailBuilder {
        private String subject;
        private String htmlPart;
        private String textPart;
        private SendContact sender;
        private SendContact from;
        private SendContact replyTo;
        private ArrayList<SendContact> to;
        private ArrayList<SendContact> cc;
        private ArrayList<SendContact> bcc;
        private Long templateID;
        private Boolean templateLanguage;
        private SendContact templateErrorReporting;
        private Boolean templateErrorDelivery;
        private ArrayList<Attachment> attachments;
        private ArrayList<Attachment> inlinedAttachments;
        private Integer priority;
        private String customCampaign;
        private Boolean deduplicateCampaign;
        private TrackOpens trackOpens;
        private TrackClicks trackClicks;
        private String customID;
        private String eventPayload;
        private String urlTags;
        private ArrayList<String> headers$key;
        private ArrayList<Object> headers$value;
        private ArrayList<String> variables$key;
        private ArrayList<Object> variables$value;

        TransactionalEmailBuilder() {
        }

        public TransactionalEmailBuilder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public TransactionalEmailBuilder htmlPart(String htmlPart) {
            this.htmlPart = htmlPart;
            return this;
        }

        public TransactionalEmailBuilder textPart(String textPart) {
            this.textPart = textPart;
            return this;
        }

        public TransactionalEmailBuilder sender(SendContact sender) {
            this.sender = sender;
            return this;
        }

        public TransactionalEmailBuilder from(SendContact from) {
            this.from = from;
            return this;
        }

        public TransactionalEmailBuilder replyTo(SendContact replyTo) {
            this.replyTo = replyTo;
            return this;
        }

        public TransactionalEmailBuilder to(SendContact to) {
            if (this.to == null) {
                this.to = new ArrayList();
            }
            this.to.add(to);
            return this;
        }

        public TransactionalEmailBuilder to(Collection<? extends SendContact> to) {
            if (to == null) {
                throw new NullPointerException("to cannot be null");
            }
            if (this.to == null) {
                this.to = new ArrayList();
            }
            this.to.addAll(to);
            return this;
        }

        public TransactionalEmailBuilder clearTo() {
            if (this.to != null) {
                this.to.clear();
            }
            return this;
        }

        public TransactionalEmailBuilder cc(SendContact cc) {
            if (this.cc == null) {
                this.cc = new ArrayList();
            }
            this.cc.add(cc);
            return this;
        }

        public TransactionalEmailBuilder cc(Collection<? extends SendContact> cc) {
            if (cc == null) {
                throw new NullPointerException("cc cannot be null");
            }
            if (this.cc == null) {
                this.cc = new ArrayList();
            }
            this.cc.addAll(cc);
            return this;
        }

        public TransactionalEmailBuilder clearCc() {
            if (this.cc != null) {
                this.cc.clear();
            }
            return this;
        }

        public TransactionalEmailBuilder bcc(SendContact bcc) {
            if (this.bcc == null) {
                this.bcc = new ArrayList();
            }
            this.bcc.add(bcc);
            return this;
        }

        public TransactionalEmailBuilder bcc(Collection<? extends SendContact> bcc) {
            if (bcc == null) {
                throw new NullPointerException("bcc cannot be null");
            }
            if (this.bcc == null) {
                this.bcc = new ArrayList();
            }
            this.bcc.addAll(bcc);
            return this;
        }

        public TransactionalEmailBuilder clearBcc() {
            if (this.bcc != null) {
                this.bcc.clear();
            }
            return this;
        }

        public TransactionalEmailBuilder templateID(Long templateID) {
            this.templateID = templateID;
            return this;
        }

        public TransactionalEmailBuilder templateLanguage(Boolean templateLanguage) {
            this.templateLanguage = templateLanguage;
            return this;
        }

        public TransactionalEmailBuilder templateErrorReporting(SendContact templateErrorReporting) {
            this.templateErrorReporting = templateErrorReporting;
            return this;
        }

        public TransactionalEmailBuilder templateErrorDelivery(Boolean templateErrorDelivery) {
            this.templateErrorDelivery = templateErrorDelivery;
            return this;
        }

        public TransactionalEmailBuilder attachment(Attachment attachment) {
            if (this.attachments == null) {
                this.attachments = new ArrayList();
            }
            this.attachments.add(attachment);
            return this;
        }

        public TransactionalEmailBuilder attachments(Collection<? extends Attachment> attachments) {
            if (attachments == null) {
                throw new NullPointerException("attachments cannot be null");
            }
            if (this.attachments == null) {
                this.attachments = new ArrayList();
            }
            this.attachments.addAll(attachments);
            return this;
        }

        public TransactionalEmailBuilder clearAttachments() {
            if (this.attachments != null) {
                this.attachments.clear();
            }
            return this;
        }

        public TransactionalEmailBuilder inlinedAttachment(Attachment inlinedAttachment) {
            if (this.inlinedAttachments == null) {
                this.inlinedAttachments = new ArrayList();
            }
            this.inlinedAttachments.add(inlinedAttachment);
            return this;
        }

        public TransactionalEmailBuilder inlinedAttachments(Collection<? extends Attachment> inlinedAttachments) {
            if (inlinedAttachments == null) {
                throw new NullPointerException("inlinedAttachments cannot be null");
            }
            if (this.inlinedAttachments == null) {
                this.inlinedAttachments = new ArrayList();
            }
            this.inlinedAttachments.addAll(inlinedAttachments);
            return this;
        }

        public TransactionalEmailBuilder clearInlinedAttachments() {
            if (this.inlinedAttachments != null) {
                this.inlinedAttachments.clear();
            }
            return this;
        }

        public TransactionalEmailBuilder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public TransactionalEmailBuilder customCampaign(String customCampaign) {
            this.customCampaign = customCampaign;
            return this;
        }

        public TransactionalEmailBuilder deduplicateCampaign(Boolean deduplicateCampaign) {
            this.deduplicateCampaign = deduplicateCampaign;
            return this;
        }

        public TransactionalEmailBuilder trackOpens(TrackOpens trackOpens) {
            this.trackOpens = trackOpens;
            return this;
        }

        public TransactionalEmailBuilder trackClicks(TrackClicks trackClicks) {
            this.trackClicks = trackClicks;
            return this;
        }

        public TransactionalEmailBuilder customID(String customID) {
            this.customID = customID;
            return this;
        }

        public TransactionalEmailBuilder eventPayload(String eventPayload) {
            this.eventPayload = eventPayload;
            return this;
        }

        public TransactionalEmailBuilder urlTags(String urlTags) {
            this.urlTags = urlTags;
            return this;
        }

        public TransactionalEmailBuilder header(String headerKey, Object headerValue) {
            if (this.headers$key == null) {
                this.headers$key = new ArrayList();
                this.headers$value = new ArrayList();
            }
            this.headers$key.add(headerKey);
            this.headers$value.add(headerValue);
            return this;
        }

        public TransactionalEmailBuilder headers(Map<? extends String, ? extends Object> headers) {
            if (headers == null) {
                throw new NullPointerException("headers cannot be null");
            }
            if (this.headers$key == null) {
                this.headers$key = new ArrayList();
                this.headers$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Object> $lombokEntry : headers.entrySet()) {
                this.headers$key.add($lombokEntry.getKey());
                this.headers$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public TransactionalEmailBuilder clearHeaders() {
            if (this.headers$key != null) {
                this.headers$key.clear();
                this.headers$value.clear();
            }
            return this;
        }

        public TransactionalEmailBuilder variable(String variableKey, Object variableValue) {
            if (this.variables$key == null) {
                this.variables$key = new ArrayList();
                this.variables$value = new ArrayList();
            }
            this.variables$key.add(variableKey);
            this.variables$value.add(variableValue);
            return this;
        }

        public TransactionalEmailBuilder variables(Map<? extends String, ? extends Object> variables) {
            if (variables == null) {
                throw new NullPointerException("variables cannot be null");
            }
            if (this.variables$key == null) {
                this.variables$key = new ArrayList();
                this.variables$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Object> $lombokEntry : variables.entrySet()) {
                this.variables$key.add($lombokEntry.getKey());
                this.variables$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public TransactionalEmailBuilder clearVariables() {
            if (this.variables$key != null) {
                this.variables$key.clear();
                this.variables$value.clear();
            }
            return this;
        }

        public TransactionalEmail build() {
            Map<Object, Object> variables;
            Map<Object, Object> headers;
            List<Attachment> inlinedAttachments;
            List<Attachment> attachments;
            List<SendContact> bcc;
            List<SendContact> cc;
            List<SendContact> to;
            switch (this.to == null ? 0 : this.to.size()) {
                case 0: {
                    to = Collections.emptyList();
                    break;
                }
                case 1: {
                    to = Collections.singletonList(this.to.get(0));
                    break;
                }
                default: {
                    to = Collections.unmodifiableList(new ArrayList<SendContact>(this.to));
                }
            }
            switch (this.cc == null ? 0 : this.cc.size()) {
                case 0: {
                    cc = Collections.emptyList();
                    break;
                }
                case 1: {
                    cc = Collections.singletonList(this.cc.get(0));
                    break;
                }
                default: {
                    cc = Collections.unmodifiableList(new ArrayList<SendContact>(this.cc));
                }
            }
            switch (this.bcc == null ? 0 : this.bcc.size()) {
                case 0: {
                    bcc = Collections.emptyList();
                    break;
                }
                case 1: {
                    bcc = Collections.singletonList(this.bcc.get(0));
                    break;
                }
                default: {
                    bcc = Collections.unmodifiableList(new ArrayList<SendContact>(this.bcc));
                }
            }
            switch (this.attachments == null ? 0 : this.attachments.size()) {
                case 0: {
                    attachments = Collections.emptyList();
                    break;
                }
                case 1: {
                    attachments = Collections.singletonList(this.attachments.get(0));
                    break;
                }
                default: {
                    attachments = Collections.unmodifiableList(new ArrayList<Attachment>(this.attachments));
                }
            }
            switch (this.inlinedAttachments == null ? 0 : this.inlinedAttachments.size()) {
                case 0: {
                    inlinedAttachments = Collections.emptyList();
                    break;
                }
                case 1: {
                    inlinedAttachments = Collections.singletonList(this.inlinedAttachments.get(0));
                    break;
                }
                default: {
                    inlinedAttachments = Collections.unmodifiableList(new ArrayList<Attachment>(this.inlinedAttachments));
                }
            }
            switch (this.headers$key == null ? 0 : this.headers$key.size()) {
                case 0: {
                    headers = Collections.emptyMap();
                    break;
                }
                case 1: {
                    headers = Collections.singletonMap(this.headers$key.get(0), this.headers$value.get(0));
                    break;
                }
                default: {
                    headers = new LinkedHashMap(this.headers$key.size() < 0x40000000 ? 1 + this.headers$key.size() + (this.headers$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.headers$key.size(); ++$i) {
                        headers.put(this.headers$key.get($i), this.headers$value.get($i));
                    }
                    headers = Collections.unmodifiableMap(headers);
                }
            }
            switch (this.variables$key == null ? 0 : this.variables$key.size()) {
                case 0: {
                    variables = Collections.emptyMap();
                    break;
                }
                case 1: {
                    variables = Collections.singletonMap(this.variables$key.get(0), this.variables$value.get(0));
                    break;
                }
                default: {
                    variables = new LinkedHashMap(this.variables$key.size() < 0x40000000 ? 1 + this.variables$key.size() + (this.variables$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.variables$key.size(); ++$i) {
                        variables.put(this.variables$key.get($i), this.variables$value.get($i));
                    }
                    variables = Collections.unmodifiableMap(variables);
                }
            }
            return new TransactionalEmail(this.subject, this.htmlPart, this.textPart, this.sender, this.from, this.replyTo, to, cc, bcc, this.templateID, this.templateLanguage, this.templateErrorReporting, this.templateErrorDelivery, attachments, inlinedAttachments, this.priority, this.customCampaign, this.deduplicateCampaign, this.trackOpens, this.trackClicks, this.customID, this.eventPayload, this.urlTags, headers, variables);
        }

        public String toString() {
            return "TransactionalEmail.TransactionalEmailBuilder(subject=" + this.subject + ", htmlPart=" + this.htmlPart + ", textPart=" + this.textPart + ", sender=" + this.sender + ", from=" + this.from + ", replyTo=" + this.replyTo + ", to=" + this.to + ", cc=" + this.cc + ", bcc=" + this.bcc + ", templateID=" + this.templateID + ", templateLanguage=" + this.templateLanguage + ", templateErrorReporting=" + this.templateErrorReporting + ", templateErrorDelivery=" + this.templateErrorDelivery + ", attachments=" + this.attachments + ", inlinedAttachments=" + this.inlinedAttachments + ", priority=" + this.priority + ", customCampaign=" + this.customCampaign + ", deduplicateCampaign=" + this.deduplicateCampaign + ", trackOpens=" + (Object)((Object)this.trackOpens) + ", trackClicks=" + (Object)((Object)this.trackClicks) + ", customID=" + this.customID + ", eventPayload=" + this.eventPayload + ", urlTags=" + this.urlTags + ", headers$key=" + this.headers$key + ", headers$value=" + this.headers$value + ", variables$key=" + this.variables$key + ", variables$value=" + this.variables$value + ")";
        }
    }
}

